/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.math.PsRandom;
import flanagan.plot.PlotGraph;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.util.Date;

public class PCA
extends Scores {
    private Matrix data = null;
    private Matrix dataMinusMeans = null;
    private Matrix dataMinusMeansTranspose = null;
    private Matrix covarianceMatrix = null;
    private Matrix correlationMatrix = null;
    private Matrix partialCorrelationMatrix = null;
    private double kmo = 0.0;
    private double[] itemKMOs = null;
    private double chiSquareBartlett = 0.0;
    private int dfBartlett = 0;
    private double probBartlett = 0.0;
    private double sign10Bartlett = 0.0;
    private double sign05Bartlett = 0.0;
    private double[] eigenValues = null;
    private double[] orderedEigenValues = null;
    private int[] eigenValueIndices = null;
    private double eigenValueTotal = 0.0;
    private int[] rotatedIndices = null;
    private double[] rotatedEigenValues = null;
    private double[] usRotatedEigenValues = null;
    private int nMonteCarlo = 200;
    private double[][] randomEigenValues = null;
    private double[] randomEigenValuesMeans = null;
    private double[] randomEigenValuesSDs = null;
    private double[] randomEigenValuesPercentiles = null;
    private double percentile = 95.0;
    private boolean gaussianDeviates = false;
    private double[] proportionPercentage = null;
    private double[] cumulativePercentage = null;
    private double[] rotatedProportionPercentage = null;
    private double[] rotatedCumulativePercentage = null;
    private double[][] eigenVectorsAsColumns = null;
    private double[][] eigenVectorsAsRows = null;
    private double[][] orderedEigenVectorsAsColumns = null;
    private double[][] orderedEigenVectorsAsRows = null;
    private double[][] loadingFactorsAsColumns = null;
    private double[][] loadingFactorsAsRows = null;
    private double[][] rotatedLoadingFactorsAsColumns = null;
    private double[][] rotatedLoadingFactorsAsRows = null;
    private double[][] usRotatedLoadingFactorsAsColumns = null;
    private double[][] usRotatedLoadingFactorsAsRows = null;
    private double[] communalities = null;
    private double[] communalityWeights = null;
    private boolean covRhoOption = false;
    private int greaterThanOneLimit = 0;
    private int percentileCrossover = 0;
    private int meanCrossover = 0;
    private int nVarimaxMax = 1000;
    private int nVarimax = 0;
    private double varimaxTolerance = 1.0E-8;
    private boolean varimaxOption = true;
    private boolean pcaDone = false;
    private boolean monteCarloDone = false;
    private boolean rotationDone = false;

    public PCA() {
        this.trunc = 4;
    }

    public void useCovarianceMatrix() {
        this.covRhoOption = true;
    }

    public void useCorrelationMatrix() {
        this.covRhoOption = false;
    }

    public void useNormalVarimax() {
        this.varimaxOption = true;
    }

    public void useRawVarimax() {
        this.varimaxOption = false;
    }

    public String getVarimaxOption() {
        if (this.varimaxOption) {
            return "normal varimax option";
        }
        return "raw varimax option";
    }

    public void setNumberOfSimulations(int nSimul) {
        this.nMonteCarlo = nSimul;
    }

    public int getNumberOfSimulations() {
        return this.nMonteCarlo;
    }

    public void useGaussianDeviates() {
        this.gaussianDeviates = true;
    }

    public void useUniformDeviates() {
        this.gaussianDeviates = false;
    }

    public void setParallelAnalysisPercentileValue(double percent) {
        this.percentile = percent;
    }

    public double getParallelAnalysisPercentileValue() {
        return this.percentile;
    }

    public void pca() {
        if (!this.pcaDone) {
            int j;
            int i;
            int j2;
            int i2;
            if (this.nItems == 1) {
                throw new IllegalArgumentException("You have entered only one item - PCA is not meaningful");
            }
            if (this.nPersons == 1) {
                throw new IllegalArgumentException("You have entered only one score or measurement source - PCA is not meaningful");
            }
            if (!this.dataPreprocessed) {
                this.preprocessData();
            }
            this.data = new Matrix(this.scores0);
            this.dataMinusMeans = this.data.subtractRowMeans();
            this.dataMinusMeansTranspose = this.dataMinusMeans.transpose();
            this.covarianceMatrix = this.dataMinusMeans.times(this.dataMinusMeansTranspose);
            double denom = this.nPersons;
            if (!this.nFactorOption) {
                denom -= 1.0;
            }
            this.covarianceMatrix = this.covarianceMatrix.times(1.0 / denom);
            boolean tinyCheck = false;
            double[][] cov = this.covarianceMatrix.getArrayCopy();
            double[][] corr = new double[this.nItems][this.nItems];
            for (int i3 = 0; i3 < this.nItems; ++i3) {
                for (int j3 = 0; j3 < this.nItems; ++j3) {
                    if (i3 == j3) {
                        corr[i3][j3] = 1.0;
                        continue;
                    }
                    corr[i3][j3] = cov[i3][j3] / Math.sqrt(cov[i3][i3] * cov[j3][j3]);
                    if (!Fmath.isNaN(corr[i3][j3])) continue;
                    corr[i3][j3] = 0.0;
                }
            }
            this.correlationMatrix = new Matrix(corr);
            double[][] cofactors = new double[this.nItems][this.nItems];
            double[][] partialCorr = new double[this.nItems][this.nItems];
            for (i2 = 0; i2 < this.nItems; ++i2) {
                for (j2 = 0; j2 < this.nItems; ++j2) {
                    cofactors[i2][j2] = this.correlationMatrix.cofactor(i2, j2);
                }
            }
            for (i2 = 0; i2 < this.nItems; ++i2) {
                for (j2 = 0; j2 < this.nItems; ++j2) {
                    partialCorr[i2][j2] = cofactors[i2][j2] == 0.0 && cofactors[i2][i2] == 0.0 && cofactors[j2][j2] == 0.0 ? 1.0 : (i2 == j2 ? 1.0 : -cofactors[i2][j2] / Math.sqrt(cofactors[i2][i2] * cofactors[j2][j2]));
                }
            }
            this.partialCorrelationMatrix = new Matrix(partialCorr);
            double kmor = 0.0;
            double kmoa = 0.0;
            for (i = 0; i < this.nItems; ++i) {
                for (j = 0; j < this.nItems; ++j) {
                    if (i == j) continue;
                    kmor += corr[i][j] * corr[i][j];
                    kmoa += partialCorr[i][j] * partialCorr[i][j];
                }
            }
            this.kmo = kmor == 0.0 && kmoa == 0.0 ? 0.5 : kmor / (kmor + kmoa);
            this.itemKMOs = new double[this.nItems];
            for (i = 0; i < this.nItems; ++i) {
                kmor = 0.0;
                kmoa = 0.0;
                for (j = 0; j < this.nItems; ++j) {
                    if (i == j) continue;
                    kmor += corr[i][j] * corr[i][j];
                    kmoa += partialCorr[i][j] * partialCorr[i][j];
                }
                this.itemKMOs[i] = kmor == 0.0 && kmoa == 0.0 ? 0.5 : kmor / (kmor + kmoa);
            }
            double correlationDeterminant = this.correlationMatrix.determinant();
            this.chiSquareBartlett = -((double)(this.nPersons - 1) - (double)(2 * this.nItems + 5) / 6.0) * Math.log(correlationDeterminant);
            this.dfBartlett = this.nItems * (this.nItems - 1) / 2;
            this.probBartlett = 1.0 - Stat.chiSquareCDF(this.chiSquareBartlett, this.dfBartlett);
            this.sign10Bartlett = Stat.chiSquareInverseCDF(this.dfBartlett, 0.9);
            this.sign05Bartlett = Stat.chiSquareInverseCDF(this.dfBartlett, 0.95);
            Matrix forEigen = null;
            forEigen = this.covRhoOption ? this.covarianceMatrix : this.correlationMatrix;
            this.eigenValues = forEigen.getEigenValues();
            this.orderedEigenValues = forEigen.getSortedEigenValues();
            this.eigenValueIndices = forEigen.eigenValueIndices();
            this.eigenVectorsAsColumns = forEigen.getEigenVectorsAsColumns();
            this.eigenVectorsAsRows = forEigen.getEigenVectorsAsRows();
            this.orderedEigenVectorsAsColumns = forEigen.getSortedEigenVectorsAsColumns();
            this.orderedEigenVectorsAsRows = forEigen.getSortedEigenVectorsAsRows();
            ArrayMaths am = new ArrayMaths(this.orderedEigenValues);
            double total = am.sum();
            am = am.times(100.0 / total);
            this.proportionPercentage = am.array();
            this.cumulativePercentage = new double[this.nItems];
            this.cumulativePercentage[0] = this.proportionPercentage[0];
            this.eigenValueTotal = 0.0;
            for (int i4 = 1; i4 < this.nItems; ++i4) {
                this.cumulativePercentage[i4] = this.cumulativePercentage[i4 - 1] + this.proportionPercentage[i4];
                this.eigenValueTotal += this.eigenValues[i4];
            }
            boolean test = true;
            int counter = 0;
            while (test) {
                if (this.orderedEigenValues[counter] < 1.0) {
                    this.greaterThanOneLimit = counter;
                    test = false;
                    continue;
                }
                if (++counter != this.nItems) continue;
                this.greaterThanOneLimit = counter;
                test = false;
            }
            this.loadingFactorsAsColumns = new double[this.nItems][this.nItems];
            this.loadingFactorsAsRows = new double[this.nItems][this.nItems];
            for (int i5 = 0; i5 < this.nItems; ++i5) {
                for (int j4 = 0; j4 < this.nItems; ++j4) {
                    this.loadingFactorsAsColumns[i5][j4] = this.orderedEigenVectorsAsColumns[i5][j4] * Math.sqrt(Math.abs(this.orderedEigenValues[j4]));
                    this.loadingFactorsAsRows[i5][j4] = this.orderedEigenVectorsAsRows[i5][j4] * Math.sqrt(Math.abs(this.orderedEigenValues[i5]));
                }
            }
            this.communalities = new double[this.nItems];
            this.communalityWeights = new double[this.nItems];
            for (int k = 0; k < this.nItems; ++k) {
                double sum = 0.0;
                for (int j5 = 0; j5 < this.nItems; ++j5) {
                    sum += this.loadingFactorsAsRows[j5][k] * this.loadingFactorsAsRows[j5][k];
                }
                this.communalities[k] = sum;
                this.communalityWeights[k] = Math.sqrt(this.communalities[k]);
            }
        }
        this.pcaDone = true;
    }

    public void monteCarlo() {
        if (!this.pcaDone) {
            this.pca();
        }
        double[] rowMeans = super.rawItemMeans();
        double[] rowSDs = super.rawItemStandardDeviations();
        double[][] randomData = new double[this.nItems][this.nPersons];
        this.randomEigenValues = new double[this.nMonteCarlo][this.nItems];
        PsRandom rr = new PsRandom();
        for (int i = 0; i < this.nMonteCarlo; ++i) {
            for (int j = 0; j < this.nItems; ++j) {
                if (this.gaussianDeviates) {
                    randomData[j] = rr.gaussianArray(rowMeans[j], rowSDs[j], this.nPersons);
                    continue;
                }
                randomData[j] = rr.doubleArray(this.nPersons);
                randomData[j] = Stat.scale(randomData[j], rowMeans[j], rowSDs[j]);
            }
            PCA pca = new PCA();
            if (this.covRhoOption) {
                pca.useCovarianceMatrix();
            } else {
                pca.useCorrelationMatrix();
            }
            pca.enterScoresAsRowPerItem(randomData);
            this.randomEigenValues[i] = pca.orderedEigenValues();
        }
        Matrix mat = new Matrix(this.randomEigenValues);
        this.randomEigenValuesMeans = mat.columnMeans();
        this.randomEigenValuesSDs = mat.columnStandardDeviations();
        this.randomEigenValuesPercentiles = new double[this.nItems];
        int pIndex1 = (int)Math.ceil((double)this.nMonteCarlo * this.percentile / 100.0);
        int pIndex2 = pIndex1 - 1;
        double factor = this.percentile * (double)this.nMonteCarlo / 100.0 - (double)pIndex2;
        --pIndex1;
        --pIndex2;
        for (int j = 0; j < this.nItems; ++j) {
            double[] ordered = new double[this.nMonteCarlo];
            for (int k = 0; k < this.nMonteCarlo; ++k) {
                ordered[k] = this.randomEigenValues[k][j];
            }
            ArrayMaths am = new ArrayMaths(ordered);
            am = am.sort();
            ordered = am.array();
            this.randomEigenValuesPercentiles[j] = ordered[pIndex2] + factor * (ordered[pIndex1] - ordered[pIndex2]);
        }
        boolean test = true;
        int counter = 0;
        while (test) {
            if (this.orderedEigenValues[counter] <= this.randomEigenValuesPercentiles[counter]) {
                this.percentileCrossover = counter;
                test = false;
                continue;
            }
            if (++counter != this.nItems) continue;
            this.percentileCrossover = counter;
            test = false;
        }
        test = true;
        counter = 0;
        while (test) {
            if (this.orderedEigenValues[counter] <= this.randomEigenValuesMeans[counter]) {
                this.meanCrossover = counter;
                test = false;
                continue;
            }
            if (++counter != this.nItems) continue;
            this.meanCrossover = counter;
            test = false;
        }
        this.monteCarloDone = true;
    }

    public void screePlotDataAlone() {
        if (!this.pcaDone) {
            this.pca();
        }
        double[] components = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            components[i] = i + 1;
        }
        PlotGraph pg = new PlotGraph(components, this.orderedEigenValues);
        pg.setGraphTitle("Principal Component Analysis Scree Plot");
        pg.setXaxisLegend("Component");
        pg.setYaxisLegend("Eigenvalues");
        pg.setLine(3);
        pg.setPoint(1);
        pg.plot();
    }

    public void screePlot() {
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        double[][] plotData = new double[6][this.nItems];
        double[] components = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            components[i] = i + 1;
        }
        plotData[0] = components;
        plotData[1] = this.orderedEigenValues;
        plotData[2] = components;
        plotData[3] = this.randomEigenValuesPercentiles;
        plotData[4] = components;
        plotData[5] = this.randomEigenValuesMeans;
        PlotGraph pg = new PlotGraph(plotData);
        pg.setErrorBars(2, this.randomEigenValuesSDs);
        if (this.gaussianDeviates) {
            pg.setGraphTitle("Principal Component Analysis Scree Plot with Parallel Analysis using Gaussian deviates (" + this.nMonteCarlo + " simulations)");
        } else {
            pg.setGraphTitle("Principal Component Analysis Scree Plot with Parallel Analysis using uniform deviates (" + this.nMonteCarlo + " simulations)");
        }
        pg.setGraphTitle2("Closed squares - data eigenvalues; open circles = Monte Carlo eigenvalue " + this.percentile + "% percentiles; error bars = standard deviations about the Monte carlo means (crosses)");
        pg.setXaxisLegend("Component");
        pg.setYaxisLegend("Eigenvalue");
        int[] line = new int[]{3, 0, 3};
        pg.setLine(line);
        int[] point = new int[]{5, 1, 7};
        pg.setPoint(point);
        pg.plot();
    }

    public void setVarimaxTolerance(double tolerance) {
        this.varimaxTolerance = tolerance;
    }

    public void setVarimaxMaximumIterations(int max) {
        this.nVarimaxMax = max;
    }

    public int getVarimaxIterations() {
        return this.nVarimax;
    }

    public void varimaxRotation(int nFactors) {
        if (!this.pcaDone) {
            this.pca();
        }
        if (this.varimaxOption) {
            this.normalVarimaxRotation(nFactors);
        } else {
            this.rawVarimaxRotation(nFactors);
        }
    }

    public void varimaxRotation(double[][] loadingFactorMatrix) {
        if (this.varimaxOption) {
            System.out.println("Method varimaxRotation: communality weights not supplied - raw varimax option used");
        }
        this.rawVarimaxRotationInHouse(loadingFactorMatrix);
    }

    public void varimaxRotation(double[][] loadingFactorMatrix, double[] communalityWeights) {
        if (this.varimaxOption) {
            this.normalVarimaxRotationInHouse(loadingFactorMatrix, communalityWeights);
        } else {
            System.out.println("Method varimaxRotation: raw varimax option chosen, supplied communality weights ignored");
            this.rawVarimaxRotationInHouse(loadingFactorMatrix);
        }
    }

    public void rawVarimaxRotation(int nFactors) {
        if (!this.pcaDone) {
            this.pca();
        }
        double[][] loadingFactorMatrix = new double[nFactors][this.nItems];
        for (int i = 0; i < nFactors; ++i) {
            loadingFactorMatrix[i] = this.loadingFactorsAsRows[i];
        }
        double[] communalityWeights = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            communalityWeights[i] = 1.0;
        }
        this.normalVarimaxRotationInHouse(loadingFactorMatrix, communalityWeights);
    }

    private void rawVarimaxRotationInHouse(double[][] loadingFactorMatrix) {
        double[] communalityWeights = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            communalityWeights[i] = 1.0;
        }
        this.normalVarimaxRotationInHouse(loadingFactorMatrix, communalityWeights);
    }

    public void normalVarimaxRotation(int nFactors) {
        if (!this.pcaDone) {
            this.pca();
        }
        double[][] loadingFactorMatrix = new double[nFactors][this.nItems];
        for (int i = 0; i < nFactors; ++i) {
            loadingFactorMatrix[i] = this.loadingFactorsAsRows[i];
        }
        double[] communalityWeights = new double[this.nItems];
        for (int i = 0; i < this.nItems; ++i) {
            communalityWeights[i] = 0.0;
            for (int j = 0; j < nFactors; ++j) {
                int n = i;
                communalityWeights[n] = communalityWeights[n] + loadingFactorMatrix[j][i] * loadingFactorMatrix[j][i];
            }
        }
        this.normalVarimaxRotationInHouse(loadingFactorMatrix, communalityWeights);
    }

    private void normalVarimaxRotationInHouse(double[][] loadingFactorMatrix, double[] communalityWeights) {
        int i;
        int i2;
        int j;
        int i3;
        if (!this.pcaDone) {
            this.pca();
        }
        int nRows = loadingFactorMatrix.length;
        int nColumns = loadingFactorMatrix[0].length;
        this.usRotatedLoadingFactorsAsRows = new double[nRows][nColumns];
        this.rotatedLoadingFactorsAsRows = new double[nRows][nColumns];
        this.usRotatedEigenValues = new double[nRows];
        this.rotatedEigenValues = new double[nRows];
        this.rotatedProportionPercentage = new double[nRows];
        this.rotatedCumulativePercentage = new double[nRows];
        for (int j2 = 0; j2 < nColumns; ++j2) {
            communalityWeights[j2] = Math.sqrt(communalityWeights[j2]);
        }
        for (int i4 = 0; i4 < nRows; ++i4) {
            for (int j3 = 0; j3 < nColumns; ++j3) {
                if (loadingFactorMatrix[i4][j3] == 0.0 && communalityWeights[j3] == 0.0) {
                    loadingFactorMatrix[i4][j3] = 1.0;
                } else {
                    double[] dArray = loadingFactorMatrix[i4];
                    int n = j3;
                    dArray[n] = dArray[n] / communalityWeights[j3];
                }
                this.usRotatedLoadingFactorsAsRows[i4][j3] = loadingFactorMatrix[i4][j3];
            }
        }
        double va = PCA.varimaxCriterion(this.usRotatedLoadingFactorsAsRows);
        double vaLast = 0.0;
        double angle = 0.0;
        boolean test = true;
        this.nVarimax = 0;
        while (test) {
            for (i3 = 0; i3 < nRows - 1; ++i3) {
                for (j = i3 + 1; j < nRows; ++j) {
                    angle = PCA.varimaxAngle(this.usRotatedLoadingFactorsAsRows, i3, j);
                    this.usRotatedLoadingFactorsAsRows = PCA.singleRotation(this.usRotatedLoadingFactorsAsRows, i3, j, angle);
                    va = PCA.varimaxCriterion(this.usRotatedLoadingFactorsAsRows);
                }
            }
            if (Math.abs(va - vaLast) < this.varimaxTolerance) {
                test = false;
                continue;
            }
            vaLast = va;
            ++this.nVarimax;
            if (this.nVarimax <= this.nVarimaxMax) continue;
            test = false;
            System.out.println("Method varimaxRotation: maximum iterations " + this.nVarimaxMax + " exceeded");
            System.out.println("Tolerance = " + this.varimaxTolerance + ",     Comparison value = " + Math.abs(va - vaLast));
            System.out.println("Current values returned");
            if (this.sameCheck <= 0) continue;
            System.out.println("Presence of identical element row/s and/or column/s in the data probably impeding convergence");
            System.out.println("Returned values are likely to be correct");
        }
        this.usRotatedLoadingFactorsAsColumns = new double[nColumns][nRows];
        for (i3 = 0; i3 < nRows; ++i3) {
            for (j = 0; j < nColumns; ++j) {
                double[] dArray = this.usRotatedLoadingFactorsAsRows[i3];
                int n = j;
                dArray[n] = dArray[n] * communalityWeights[j];
                this.usRotatedLoadingFactorsAsColumns[j][i3] = this.usRotatedLoadingFactorsAsRows[i3][j];
                double[] dArray2 = loadingFactorMatrix[i3];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * communalityWeights[j];
            }
        }
        double usRotatedEigenValueTotal = 0.0;
        double unRotatedEigenValueTotal = 0.0;
        for (int i5 = 0; i5 < nRows; ++i5) {
            this.usRotatedEigenValues[i5] = 0.0;
            for (int j4 = 0; j4 < nColumns; ++j4) {
                int n = i5;
                this.usRotatedEigenValues[n] = this.usRotatedEigenValues[n] + this.usRotatedLoadingFactorsAsRows[i5][j4] * this.usRotatedLoadingFactorsAsRows[i5][j4];
            }
            usRotatedEigenValueTotal += this.usRotatedEigenValues[i5];
            unRotatedEigenValueTotal += this.orderedEigenValues[i5];
        }
        ArrayMaths amrot = new ArrayMaths(this.usRotatedEigenValues);
        amrot = amrot.sort();
        this.usRotatedEigenValues = amrot.array();
        int[] sortedRotIndices = amrot.originalIndices();
        int nh = nRows / 2;
        double holdD = 0.0;
        int holdI = 0;
        for (int i6 = 0; i6 < nh; ++i6) {
            holdD = this.usRotatedEigenValues[i6];
            this.usRotatedEigenValues[i6] = this.usRotatedEigenValues[nRows - 1 - i6];
            this.usRotatedEigenValues[nRows - 1 - i6] = holdD;
            holdI = sortedRotIndices[i6];
            sortedRotIndices[i6] = sortedRotIndices[nRows - 1 - i6];
            sortedRotIndices[nRows - 1 - i6] = holdI;
        }
        int nn = this.usRotatedLoadingFactorsAsRows.length;
        int mm = this.usRotatedLoadingFactorsAsRows[0].length;
        double[][] holdDA = new double[nn][mm];
        for (int i7 = 0; i7 < nn; ++i7) {
            for (int j5 = 0; j5 < mm; ++j5) {
                holdDA[i7][j5] = this.usRotatedLoadingFactorsAsRows[sortedRotIndices[i7]][j5];
            }
        }
        this.usRotatedLoadingFactorsAsRows = Conv.copy(holdDA);
        nn = sortedRotIndices.length;
        this.rotatedIndices = new int[nn];
        int[] holdIA = new int[nn];
        for (i2 = 0; i2 < nn; ++i2) {
            holdIA[i2] = this.eigenValueIndices[sortedRotIndices[i2]];
        }
        this.rotatedIndices = Conv.copy(this.eigenValueIndices);
        for (i2 = 0; i2 < nn; ++i2) {
            this.rotatedIndices[i2] = holdIA[i2];
        }
        double scale0 = Math.abs(unRotatedEigenValueTotal / usRotatedEigenValueTotal);
        double scale1 = Math.sqrt(scale0);
        for (i = 0; i < nRows; ++i) {
            this.rotatedEigenValues[i] = scale0 * this.usRotatedEigenValues[i];
            this.rotatedProportionPercentage[i] = this.rotatedEigenValues[i] * 100.0 / this.eigenValueTotal;
            for (int j6 = 0; j6 < nColumns; ++j6) {
                this.rotatedLoadingFactorsAsRows[i][j6] = scale1 * this.usRotatedLoadingFactorsAsRows[i][j6];
            }
        }
        this.rotatedCumulativePercentage[0] = this.rotatedProportionPercentage[0];
        for (i = 1; i < nRows; ++i) {
            this.rotatedCumulativePercentage[i] = this.rotatedCumulativePercentage[i - 1] + this.rotatedProportionPercentage[i];
        }
        this.rotationDone = true;
    }

    public static double[][] rawVarimaxRotation(double[][] loadingFactorMatrix) {
        double tolerance = 1.0E-4;
        int nIterMax = 1000;
        return PCA.rawVarimaxRotation(loadingFactorMatrix, tolerance, nIterMax);
    }

    public static double[][] rawVarimaxRotation(double[][] loadingFactorMatrix, double tolerance, int nIterMax) {
        int nRows = loadingFactorMatrix.length;
        int nColumns = loadingFactorMatrix[0].length;
        double[] communalityWeights = new double[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            communalityWeights[i] = 1.0;
        }
        return PCA.normalVarimaxRotation(loadingFactorMatrix, communalityWeights, tolerance, nIterMax);
    }

    public static double[][] normalVarimaxRotation(double[][] loadingFactorMatrix, double[] communalityWeights) {
        double tolerance = 1.0E-4;
        int nIterMax = 1000;
        return PCA.normalVarimaxRotation(loadingFactorMatrix, communalityWeights, tolerance, nIterMax);
    }

    public static double[][] normalVarimaxRotation(double[][] loadingFactorMatrix, double[] communalityWeights, double tolerance, int nIterMax) {
        int j;
        int i;
        int nRows = loadingFactorMatrix.length;
        int nColumns = loadingFactorMatrix[0].length;
        for (int i2 = 1; i2 < nRows; ++i2) {
            if (loadingFactorMatrix[i2].length == nColumns) continue;
            throw new IllegalArgumentException("All rows must be the same length");
        }
        double[][] rotatedLoadingFactorsAsRows = new double[nRows][nColumns];
        for (int i3 = 0; i3 < nRows; ++i3) {
            for (int j2 = 0; j2 < nColumns; ++j2) {
                double[] dArray = loadingFactorMatrix[i3];
                int n = j2;
                dArray[n] = dArray[n] / communalityWeights[j2];
                rotatedLoadingFactorsAsRows[i3][j2] = loadingFactorMatrix[i3][j2];
            }
        }
        double va = PCA.varimaxCriterion(rotatedLoadingFactorsAsRows);
        double vaLast = 0.0;
        double angle = 0.0;
        boolean test = true;
        int nIter = 0;
        while (test) {
            for (i = 0; i < nRows - 1; ++i) {
                for (j = i + 1; j < nRows; ++j) {
                    angle = PCA.varimaxAngle(rotatedLoadingFactorsAsRows, i, j);
                    rotatedLoadingFactorsAsRows = PCA.singleRotation(rotatedLoadingFactorsAsRows, i, j, angle);
                    va = PCA.varimaxCriterion(rotatedLoadingFactorsAsRows);
                }
            }
            if (Math.abs(va - vaLast) < tolerance) {
                test = false;
                continue;
            }
            vaLast = va;
            if (++nIter <= nIterMax) continue;
            test = false;
            System.out.println("Method varimaxRotation: maximum iterations " + nIterMax + " exceeded");
            System.out.println("Current values returned");
        }
        for (i = 0; i < nRows; ++i) {
            for (j = 0; j < nColumns; ++j) {
                double[] dArray = rotatedLoadingFactorsAsRows[i];
                int n = j;
                dArray[n] = dArray[n] * communalityWeights[j];
                double[] dArray2 = loadingFactorMatrix[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * communalityWeights[j];
            }
        }
        return rotatedLoadingFactorsAsRows;
    }

    public static double[][] transposeMatrix(double[][] matrix) {
        int nRows = matrix.length;
        int nColumns = matrix[0].length;
        for (int i = 1; i < nRows; ++i) {
            if (matrix[i].length == nColumns) continue;
            throw new IllegalArgumentException("All rows must be the same length");
        }
        double[][] transpose = new double[nColumns][nRows];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nColumns; ++j) {
                transpose[j][i] = matrix[i][j];
            }
        }
        return transpose;
    }

    public static double varimaxCriterion(double[][] loadingFactorMatrix) {
        int k;
        int j;
        int nRows = loadingFactorMatrix.length;
        int nColumns = loadingFactorMatrix[0].length;
        double va1 = 0.0;
        double va2 = 0.0;
        double va3 = 0.0;
        for (j = 0; j < nRows; ++j) {
            double sum1 = 0.0;
            for (k = 0; k < nColumns; ++k) {
                sum1 += Math.pow(loadingFactorMatrix[j][k], 4.0);
            }
            va1 += sum1;
        }
        va1 *= (double)nColumns;
        for (j = 0; j < nRows; ++j) {
            double sum2 = 0.0;
            for (k = 0; k < nColumns; ++k) {
                sum2 += Math.pow(loadingFactorMatrix[j][k], 2.0);
            }
            va2 += sum2 * sum2;
        }
        va3 = va1 - va2;
        return va3;
    }

    public static double varimaxAngle(double[][] loadingFactorMatrix, int k, int l) {
        int nColumns = loadingFactorMatrix[0].length;
        double uTerm = 0.0;
        double vTerm = 0.0;
        double bigA = 0.0;
        double bigB = 0.0;
        double bigC = 0.0;
        double bigD = 0.0;
        for (int j = 0; j < nColumns; ++j) {
            double lmjk = loadingFactorMatrix[k][j];
            double lmjl = loadingFactorMatrix[l][j];
            uTerm = lmjk * lmjk - lmjl * lmjl;
            vTerm = 2.0 * lmjk * lmjl;
            bigA += uTerm;
            bigB += vTerm;
            bigC += uTerm * uTerm - vTerm * vTerm;
            bigD += 2.0 * uTerm * vTerm;
        }
        double bigE = bigD - 2.0 * bigA * bigB / (double)nColumns;
        double bigF = bigC - (bigA * bigA - bigB * bigB) / (double)nColumns;
        double angle = 0.25 * Math.atan2(bigE, bigF);
        return angle;
    }

    public static double[][] singleRotation(double[][] loadingFactorMatrix, int k, int l, double angle) {
        int nRows = loadingFactorMatrix.length;
        int nColumns = loadingFactorMatrix[0].length;
        double[][] rotatedMatrix = new double[nRows][nColumns];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nColumns; ++j) {
                rotatedMatrix[i][j] = loadingFactorMatrix[i][j];
            }
        }
        double sinphi = Math.sin(angle);
        double cosphi = Math.cos(angle);
        for (int j = 0; j < nColumns; ++j) {
            rotatedMatrix[k][j] = loadingFactorMatrix[k][j] * cosphi + loadingFactorMatrix[l][j] * sinphi;
            rotatedMatrix[l][j] = -loadingFactorMatrix[k][j] * sinphi + loadingFactorMatrix[l][j] * cosphi;
        }
        return rotatedMatrix;
    }

    public double[] eigenValues() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValues;
    }

    public double[] orderedEigenValues() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenValues;
    }

    public int[] eigenValueIndices() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValueIndices;
    }

    public double eigenValueTotal() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenValueTotal;
    }

    public double[] proportionPercentage() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.proportionPercentage;
    }

    public double[] cumulativePercentage() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.cumulativePercentage;
    }

    public double[] rotatedEigenValues() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedEigenValues;
    }

    public double[] rotatedProportionPercentage() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedProportionPercentage;
    }

    public double[] rotatedCumulativePercentage() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedCumulativePercentage;
    }

    public double[][] eigenVectors() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenVectorsAsColumns;
    }

    public double[][] eigenVectorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.eigenVectorsAsRows;
    }

    public double[][] orderedEigenVectorsAsColumns() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsColumns;
    }

    public double[][] orderedEigenVectors() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsColumns;
    }

    public double[][] orderedEigenVectorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.orderedEigenVectorsAsRows;
    }

    public double[][] loadingFactorsAsColumns() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.loadingFactorsAsColumns;
    }

    public double[][] loadingFactorsAsRows() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.loadingFactorsAsRows;
    }

    public double[][] rotatedLoadingFactorsAsColumns() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedLoadingFactorsAsColumns;
    }

    public double[][] rotatedLoadingFactorsAsRows() {
        if (!this.rotationDone) {
            throw new IllegalArgumentException("No rotation has been performed");
        }
        return this.rotatedLoadingFactorsAsRows;
    }

    public double[] communalities() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.communalities;
    }

    public double[] communalityWeights() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.communalityWeights;
    }

    public Matrix covarianceMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.covarianceMatrix;
    }

    public Matrix correlationMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.correlationMatrix;
    }

    public Matrix partialCorrelationMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.partialCorrelationMatrix;
    }

    public double[] monteCarloMeans() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesMeans;
    }

    public double[] monteCarloStandardDeviations() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesSDs;
    }

    public double[] monteCarloPercentiles() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValuesPercentiles;
    }

    public double[][] monteCarloEigenValues() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.randomEigenValues;
    }

    public Matrix originalData() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.data;
    }

    public Matrix xMatrix() {
        if (!this.pcaDone) {
            this.pca();
        }
        double denom = this.nItems;
        if (!this.nFactorOption) {
            denom -= 1.0;
        }
        Matrix mat = this.dataMinusMeans.times(1.0 / Math.sqrt(denom));
        return mat;
    }

    public Matrix xMatrixTranspose() {
        if (!this.pcaDone) {
            this.pca();
        }
        double denom = this.nItems;
        if (!this.nFactorOption) {
            denom -= 1.0;
        }
        Matrix mat = this.dataMinusMeansTranspose.times(1.0 / Math.sqrt(denom));
        return mat;
    }

    public int nEigenOneOrGreater() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.greaterThanOneLimit;
    }

    public int nMeanCrossover() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.meanCrossover;
    }

    public int nPercentileCrossover() {
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        return this.percentileCrossover;
    }

    public double overallKMO() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.kmo;
    }

    public double kmo() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.kmo;
    }

    public double[] itemKMOs() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.itemKMOs;
    }

    public double chiSquareBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.chiSquareBartlett;
    }

    public int dofBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.dfBartlett;
    }

    public double probabilityBartlett() {
        if (!this.pcaDone) {
            this.pca();
        }
        return this.probBartlett;
    }

    public void analysis() {
        this.outputFilename = "PCAOutput";
        this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        String message1 = "Output file name for the analysis details:";
        String message2 = "\nEnter the required name (as a single word) and click OK ";
        String message3 = "\nor simply click OK for default value";
        String message = message1 + message2 + message3;
        String defaultName = this.outputFilename;
        this.outputFilename = Db.readLine(message, defaultName);
        this.analysis(this.outputFilename);
    }

    public void analysis(String filename) {
        this.screePlot();
        this.outputFilename = filename;
        String outputFilenameWithoutExtension = null;
        String extension = null;
        int pos = filename.indexOf(46);
        if (pos == -1) {
            outputFilenameWithoutExtension = filename;
            this.outputFilename = this.fileOption == 1 ? this.outputFilename + ".txt" : this.outputFilename + ".xls";
        } else {
            int opt;
            int defaultBox;
            String[] boxTitles;
            String[] comments;
            String message;
            String headerComment;
            String message2;
            String message1;
            extension = filename.substring(pos).trim();
            outputFilenameWithoutExtension = filename.substring(0, pos).trim();
            if (extension.equalsIgnoreCase(".xls") && this.fileOption == 1) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .xls";
                    message2 = "\nbut you have chosen a .txt output";
                    headerComment = "Your output file name extension";
                    message = message1 + message2;
                    comments = new String[]{message, "replace it with .txt [text file]"};
                    opt = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".txt"}, defaultBox = 1);
                    if (opt == 2) {
                        this.outputFilename = outputFilenameWithoutExtension + ".txt";
                    }
                } else {
                    this.fileOption = 2;
                }
            }
            if (extension.equalsIgnoreCase(".txt") && this.fileOption == 2) {
                if (this.fileOptionSet) {
                    message1 = "Your entered output file type is .txt";
                    message2 = "\nbut you have chosen a .xls output";
                    headerComment = "Your output file name extension";
                    message = message1 + message2;
                    comments = new String[]{message, "replace it with .xls [Excel file]"};
                    opt = Db.optionBox(headerComment, comments, boxTitles = new String[]{"Retain", ".xls"}, defaultBox = 1);
                    if (opt == 2) {
                        this.outputFilename = outputFilenameWithoutExtension + ".xls";
                    }
                } else {
                    this.fileOption = 1;
                }
            }
            if (!extension.equalsIgnoreCase(".txt") && !extension.equalsIgnoreCase(".xls")) {
                message1 = "Your extension is " + extension;
                message2 = "\n    Do you wish to retain it:";
                message = message1 + message2;
                headerComment = "Your output file name extension";
                comments = new String[]{message, "replace it with .txt [text file]", "replace it with .xls [MS Excel file]"};
                boxTitles = new String[]{"Retain", ".txt", ".xls"};
                defaultBox = 1;
                opt = Db.optionBox(headerComment, comments, boxTitles, defaultBox);
                switch (opt) {
                    case 1: {
                        this.fileOption = 1;
                        break;
                    }
                    case 2: {
                        this.outputFilename = outputFilenameWithoutExtension + ".txt";
                        this.fileOption = 1;
                        break;
                    }
                    case 3: {
                        this.outputFilename = outputFilenameWithoutExtension + ".xls";
                        this.fileOption = 2;
                    }
                }
            }
        }
        if (this.fileOption == 1) {
            this.analysisText();
        } else {
            this.analysisExcel();
        }
        System.out.println("The analysis has been written to the file " + this.outputFilename);
    }

    private void analysisText() {
        int j;
        int i;
        int j2;
        int i2;
        FileOutput fout = null;
        fout = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        fout.println("PRINCIPAL COMPONENT ANALYSIS");
        fout.println("Program: PCA - Analysis Output");
        for (int i3 = 0; i3 < this.titleLines; ++i3) {
            fout.println(this.title[i3]);
        }
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        if (this.covRhoOption) {
            fout.println("Covariance matrix used");
        } else {
            fout.println("Correlation matrix used");
        }
        fout.println();
        int field1 = 10;
        int field2 = 12;
        int field3 = 2;
        fout.println("ALL EIGENVALUES");
        fout.print("Component ", field1);
        fout.print("Unordered ", field1);
        fout.print("Eigenvalue ", field2);
        fout.print("Proportion ", field2);
        fout.print("Cumulative ", field2);
        fout.println("Difference ");
        fout.print(" ", field1);
        fout.print("index", field1);
        fout.print(" ", field2);
        fout.print("as % ", field2);
        fout.print("percentage ", field2);
        fout.println(" ");
        for (int i4 = 0; i4 < this.nItems; ++i4) {
            fout.print(i4 + 1, field1);
            fout.print(this.eigenValueIndices[i4] + 1, field1);
            fout.print(Fmath.truncate(this.orderedEigenValues[i4], this.trunc), field2);
            fout.print(Fmath.truncate(this.proportionPercentage[i4], this.trunc), field2);
            fout.print(Fmath.truncate(this.cumulativePercentage[i4], this.trunc), field2);
            if (i4 < this.nItems - 1) {
                fout.print(Fmath.truncate(this.orderedEigenValues[i4] - this.orderedEigenValues[i4 + 1], this.trunc), field2);
            } else {
                fout.print(" ", field2);
            }
            fout.print(" ", field3);
            fout.println();
        }
        fout.println();
        int nMax = this.greaterThanOneLimit;
        if (nMax < this.meanCrossover) {
            nMax = this.meanCrossover;
        }
        if (nMax < this.percentileCrossover) {
            nMax = this.percentileCrossover;
        }
        fout.println("EXTRACTED EIGENVALUES");
        fout.print(" ", field1);
        fout.print("Greater than unity", 3 * field2 + field3);
        fout.print("Greater than Monte Carlo Mean ", 3 * field2 + field3);
        fout.println("Greater than Monte Carlo Percentile");
        fout.print("Component ", field1);
        fout.print("Eigenvalue ", field2);
        fout.print("Proportion ", field2);
        fout.print("Cumulative ", field2);
        fout.print(" ", field3);
        fout.print("Eigenvalue ", field2);
        fout.print("Proportion ", field2);
        fout.print("Cumulative ", field2);
        fout.print(" ", field3);
        fout.print("Eigenvalue ", field2);
        fout.print("Proportion ", field2);
        fout.print("Cumulative ", field2);
        fout.println(" ");
        fout.print(" ", field1);
        fout.print(" ", field2);
        fout.print("as % ", field2);
        fout.print("percentage ", field2);
        fout.print(" ", field3);
        fout.print(" ", field2);
        fout.print("as % ", field2);
        fout.print("percentage ", field2);
        fout.print(" ", field3);
        fout.print(" ", field2);
        fout.print("as % ", field2);
        fout.print("percentage ", field2);
        fout.println(" ");
        for (int ii = 0; ii < nMax; ++ii) {
            fout.print(ii + 1, field1);
            if (ii < this.greaterThanOneLimit) {
                fout.print(Fmath.truncate(this.orderedEigenValues[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.proportionPercentage[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.cumulativePercentage[ii], this.trunc), field2 + field3);
            }
            if (ii < this.meanCrossover) {
                fout.print(Fmath.truncate(this.orderedEigenValues[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.proportionPercentage[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.cumulativePercentage[ii], this.trunc), field2 + field3);
            }
            if (ii < this.percentileCrossover) {
                fout.print(Fmath.truncate(this.orderedEigenValues[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.proportionPercentage[ii], this.trunc), field2);
                fout.print(Fmath.truncate(this.cumulativePercentage[ii], this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("PARALLEL ANALYSIS");
        fout.println("Number of simulations = " + this.nMonteCarlo);
        if (this.gaussianDeviates) {
            fout.println("Gaussian random deviates used");
        } else {
            fout.println("Uniform random deviates used");
        }
        fout.println("Percentile value used = " + this.percentile + " %");
        fout.println();
        fout.print("Component ", field1);
        fout.print("Data ", field2);
        fout.print("Proportion ", field2);
        fout.print("Cumulative ", field2);
        fout.print(" ", field3);
        fout.print("Data ", field2);
        fout.print("Monte Carlo ", field2);
        fout.print("Monte Carlo ", field2);
        fout.println("Monte Carlo ");
        fout.print(" ", field1);
        fout.print("Eigenvalue ", field2);
        fout.print("as % ", field2);
        fout.print("percentage ", field2);
        fout.print(" ", field3);
        fout.print("Eigenvalue ", field2);
        fout.print("Eigenvalue ", field2);
        fout.print("Eigenvalue ", field2);
        fout.println("Eigenvalue ");
        fout.print(" ", field1);
        fout.print(" ", field2);
        fout.print(" ", field2);
        fout.print(" ", field2);
        fout.print(" ", field3);
        fout.print(" ", field2);
        fout.print("Percentile ", field2);
        fout.print("Mean ", field2);
        fout.println("Standard Deviation ");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(i2 + 1, field1);
            fout.print(Fmath.truncate(this.orderedEigenValues[i2], this.trunc), field2);
            fout.print(Fmath.truncate(this.proportionPercentage[i2], this.trunc), field2);
            fout.print(Fmath.truncate(this.cumulativePercentage[i2], this.trunc), field2);
            fout.print(" ", field3);
            fout.print(Fmath.truncate(this.orderedEigenValues[i2], this.trunc), field2);
            fout.print(Fmath.truncate(this.randomEigenValuesPercentiles[i2], this.trunc), field2);
            fout.print(Fmath.truncate(this.randomEigenValuesMeans[i2], this.trunc), field2);
            fout.println(Fmath.truncate(this.randomEigenValuesSDs[i2], this.trunc));
        }
        fout.println();
        fout.println("CORRELATION MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.print(" ", field1);
        fout.print("item", field1);
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", field2);
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", 2 * field1);
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.print(Fmath.truncate(this.correlationMatrix.getElement(j2, i2), this.trunc), field2);
            }
            fout.println();
        }
        fout.println();
        fout.println("PARTIAL CORRELATION MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.print(" ", field1);
        fout.print("item", field1);
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", field2);
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", 2 * field1);
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.print(Fmath.truncate(this.partialCorrelationMatrix.getElement(j2, i2), this.trunc), field2);
            }
            fout.println();
        }
        fout.println();
        fout.println("COVARIANCE MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.print(" ", field1);
        fout.print("item", field1);
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", field2);
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", 2 * field1);
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.print(Fmath.truncate(this.covarianceMatrix.getElement(j2, i2), this.trunc), field2);
            }
            fout.println();
        }
        fout.println();
        fout.println("EIGENVECTORS");
        fout.println("Original component indices in parenthesis");
        fout.println("Vector corresponding to an ordered eigenvalues in each row");
        fout.println();
        fout.print(" ", field1);
        fout.print("component", field1);
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", field2);
        }
        fout.println();
        fout.println("component");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(i2 + 1 + " (" + (this.eigenValueIndices[i2] + 1) + ")", 2 * field1);
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.print(Fmath.truncate(this.orderedEigenVectorsAsRows[i2][j2], this.trunc), field2);
            }
            fout.println();
        }
        fout.println();
        fout.println("LOADING FACTORS");
        fout.println("Original  indices in parenthesis");
        fout.println("Loading factors corresponding to an ordered eigenvalues in each row");
        fout.println();
        fout.print(" ", field1);
        fout.print("component", field1);
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")", field2);
        }
        fout.print(" ", field1);
        fout.print("Eigenvalue", field2);
        fout.print("Proportion", field2);
        fout.println("Cumulative %");
        fout.println("factor");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.print(i2 + 1 + " (" + (this.eigenValueIndices[i2] + 1) + ")", 2 * field1);
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.print(Fmath.truncate(this.loadingFactorsAsRows[i2][j2], this.trunc), field2);
            }
            fout.print(" ", field1);
            fout.print(Fmath.truncate(this.orderedEigenValues[i2], this.trunc), field2);
            fout.print(Fmath.truncate(this.proportionPercentage[i2], this.trunc), field2);
            fout.println(Fmath.truncate(this.cumulativePercentage[i2], this.trunc));
        }
        fout.println();
        fout.println("ROTATED LOADING FACTORS");
        if (this.varimaxOption) {
            fout.println("NORMAL VARIMAX");
        } else {
            fout.println("RAW VARIMAX");
        }
        String message = "The ordered eigenvalues with Monte Carlo means and percentiles in parenthesis";
        message = message + "\n (Total number of eigenvalues = " + this.nItems + ")";
        int nDisplay = this.nItems;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int nDisplayLimit = 20 * screenHeight / 800;
        if (nDisplay > nDisplay) {
            nDisplay = nDisplayLimit;
        }
        for (int i5 = 0; i5 < nDisplay; ++i5) {
            message = message + "\n " + Fmath.truncate(this.orderedEigenValues[i5], 4) + " (" + Fmath.truncate(this.randomEigenValuesMeans[i5], 4) + "  " + Fmath.truncate(this.randomEigenValuesPercentiles[i5], 4) + ")";
        }
        if (nDisplay < this.nItems) {
            message = message + "\n . . . ";
        }
        message = message + "\nEnter number of eigenvalues to be extracted";
        int nExtracted = this.greaterThanOneLimit;
        nExtracted = Db.readInt(message, nExtracted);
        this.varimaxRotation(nExtracted);
        fout.println("Varimax rotation for " + nExtracted + " extracted factors");
        fout.println("Rotated loading factors and eigenvalues scaled to ensure total 'rotated variance' matches unrotated variance for the extracted factors");
        fout.println("Original  indices in parenthesis");
        fout.println();
        fout.print(" ", field1);
        fout.print("component", field1);
        for (i = 0; i < this.nItems; ++i) {
            fout.print(this.rotatedIndices[i] + 1 + " (" + (i + 1) + ")", field2);
        }
        fout.print(" ", field1);
        fout.print("Eigenvalue", field2);
        fout.print("Proportion", field2);
        fout.println("Cumulative %");
        fout.println("factor");
        for (i = 0; i < nExtracted; ++i) {
            fout.print(i + 1 + " (" + (this.rotatedIndices[i] + 1) + ")", 2 * field1);
            for (j = 0; j < this.nItems; ++j) {
                fout.print(Fmath.truncate(this.rotatedLoadingFactorsAsRows[i][j], this.trunc), field2);
            }
            fout.print(" ", field1);
            fout.print(Fmath.truncate(this.rotatedEigenValues[i], this.trunc), field2);
            fout.print(Fmath.truncate(this.rotatedProportionPercentage[i], this.trunc), field2);
            fout.println(Fmath.truncate(this.rotatedCumulativePercentage[i], this.trunc));
        }
        fout.println();
        fout.println("Kaiser-Meyer-Olkin (KMO) statistic");
        fout.println("   Overall KMO statistic =   " + Fmath.truncate(this.kmo, this.trunc));
        fout.println("   KMO values for each item");
        fout.print("   ");
        for (i = 0; i < this.nItems; ++i) {
            fout.print(i + 1, field2);
        }
        fout.println();
        fout.print("   ");
        for (i = 0; i < this.nItems; ++i) {
            fout.print(Fmath.truncate(this.itemKMOs[i], this.trunc), field2);
        }
        fout.println();
        fout.println();
        fout.println("Bartlett Sphericity Test");
        fout.println("   Chi-Square =         " + Fmath.truncate(this.chiSquareBartlett, this.trunc));
        fout.println("   Probability value =  " + Fmath.truncate(this.probBartlett, this.trunc));
        fout.println("   Degrees of freedom = " + this.dfBartlett);
        fout.println("   Chi-Square value at the 5% significance level  (p = 0.05) = " + Fmath.truncate(this.sign05Bartlett, this.trunc));
        fout.println("   Chi-Square value at the 10% significance level (p = 0.10) = " + Fmath.truncate(this.sign10Bartlett, this.trunc));
        fout.println();
        fout.println("DATA USED");
        fout.println("Number of items = " + this.nItems);
        fout.println("Number of persons = " + this.nPersons);
        if (this.originalDataType == 0) {
            fout.printtab("Item");
            for (i = 0; i < this.nPersons; ++i) {
                fout.printtab(i + 1);
            }
            fout.println();
            for (i = 0; i < this.nItems; ++i) {
                fout.printtab(this.itemNames[i]);
                for (j = 0; j < this.nPersons; ++j) {
                    fout.printtab(Fmath.truncate(this.scores0[i][j], this.trunc));
                }
                fout.println();
            }
        } else {
            fout.printtab("Person");
            for (i = 0; i < this.nItems; ++i) {
                fout.printtab(this.itemNames[i]);
            }
            fout.println();
            for (i = 0; i < this.nPersons; ++i) {
                fout.printtab(i + 1);
                for (j = 0; j < this.nItems; ++j) {
                    fout.printtab(Fmath.truncate(this.scores1[i][j], this.trunc));
                }
                fout.println();
            }
        }
        fout.close();
    }

    private void analysisExcel() {
        int j;
        int i;
        int j2;
        int i2;
        FileOutput fout = null;
        fout = this.fileNumberingSet ? new FileOutput(this.outputFilename, 'n') : new FileOutput(this.outputFilename);
        if (!this.pcaDone) {
            this.pca();
        }
        if (!this.monteCarloDone) {
            this.monteCarlo();
        }
        fout.println("PRINCIPAL COMPONENT ANALYSIS");
        fout.println("Program: PCA - Analysis Output");
        for (int i3 = 0; i3 < this.titleLines; ++i3) {
            fout.println(this.title[i3]);
        }
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        if (this.covRhoOption) {
            fout.println("Covariance matrix used");
        } else {
            fout.println("Correlation matrix used");
        }
        fout.println();
        fout.println("ALL EIGENVALUES");
        fout.printtab("Component ");
        fout.printtab("Unordered ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Proportion ");
        fout.printtab("Cumulative ");
        fout.println("Difference ");
        fout.printtab(" ");
        fout.printtab("index");
        fout.printtab(" ");
        fout.printtab("as % ");
        fout.printtab("percentage ");
        fout.println(" ");
        for (int i4 = 0; i4 < this.nItems; ++i4) {
            fout.printtab(i4 + 1);
            fout.printtab(this.eigenValueIndices[i4] + 1);
            fout.printtab(Fmath.truncate(this.orderedEigenValues[i4], this.trunc));
            fout.printtab(Fmath.truncate(this.proportionPercentage[i4], this.trunc));
            fout.printtab(Fmath.truncate(this.cumulativePercentage[i4], this.trunc));
            if (i4 < this.nItems - 1) {
                fout.printtab(Fmath.truncate(this.orderedEigenValues[i4] - this.orderedEigenValues[i4 + 1], this.trunc));
            } else {
                fout.printtab(" ");
            }
            fout.printtab(" ");
            fout.println();
        }
        fout.println();
        int nMax = this.greaterThanOneLimit;
        if (nMax < this.meanCrossover) {
            nMax = this.meanCrossover;
        }
        if (nMax < this.percentileCrossover) {
            nMax = this.percentileCrossover;
        }
        fout.println("EXTRACTED EIGENVALUES");
        fout.printtab(" ");
        fout.printtab("Greater than unity");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("Greater than Monte Carlo Mean ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.println("Greater than Monte Carlo Percentile");
        fout.printtab("Component ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Proportion ");
        fout.printtab("Cumulative ");
        fout.printtab(" ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Proportion ");
        fout.printtab("Cumulative ");
        fout.printtab(" ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Proportion ");
        fout.printtab("Cumulative ");
        fout.println(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("as % ");
        fout.printtab("percentage ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("as % ");
        fout.printtab("percentage ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("as % ");
        fout.printtab("percentage ");
        fout.println(" ");
        for (int ii = 0; ii < nMax; ++ii) {
            fout.printtab(ii + 1);
            if (ii < this.greaterThanOneLimit) {
                fout.printtab(Fmath.truncate(this.orderedEigenValues[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.proportionPercentage[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.cumulativePercentage[ii], this.trunc));
                fout.printtab(" ");
            }
            if (ii < this.meanCrossover) {
                fout.printtab(Fmath.truncate(this.orderedEigenValues[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.proportionPercentage[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.cumulativePercentage[ii], this.trunc));
                fout.printtab(" ");
            }
            if (ii < this.percentileCrossover) {
                fout.printtab(Fmath.truncate(this.orderedEigenValues[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.proportionPercentage[ii], this.trunc));
                fout.printtab(Fmath.truncate(this.cumulativePercentage[ii], this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("PARALLEL ANALYSIS");
        fout.println("Number of simulations = " + this.nMonteCarlo);
        if (this.gaussianDeviates) {
            fout.println("Gaussian random deviates used");
        } else {
            fout.println("Uniform random deviates used");
        }
        fout.println("Percentile value used = " + this.percentile + " %");
        fout.println();
        fout.printtab("Component ");
        fout.printtab("Data ");
        fout.printtab("Proportion ");
        fout.printtab("Cumulative ");
        fout.printtab(" ");
        fout.printtab("Data ");
        fout.printtab("Monte Carlo ");
        fout.printtab("Monte Carlo ");
        fout.println("Monte Carlo ");
        fout.printtab(" ");
        fout.printtab("Eigenvalue ");
        fout.printtab("as % ");
        fout.printtab("percentage ");
        fout.printtab(" ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Eigenvalue ");
        fout.printtab("Eigenvalue ");
        fout.println("Eigenvalue ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab(" ");
        fout.printtab("Percentile ");
        fout.printtab("Mean ");
        fout.println("Standard Deviation ");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(i2 + 1);
            fout.printtab(Fmath.truncate(this.orderedEigenValues[i2], this.trunc));
            fout.printtab(Fmath.truncate(this.proportionPercentage[i2], this.trunc));
            fout.printtab(Fmath.truncate(this.cumulativePercentage[i2], this.trunc));
            fout.printtab(" ");
            fout.printtab(Fmath.truncate(this.orderedEigenValues[i2], this.trunc));
            fout.printtab(Fmath.truncate(this.randomEigenValuesPercentiles[i2], this.trunc));
            fout.printtab(Fmath.truncate(this.randomEigenValuesMeans[i2], this.trunc));
            fout.println(Fmath.truncate(this.randomEigenValuesSDs[i2], this.trunc));
        }
        fout.println();
        fout.println("CORRELATION MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.printtab(" ");
        fout.printtab("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
            fout.printtab(" ");
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.printtab(Fmath.truncate(this.correlationMatrix.getElement(j2, i2), this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("PARTIAL CORRELATION MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.printtab(" ");
        fout.printtab("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
            fout.printtab(" ");
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.printtab(Fmath.truncate(this.partialCorrelationMatrix.getElement(j2, i2), this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("COVARIANCE MATRIX");
        fout.println("Original item indices in parenthesis");
        fout.println();
        fout.printtab(" ");
        fout.printtab("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
        }
        fout.println();
        fout.println("item");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
            fout.printtab(" ");
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.printtab(Fmath.truncate(this.covarianceMatrix.getElement(j2, i2), this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("EIGENVECTORS");
        fout.println("Original component indices in parenthesis");
        fout.println("Vector corresponding to an ordered eigenvalues in each row");
        fout.println();
        fout.printtab(" ");
        fout.printtab("component");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
        }
        fout.println();
        fout.println("component");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(i2 + 1 + " (" + (this.eigenValueIndices[i2] + 1) + ")");
            fout.printtab(" ");
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.printtab(Fmath.truncate(this.orderedEigenVectorsAsRows[i2][j2], this.trunc));
            }
            fout.println();
        }
        fout.println();
        fout.println("LOADING FACTORS");
        fout.println("Original  indices in parenthesis");
        fout.println("Loading factors corresponding to an ordered eigenvalues in each row");
        fout.println();
        fout.printtab(" ");
        fout.printtab("component");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(this.eigenValueIndices[i2] + 1 + " (" + (i2 + 1) + ")");
        }
        fout.printtab(" ");
        fout.printtab("Eigenvalue");
        fout.printtab("% Proportion");
        fout.println("Cumulative %");
        fout.println("factor");
        for (i2 = 0; i2 < this.nItems; ++i2) {
            fout.printtab(i2 + 1 + " (" + (this.eigenValueIndices[i2] + 1) + ")");
            fout.printtab(" ");
            for (j2 = 0; j2 < this.nItems; ++j2) {
                fout.printtab(Fmath.truncate(this.loadingFactorsAsRows[i2][j2], this.trunc));
            }
            fout.printtab(" ");
            fout.printtab(Fmath.truncate(this.orderedEigenValues[i2], this.trunc));
            fout.printtab(Fmath.truncate(this.proportionPercentage[i2], this.trunc));
            fout.println(Fmath.truncate(this.cumulativePercentage[i2], this.trunc));
        }
        fout.println();
        fout.println("ROTATED LOADING FACTORS");
        if (this.varimaxOption) {
            fout.println("NORMAL VARIMAX");
        } else {
            fout.println("RAW VARIMAX");
        }
        String message = "The ordered eigenvalues with Monte Carlo means and percentiles in parenthesis";
        message = message + "\n (Total number of eigenvalues = " + this.nItems + ")";
        int nDisplay = this.nItems;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int nDisplayLimit = 20 * screenHeight / 800;
        if (nDisplay > nDisplay) {
            nDisplay = nDisplayLimit;
        }
        for (int i5 = 0; i5 < nDisplay; ++i5) {
            message = message + "\n " + Fmath.truncate(this.orderedEigenValues[i5], 4) + " (" + Fmath.truncate(this.randomEigenValuesMeans[i5], 4) + "  " + Fmath.truncate(this.randomEigenValuesPercentiles[i5], 4) + ")";
        }
        if (nDisplay < this.nItems) {
            message = message + "\n . . . ";
        }
        message = message + "\nEnter number of eigenvalues to be extracted";
        int nExtracted = this.greaterThanOneLimit;
        nExtracted = Db.readInt(message, nExtracted);
        this.varimaxRotation(nExtracted);
        fout.println("Varimax rotation for " + nExtracted + " extracted factors");
        fout.println("Rotated loading factors and eigenvalues scaled to ensure total 'rotated variance' matches unrotated variance for the extracted factors");
        fout.println("Original  indices in parenthesis");
        fout.println();
        fout.printtab(" ");
        fout.printtab("component");
        for (i = 0; i < this.nItems; ++i) {
            fout.printtab(this.rotatedIndices[i] + 1 + " (" + (i + 1) + ")");
        }
        fout.printtab(" ");
        fout.printtab("Eigenvalue");
        fout.printtab("% Proportion");
        fout.println("Cumulative %");
        fout.println("factor");
        for (i = 0; i < nExtracted; ++i) {
            fout.printtab(i + 1 + " (" + (this.rotatedIndices[i] + 1) + ")");
            fout.printtab(" ");
            for (j = 0; j < this.nItems; ++j) {
                fout.printtab(Fmath.truncate(this.rotatedLoadingFactorsAsRows[i][j], this.trunc));
            }
            fout.printtab(" ");
            fout.printtab(Fmath.truncate(this.rotatedEigenValues[i], this.trunc));
            fout.printtab(Fmath.truncate(this.rotatedProportionPercentage[i], this.trunc));
            fout.println(Fmath.truncate(this.rotatedCumulativePercentage[i], this.trunc));
        }
        fout.println();
        fout.println("Kaiser-Meyer-Olkin (KMO) statistic");
        fout.println("   Overall KMO statistic =   " + Fmath.truncate(this.kmo, this.trunc));
        fout.println("   KMO values for each item");
        fout.printtab("   ");
        for (i = 0; i < this.nItems; ++i) {
            fout.printtab(i + 1);
        }
        fout.println();
        fout.printtab("   ");
        for (i = 0; i < this.nItems; ++i) {
            fout.printtab(Fmath.truncate(this.itemKMOs[i], this.trunc));
        }
        fout.println();
        fout.println();
        fout.println("Bartlett Sphericity Test");
        fout.println("   Chi-Square =         " + Fmath.truncate(this.chiSquareBartlett, this.trunc));
        fout.println("   Probability value =  " + Fmath.truncate(this.probBartlett, this.trunc));
        fout.println("   Degrees of freedom = " + this.dfBartlett);
        fout.println("   Chi-Square value at the 5% significance level  (p = 0.05) = " + Fmath.truncate(this.sign05Bartlett, this.trunc));
        fout.println("   Chi-Square value at the 10% significance level (p = 0.10) = " + Fmath.truncate(this.sign10Bartlett, this.trunc));
        fout.println();
        fout.println("DATA USED");
        fout.println("Number of items = " + this.nItems);
        fout.println("Number of persons = " + this.nPersons);
        if (this.originalDataType == 0) {
            fout.printtab("Item");
            for (i = 0; i < this.nPersons; ++i) {
                fout.printtab(i + 1);
            }
            fout.println();
            for (i = 0; i < this.nItems; ++i) {
                fout.printtab(this.itemNames[i]);
                for (j = 0; j < this.nPersons; ++j) {
                    fout.printtab(Fmath.truncate(this.scores0[i][j], this.trunc));
                }
                fout.println();
            }
        } else {
            fout.printtab("Person");
            for (i = 0; i < this.nItems; ++i) {
                fout.printtab(this.itemNames[i]);
            }
            fout.println();
            for (i = 0; i < this.nPersons; ++i) {
                fout.printtab(i + 1);
                for (j = 0; j < this.nItems; ++j) {
                    fout.printtab(Fmath.truncate(this.scores1[i][j], this.trunc));
                }
                fout.println();
            }
        }
        fout.close();
    }
}

