/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.HashMap;

public class VcfGenotype {
    String values;
    int[] genotype;
    int ploidy;
    boolean phased;
    double gQuality;
    int depth;
    int[] genotypeLikelihoodPhred;
    HashMap<String, String> fields;
    VcfEntry vcfEntry;

    public VcfGenotype(VcfEntry vcfEntry, String format, String values) {
        this.vcfEntry = vcfEntry;
        this.values = values;
    }

    public void add(String name, String value) {
        if (value.indexOf(32) >= 0 || value.indexOf(9) >= 0 || value.indexOf(61) >= 0) {
            throw new RuntimeException("Error: Attempt to add a value containin illegal characters: no white-space, semi-colons, or equals-signs permitted\n\tname : '" + name + "'\n\tvalue : '" + value + "'");
        }
        if (this.vcfEntry.getFormat().indexOf(name) < 0) {
            throw new RuntimeException("Error Attempt to add a field (name=" + name + ") that is not present in FORMAT field. Use VcfEntry.addFormat() method first!");
        }
        this.values = this.values + (this.values.endsWith(":") ? "" : ":") + value;
        if (this.fields != null) {
            this.fields.put(name, value);
        }
    }

    public String get(String fieldName) {
        this.parseFields();
        return this.fields.get(fieldName);
    }

    public int[] getGenotype() {
        this.parseFields();
        return this.genotype;
    }

    public String getGenotype(int idx) {
        this.parseFields();
        if (this.genotype == null) {
            return "";
        }
        int num = this.genotype[idx];
        if (num < 0) {
            return "";
        }
        return num == 0 ? this.vcfEntry.getRef() : this.vcfEntry.getAlts()[num - 1];
    }

    public int getGenotypeCode() {
        this.parseFields();
        if (this.genotype == null) {
            return -1;
        }
        int code = 0;
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] < 0 || this.genotype[i] > 1) {
                return -1;
            }
            code += this.genotype[i];
        }
        return code;
    }

    public String getGenotypeStr() {
        this.parseFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.genotype.length; ++i) {
            int num = this.genotype[i];
            String gen = ".";
            if (num == 0) {
                gen = this.vcfEntry.getRef();
            } else if (num > 0) {
                gen = this.vcfEntry.getAlts()[num - 1];
            }
            sb.append(gen);
            if (i >= this.genotype.length - 1) continue;
            if (this.isPhased()) {
                sb.append("|");
                continue;
            }
            sb.append("/");
        }
        return sb.toString();
    }

    public boolean isHeterozygous() {
        return !this.isHomozygous();
    }

    public boolean isHomozygous() {
        this.parseFields();
        if (this.genotype != null) {
            for (int i = 1; i < this.genotype.length; ++i) {
                if (this.genotype[i] == this.genotype[i - 1]) continue;
                return false;
            }
            return true;
        }
        return this.vcfEntry.isHomozygous();
    }

    public boolean isMissing() {
        this.parseFields();
        if (this.genotype == null) {
            return true;
        }
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isPhased() {
        this.parseFields();
        return this.phased;
    }

    public boolean isVariant() {
        if (this.values.isEmpty()) {
            return false;
        }
        this.parseFields();
        if (this.genotype != null) {
            for (int i = 0; i < this.genotype.length; ++i) {
                if (this.genotype[i] <= 0) continue;
                return true;
            }
            return false;
        }
        return this.vcfEntry.isVariant();
    }

    void parseFields() {
        if (this.fields != null) {
            return;
        }
        try {
            this.fields = new HashMap();
            if (this.values.isEmpty()) {
                return;
            }
            String[] fieldNames = this.vcfEntry.getFormat().split(":");
            String[] fieldValues = this.values.split(":");
            int min = Math.min(fieldValues.length, fieldNames.length);
            for (int i = 0; i < min; ++i) {
                String name = fieldNames[i];
                String value = fieldValues[i];
                this.fields.put(name, value);
                if (name.equals("GT")) {
                    this.parseGt(value);
                    continue;
                }
                if (name.equals("PL")) {
                    this.parsePl(value);
                    continue;
                }
                if (!name.equals("GQ")) continue;
                this.gQuality = Gpr.parseDoubleSafe(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing fields on line:\n\tFormat: '" + this.vcfEntry.getFormat() + "'\n\tValues: '" + this.values + "'", e);
        }
    }

    void parseGt(String value) {
        String[] gtStr = null;
        if (value.indexOf(124) >= 0) {
            gtStr = value.split("\\|");
            this.phased = true;
        } else {
            gtStr = value.split("/");
            this.phased = false;
        }
        this.genotype = new int[gtStr.length];
        for (int i = 0; i < this.genotype.length; ++i) {
            if (gtStr[i].isEmpty() || gtStr[i].isEmpty() || gtStr[i].equals(".")) {
                this.genotype[i] = -1;
                continue;
            }
            this.genotype[i] = Gpr.parseIntSafe(gtStr[i]);
            if (this.genotype[i] - 1 < this.vcfEntry.getAlts().length) continue;
            boolean plural = this.vcfEntry.getAlts().length > 1;
            throw new RuntimeException("Error: Bad genotype field '" + value + "'. Genotype says '" + this.genotype[i] + "' but there " + (plural ? "are" : "is") + " only '" + this.vcfEntry.getAlts().length + "' allele" + (plural ? "s" : "") + " ('" + this.vcfEntry.getAltsStr() + "').");
        }
    }

    void parsePl(String value) {
        String[] plStr = value.split(",");
        this.genotypeLikelihoodPhred = new int[plStr.length];
        for (int i = 0; i < plStr.length; ++i) {
            this.genotypeLikelihoodPhred[i] = Gpr.parseIntSafe(plStr[i]);
        }
    }

    public String toString() {
        return this.values.isEmpty() ? "." : this.values;
    }
}

