/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdEff;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesFilterTranscripts
extends TestCase {
    boolean verbose = false;

    public void test_01() {
        String[] args = new String[]{"-v", "-noStats", "-i", "vcf", "-o", "vcf", "-onlyTr", "tests/filterTranscripts_01.txt", "testHg3765Chr22", "tests/test_filter_transcripts_001.vcf"};
        SnpEffCmdEff cmd = new SnpEffCmdEff();
        cmd.parseArgs(args);
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            System.out.println(ve);
            String effs = ve.getInfo("EFF");
            for (String effStr : effs.split(",")) {
                VcfEffect veff = new VcfEffect(effStr);
                System.out.println("\ttrId:" + veff.getTranscriptId() + "\t" + veff);
                Assert.assertEquals((String)"ENST00000400573", (String)veff.getTranscriptId());
            }
        }
    }

    public void test_02() {
        String[] args = new String[]{"-v", "-noStats", "-i", "vcf", "-o", "vcf", "-onlyTr", "tests/filterTranscripts_02.txt", "testHg3765Chr22", "tests/test_filter_transcripts_001.vcf"};
        SnpEffCmdEff cmd = new SnpEffCmdEff();
        cmd.parseArgs(args);
        List<VcfEntry> vcfEntries = cmd.run(true);
        for (VcfEntry ve : vcfEntries) {
            System.out.println(ve);
            String effs = ve.getInfo("EFF");
            for (String effStr : effs.split(",")) {
                VcfEffect veff = new VcfEffect(effStr);
                System.out.println("\ttrId:" + veff.getTranscriptId() + "\t" + veff);
                if (veff.getTranscriptId().equals("ENST00000400573") || veff.getTranscriptId().equals("ENST00000262608")) continue;
                throw new RuntimeException("This transcript should not be here! " + veff);
            }
        }
    }
}

