/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.ped;

import ca.mcgill.mcb.pcingola.ped.PedGenotype;
import ca.mcgill.mcb.pcingola.ped.PlinkMap;
import ca.mcgill.mcb.pcingola.ped.Sex;
import java.util.Collection;
import java.util.Iterator;

public class PedEntry
implements Iterable<PedGenotype> {
    PlinkMap plinkMap;
    String familyId;
    String id;
    String fatherId;
    String motherId;
    Sex sex;
    String[] genotypes;
    String phenotype;

    public PedEntry(PlinkMap plinkMap, String familyId, String id, String fatherId, String motherId, Sex sex, String phenotype, String[] genotypes) {
        this.plinkMap = plinkMap;
        this.familyId = familyId;
        this.id = id;
        this.fatherId = fatherId;
        this.motherId = motherId;
        this.sex = sex;
        this.phenotype = phenotype;
        this.genotypes = genotypes;
    }

    public int countGenotypes() {
        int count = 0;
        for (PedGenotype gen : this) {
            if (!gen.isValid()) continue;
            ++count;
        }
        return count;
    }

    String genoStr(String geno) {
        if (geno.equals("x") || geno.equals("0")) {
            return "";
        }
        return geno;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public String getFatherId() {
        return this.fatherId;
    }

    public PedGenotype getGenotype(int idx) {
        String[] geno = new String[]{this.genoStr(this.genotypes[idx * 2]), this.genoStr(this.genotypes[idx * 2 + 1])};
        return new PedGenotype(geno, this.plinkMap.getChrName(idx), this.plinkMap.getPosition(idx));
    }

    public PedGenotype getGenotype(String idStr) {
        Integer idxInt = this.plinkMap.getGenotypeNames(idStr);
        if (idxInt == null) {
            return null;
        }
        return this.getGenotype(idxInt);
    }

    public Collection<String> getGenotypeNames() {
        return this.plinkMap.getGenotypeNames();
    }

    public String[] getGenotypes() {
        return this.genotypes;
    }

    public String getId() {
        return this.id;
    }

    public String getMotherId() {
        return this.motherId;
    }

    public String getPhenotype() {
        return this.phenotype;
    }

    public Sex getSex() {
        return this.sex;
    }

    @Override
    public Iterator<PedGenotype> iterator() {
        return new Iterator<PedGenotype>(){
            int i = 0;
            int max = PedEntry.this.size();

            @Override
            public boolean hasNext() {
                return this.i < this.max;
            }

            @Override
            public PedGenotype next() {
                return PedEntry.this.getGenotype(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unsupported! Go away and die!");
            }
        };
    }

    public int size() {
        return this.genotypes.length / 2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.familyId + "\t");
        sb.append(this.id + "\t");
        sb.append(this.fatherId + "\t");
        sb.append(this.motherId + "\t");
        sb.append((Object)((Object)this.sex) + "\t");
        int len = this.genotypes.length / 2;
        for (int i = 0; i < len; i += 2) {
            sb.append(this.genotypes[i] + "/" + this.genotypes[i + 1] + "\t");
        }
        return sb.toString();
    }
}

