/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.outputFormatter;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.outputFormatter.OutputFormatter;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;

public class TxtOutputFormatter
extends OutputFormatter {
    @Override
    public String endSection(Marker marker) {
        if (marker instanceof SeqChange) {
            return super.endSection(marker);
        }
        return null;
    }

    @Override
    public void startSection(Marker marker) {
        if (marker instanceof SeqChange) {
            super.startSection(marker);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        SeqChange seqChange = (SeqChange)this.section;
        for (ChangeEffect changeEffect : this.changeEffects) {
            String cov;
            if (this.changeEffectResutFilter != null && this.changeEffectResutFilter.filter(changeEffect)) continue;
            String hh = "";
            if (seqChange.isHomozygous()) {
                hh = "Hom";
            } else if (seqChange.isHeterozygous()) {
                hh = "Het";
            }
            String qual = seqChange.getQuality() >= 0.0 ? Double.toString(seqChange.getQuality()) : "";
            String string = cov = seqChange.getCoverage() >= 0 ? Integer.toString(seqChange.getCoverage()) : "";
            if (qual.endsWith(".0")) {
                qual = qual.substring(0, qual.length() - 2);
            }
            int start = seqChange.getStart() + this.outOffset;
            int end = seqChange.getEnd() + this.outOffset;
            sb.append(this.chrStr + seqChange.getChromosomeName() + "\t" + start + (seqChange.getChangeType() == SeqChange.ChangeType.Interval ? "-" + end : "") + "\t" + seqChange.reference() + "\t" + seqChange.change() + "\t" + (Object)((Object)seqChange.getChangeType()) + "\t" + hh + "\t" + qual + "\t" + cov + "\t" + changeEffect + "\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String toStringHeader() {
        String header = "# SnpEff version " + this.version + "\n" + "# Command line: " + this.commandLineStr + "\n" + "# Chromo\tPosition\tReference\tChange\tChange_type\tHomozygous\tQuality\tCoverage\t" + new ChangeEffect(null).header();
        return header;
    }
}

