/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.List;

public class Regulation
extends Marker {
    private static final long serialVersionUID = -5607588295343642199L;
    String cellType = "";
    String name = "";

    public Regulation() {
        this.type = ChangeEffect.EffectType.REGULATION;
    }

    public Regulation(Marker parent, int start, int end, int strand, String id, String name, String cellType) {
        super(parent, start, end, strand, id);
        this.type = ChangeEffect.EffectType.REGULATION;
        this.name = name;
        this.cellType = cellType;
    }

    public String getCellType() {
        return this.cellType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (!this.intersects(seqChange)) {
            return ChangeEffect.emptyResults();
        }
        ChangeEffect.EffectType effType = ChangeEffect.EffectType.REGULATION;
        changeEffect.set(this, effType, "");
        return changeEffect.newList();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.cellType = markerSerializer.getNextField();
        this.name = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.cellType + "\t" + this.name;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + (Object)((Object)this.type) + (this.name != null && !this.name.isEmpty() ? " '" + this.name + "'" : "");
    }
}

