/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.binseq.DnaNSequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.MarkerSerializer;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteAcceptor;
import ca.mcgill.mcb.pcingola.interval.SpliceSiteDonor;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.GprSeq;

public class Exon
extends Marker {
    private static final long serialVersionUID = 5324352193278472543L;
    byte frame = 0;
    int rank;
    DnaSequence sequence;
    SpliceSiteAcceptor spliceSiteAcceptor;
    SpliceSiteDonor spliceSiteDonor;
    ExonSpliceType spliceType;

    protected Exon() {
        this.strand = 0;
        this.rank = 0;
        this.sequence = DnaSequence.empty();
        this.type = ChangeEffect.EffectType.EXON;
    }

    public Exon(Transcript parent, int start, int end, int strand, String id, int rank) {
        super(parent, start, end, strand, id);
        this.strand = (byte)strand;
        this.rank = rank;
        this.sequence = DnaSequence.empty();
        this.type = ChangeEffect.EffectType.EXON;
    }

    public String basesAt(int index, int len) {
        if (this.strand < 0) {
            int idx = this.sequence.length() - index - len;
            return GprSeq.reverseWc(this.sequence.getBases(idx, len));
        }
        return this.sequence.getBases(index, len);
    }

    public void check(SeqChange seqChange, ChangeEffect results) {
        if (seqChange.getChangeType() != SeqChange.ChangeType.SNP && seqChange.getChangeType() != SeqChange.ChangeType.MNP) {
            return;
        }
        int mstart = Math.max(seqChange.getStart(), this.start);
        int idxStart = mstart - this.start;
        if (this.sequence.length() <= 0) {
            results.addWarning("WARNING_SEQUENCE_NOT_AVAILABLE");
        } else if (idxStart >= this.sequence.length()) {
            results.addError(ChangeEffect.ErrorType.ERROR_OUT_OF_EXON);
        } else {
            String changeReference;
            int mend = Math.min(seqChange.getEnd(), this.end);
            int len = mend - mstart + 1;
            String realReference = this.basesAt(idxStart, len).toUpperCase();
            if (!realReference.equals(changeReference = seqChange.reference().substring(mstart - seqChange.getStart(), mend - seqChange.getStart() + 1))) {
                results.addWarning("WARNING_REF_IS_" + realReference + "_NOT_" + seqChange.getReference());
            }
        }
    }

    public SpliceSiteAcceptor createSpliceSiteAcceptor(int size) {
        if (--size < 0) {
            return null;
        }
        this.spliceSiteAcceptor = this.strand >= 0 ? new SpliceSiteAcceptor(this, this.start - 1 - size, this.start - 1, (int)this.strand, this.id) : new SpliceSiteAcceptor(this, this.end + 1, this.end + 1 + size, (int)this.strand, this.id);
        return this.spliceSiteAcceptor;
    }

    public SpliceSiteDonor createSpliceSiteDonor(int size) {
        if (--size < 0) {
            return null;
        }
        this.spliceSiteDonor = this.strand >= 0 ? new SpliceSiteDonor(this, this.end + 1, this.end + 1 + size, (int)this.strand, this.id) : new SpliceSiteDonor(this, this.start - 1 - size, this.start - 1, (int)this.strand, this.id);
        return this.spliceSiteDonor;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getRank() {
        return this.rank;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public SpliceSiteAcceptor getSpliceSiteAcceptor() {
        return this.spliceSiteAcceptor;
    }

    public SpliceSiteDonor getSpliceSiteDonor() {
        return this.spliceSiteDonor;
    }

    public ExonSpliceType getSpliceType() {
        return this.spliceType;
    }

    public boolean hasSequence() {
        if (this.size() <= 0) {
            return true;
        }
        return this.sequence != null && !this.sequence.isEmpty();
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.frame = (byte)markerSerializer.getNextFieldInt();
        this.rank = markerSerializer.getNextFieldInt();
        this.setSequence(markerSerializer.getNextField());
        this.spliceSiteDonor = (SpliceSiteDonor)markerSerializer.getNextFieldMarker();
        this.spliceSiteAcceptor = (SpliceSiteAcceptor)markerSerializer.getNextFieldMarker();
        String exType = markerSerializer.getNextField();
        if (exType != null && !exType.isEmpty()) {
            this.spliceType = ExonSpliceType.valueOf(exType);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        int ssdId = markerSerializer.save(this.spliceSiteDonor);
        int ssaId = markerSerializer.save(this.spliceSiteAcceptor);
        return super.serializeSave(markerSerializer) + "\t" + this.frame + "\t" + this.rank + "\t" + this.sequence + "\t" + ssdId + "\t" + ssaId + "\t" + (this.spliceType != null ? this.spliceType.toString() : "");
    }

    public void setFrame(int frame) {
        if (frame > 2 || frame < -1) {
            throw new RuntimeException("Invalid frame value: " + frame);
        }
        this.frame = (byte)frame;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setSequence(String sequence) {
        if (sequence == null || sequence.length() <= 0) {
            this.sequence = DnaSequence.empty();
        }
        this.sequence = GprSeq.isAmbiguous(sequence) ? new DnaNSequence(sequence) : new DnaSequence(sequence);
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + ":" + this.start + "-" + this.end + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + " rank:" + this.rank + (this.sequence != null ? ", sequence: " + this.sequence : "");
    }

    public static enum ExonSpliceType {
        RETAINED,
        SKIPPED,
        ALTTENATIVE_3SS,
        ALTTENATIVE_5SS,
        MUTUALLY_EXCLUSIVE,
        ALTTENATIVE_PROMOMOTER,
        ALTTENATIVE_POLY_A;

    }
}

