/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.bior.pipeline.VcfInfoColumnBuilder;
import edu.mayo.bior.util.ColumnResolver;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class TjsonToVcfPipe
extends AbstractPipe<History, History> {
    public final String DEFAULT_DESCRIPTION = "BioR property file missing description";
    public final String DEFAULT_TYPE = "String";
    public final String DEFAULT_NUMBER = ".";
    private final int INFO_COL = 7;
    private final int NUM_REQUIRED_VCF_COLS = 8;
    private final int QUEUE_LIMIT = 200;
    private List<History> mLineQueue = new ArrayList<History>();
    private static final Logger sLogger = Logger.getLogger(TjsonToVcfPipe.class);
    Map<Integer, String> biorindexes = new LinkedHashMap<Integer, String>();
    private boolean mIsHeaderModified = false;
    private Map<String, ColumnMetaData> mInfoMetadata = new HashMap<String, ColumnMetaData>();
    private int mJsonColumn = -1;
    private boolean mIsKeepAllColumns = false;
    private boolean mIsAddDataToInfo = false;
    private String mColumnsToCollapseUserInputString = null;
    private List<Integer> mColumnsToCollapseList = new ArrayList<Integer>();
    private long mLineNum = 0L;
    private Gson gson = new Gson();
    private VcfInfoColumnBuilder mVcfInfoColumnBuilder = new VcfInfoColumnBuilder();
    private boolean mIsAlreadyAVcf;
    private boolean mIsPrevPipeHasNext = true;

    public TjsonToVcfPipe(int jsonCol, boolean isKeepAllColumns, boolean isAddDataToInfo, String colRangeToCollapseToInfoCol) {
        this.mJsonColumn = jsonCol;
        this.mIsKeepAllColumns = isKeepAllColumns;
        this.mIsAddDataToInfo = isAddDataToInfo;
        this.mColumnsToCollapseUserInputString = colRangeToCollapseToInfoCol;
        if (this.mColumnsToCollapseUserInputString == null) {
            this.mColumnsToCollapseUserInputString = "";
        }
    }

    public TjsonToVcfPipe(int jsonCol) {
        this(jsonCol, false, true, "");
    }

    public TjsonToVcfPipe() {
        this(-1, false, true, "");
    }

    protected History processNextStart() throws NoSuchElementException {
        History history;
        while (this.mIsPrevPipeHasNext && (this.mIsPrevPipeHasNext = this.starts.hasNext()) && this.mLineQueue.size() < 200) {
            history = (History)this.starts.next();
            this.mLineQueue.add(history);
        }
        if (this.mLineQueue.size() == 0) {
            if (this.mLineNum == 0L) {
                System.err.println("Warning: No data lines available, so headers could not be modified.");
            } else {
                throw new NoSuchElementException("No more data to process");
            }
        }
        history = this.mLineQueue.get(0);
        History historyAsVcf = this.lineToVcf(history);
        this.mLineQueue.remove(0);
        return historyAsVcf;
    }

    private List<Integer> getColumnRangesAsList(History history, String colRangesStr) {
        List<Object> colRangeList = new ArrayList();
        try {
            colRangeList = colRangesStr == null || colRangesStr.length() == 0 ? this.getAllBiorColumns(history) : ColumnResolver.rangesToZeroBasedIndexes(history, colRangesStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return colRangeList;
    }

    private List<Integer> getAllBiorColumns(History history) {
        Set<String> biorColumnNamesFromMetadata = this.getBiorColumnIdsFromMetadata(history.getMetaData().getOriginalHeader());
        ArrayList<Integer> biorColumnIndexes = new ArrayList<Integer>();
        List columnMetaList = history.getMetaData().getColumns();
        for (int i = 0; i < columnMetaList.size(); ++i) {
            String colName = ((ColumnMetaData)columnMetaList.get((int)i)).columnName;
            if (!colName.toLowerCase().startsWith("bior") && !biorColumnNamesFromMetadata.contains(colName)) continue;
            biorColumnIndexes.add(i);
        }
        return biorColumnIndexes;
    }

    public Set<String> getBiorColumnIdsFromMetadata(List<String> metadataLines) {
        HashSet<String> columns = new HashSet<String>();
        for (String metadataLine : metadataLines) {
            if (!metadataLine.startsWith("##BIOR=<ID")) continue;
            columns.add(this.getIdFromBiorMetadata(metadataLine));
        }
        return columns;
    }

    private String getIdFromBiorMetadata(String biorMetadataLine) {
        String PREFIX = "##BIOR=<ID=";
        int idxIdStart = biorMetadataLine.indexOf("##BIOR=<ID=");
        int idxIdEnd = biorMetadataLine.indexOf(",", idxIdStart);
        if (idxIdEnd == -1) {
            idxIdEnd = biorMetadataLine.indexOf(">", idxIdStart);
        }
        if (idxIdStart == -1 || idxIdEnd == -1) {
            return "";
        }
        return biorMetadataLine.substring(idxIdStart + "##BIOR=<ID=".length(), idxIdEnd).replaceAll("\"", "");
    }

    protected History lineToVcf(History history) {
        if (this.isBlankLine(history)) {
            return new History();
        }
        this.modifyHeaderMetadataOnce(history);
        return this.modifyDataLine(history);
    }

    private boolean isBlankLine(History history) {
        return history == null || history.size() == 0 || history.size() == 1 && ((String)history.get(0)).trim().length() == 0;
    }

    private void modifyHeaderMetadataOnce(History history) {
        if (!this.mIsHeaderModified) {
            this.mIsAlreadyAVcf = this.isAlreadyAVcf(history);
            this.mJsonColumn = ColumnResolver.numberToZeroBasedIndex(history, this.mJsonColumn, this.mLineNum);
            this.mColumnsToCollapseList = this.getColumnRangesAsList(history, this.mColumnsToCollapseUserInputString);
            this.addInfoHeaderLines(history);
            this.addTopMostHeaders(history);
            this.modifyHeaderLineToVcfFormat(history);
            this.mIsHeaderModified = true;
        }
    }

    private void addInfoHeaderLines(History history) {
        if (this.mLineQueue.size() == 0) {
            this.mLineQueue.add(history);
        }
        List<String> infoMetaHeaders = this.mVcfInfoColumnBuilder.createInfoMetadata(this.mLineQueue, this.mColumnsToCollapseList);
        if (!this.mIsAlreadyAVcf && this.mIsAddDataToInfo) {
            infoMetaHeaders.addAll(this.mVcfInfoColumnBuilder.createInfoMetadataFromInfoInTargetCol(this.mLineQueue, this.mJsonColumn));
        }
        if (this.mIsAddDataToInfo) {
            for (String infoMetaHeader : infoMetaHeaders) {
                this.mVcfInfoColumnBuilder.addInfoLineToHeader(history, infoMetaHeader);
            }
        }
    }

    private History modifyDataLine(History history) {
        ++this.mLineNum;
        String newInfoValues = "";
        if (this.mIsAddDataToInfo) {
            newInfoValues = this.mVcfInfoColumnBuilder.createInfoData(history, this.mColumnsToCollapseList);
        }
        List<Object> vcfRequiredColsToInsert = new ArrayList();
        if (!this.mIsAlreadyAVcf) {
            vcfRequiredColsToInsert = this.getRequiredVcfColumnsToInsertIntoDataLine(history);
        }
        if (!this.mIsKeepAllColumns) {
            if (this.mIsAlreadyAVcf) {
                this.mColumnsToCollapseList.removeAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7));
            }
            this.removeTargetAndSpecifiedColumns(history, this.mColumnsToCollapseList);
        }
        history.addAll(0, vcfRequiredColsToInsert);
        String infoCol = this.mergeOldInfoValuesWithNew((String)history.get(7), newInfoValues);
        history.set(7, (Object)infoCol);
        return history;
    }

    protected String mergeOldInfoValuesWithNew(String oldInfoValues, String newInfoValues) {
        String merged = oldInfoValues + ";" + newInfoValues;
        while (merged.startsWith(".") || merged.startsWith(";")) {
            merged = merged.substring(1);
        }
        while (merged.endsWith(".") || merged.endsWith(";")) {
            merged = merged.substring(0, merged.length() - 1);
        }
        if (merged.length() == 0) {
            merged = ".";
        }
        return merged;
    }

    protected boolean isAlreadyAVcf(History history) {
        HistoryMetaData metadata = history.getMetaData();
        if (metadata == null) {
            throw new IllegalStateException("Error: Header information is required to construct the VCF");
        }
        String header = metadata.getColumnHeaderRow(history, "\t");
        String[] columnHeaders = header.split("\t");
        return columnHeaders != null && columnHeaders.length >= 8 && columnHeaders[0].equalsIgnoreCase("#CHROM") && columnHeaders[1].equalsIgnoreCase("POS") && columnHeaders[2].equalsIgnoreCase("ID") && columnHeaders[3].equalsIgnoreCase("REF") && columnHeaders[4].equalsIgnoreCase("ALT") && columnHeaders[5].equalsIgnoreCase("QUAL") && columnHeaders[6].equalsIgnoreCase("FILTER") && columnHeaders[7].equalsIgnoreCase("INFO");
    }

    private List<String> getRequiredVcfColumnsToInsertIntoDataLine(History history) {
        JsonElement jsonElem = this.getJsonElementFromColumn((String)history.get(this.mJsonColumn));
        String chrom = this.getJsonVal(jsonElem, "_landmark", true, this.mLineNum);
        String pos = this.getJsonVal(jsonElem, "_minBP", true, this.mLineNum);
        String id = this.getJsonVal(jsonElem, "_id", false, this.mLineNum);
        String ref = this.getJsonVal(jsonElem, "_refAllele", true, this.mLineNum);
        String alt = this.splitAlts(this.getJsonVal(jsonElem, "_altAlleles", true, this.mLineNum));
        String qual = this.getJsonVal(jsonElem, "QUAL", false, this.mLineNum);
        String filter = this.getJsonVal(jsonElem, "FILTER", false, this.mLineNum);
        String info = ".";
        if (id.equals(".")) {
            id = this.getJsonVal(jsonElem, "ID", false, this.mLineNum);
        }
        if (this.mIsAddDataToInfo && this.mVcfInfoColumnBuilder.isJsonObject(info = this.getJsonVal(jsonElem, "INFO", false, this.mLineNum))) {
            JsonObject infoJsonObj = new JsonParser().parse(info).getAsJsonObject();
            info = this.mVcfInfoColumnBuilder.jsonObjectToInfoDataString("", infoJsonObj);
        }
        List<String> colsToInsert = Arrays.asList(chrom, pos, id, ref, alt, qual, filter, info);
        return colsToInsert;
    }

    private JsonElement getJsonElementFromColumn(String json) {
        JsonElement jsonElem = null;
        try {
            jsonElem = new JsonParser().parse(json);
            JsonObject jsonObject = jsonElem.getAsJsonObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error: Data line " + this.mLineNum + ":  Target column not JSON.  Was: " + json);
        }
        return jsonElem;
    }

    private void removeTargetAndSpecifiedColumns(History history, List<Integer> columnsToRemove) {
        Collections.sort(columnsToRemove, Collections.reverseOrder());
        for (Integer biorCol : columnsToRemove) {
            history.remove(biorCol.intValue());
        }
    }

    protected String getJsonVal(JsonElement jsonElem, String key, boolean isRequired, long lineNum) {
        JsonElement obj = jsonElem.getAsJsonObject().get(key);
        if (isRequired && obj == null) {
            throw new IllegalStateException("Error: Required JSON field [" + key + "] missing on data line " + lineNum + ": Target column must contain these JSON fields: _landmark, _minBP, _refAllele, _altAlleles.  " + "Was: " + jsonElem.toString());
        }
        String val = ".";
        val = obj == null ? "." : (obj.isJsonPrimitive() ? obj.getAsString() : obj.toString());
        return val;
    }

    protected String splitAlts(String jsonAltArray) {
        return jsonAltArray.replace("[", "").replace("]", "").replaceAll("\"", "");
    }

    private void modifyHeaderLineToVcfFormat(History history) {
        if (!this.mIsKeepAllColumns) {
            if (this.mIsAlreadyAVcf) {
                this.mColumnsToCollapseList.removeAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7));
            }
            this.removeColumnMetaData(history, this.mColumnsToCollapseList);
        }
        if (!this.mIsAlreadyAVcf) {
            this.insertVcfRequiredColumnsIntoHeader(history);
        }
    }

    private void removeColumnMetaData(History history, List<Integer> columnsToRemove) {
        Collections.sort(columnsToRemove, Collections.reverseOrder());
        List colMetaData = history.getMetaData().getColumns();
        for (Integer biorCol : columnsToRemove) {
            colMetaData.remove(biorCol);
        }
    }

    private void removeColumnHeaderName(History history, int headerColumnIdxToRemove) {
        System.err.println("removeColumnHeaderName() : Is this method needed?  Is the header row just constructed from the ColumnMetaData????");
    }

    private void insertVcfRequiredColumnsIntoHeader(History history) {
        History colHeaderLine;
        List headerLines = history.getMetaData().getOriginalHeader();
        History history2 = colHeaderLine = headerLines.size() > 0 ? new History((String)headerLines.get(headerLines.size() - 1)) : new History();
        if (colHeaderLine.size() > 0) {
            colHeaderLine.set(0, (Object)((String)colHeaderLine.get(0)).replace("#", ""));
        }
        colHeaderLine.addAll(0, Arrays.asList("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"));
        if (headerLines.size() > 0) {
            headerLines.set(headerLines.size() - 1, colHeaderLine.getMergedData("\t"));
        } else {
            headerLines.add(colHeaderLine.getMergedData("\t"));
        }
        List meta = history.getMetaData().getColumns();
        meta.addAll(0, Arrays.asList(new ColumnMetaData("CHROM", ColumnMetaData.Type.String, "1", "Chromosome"), new ColumnMetaData("POS", ColumnMetaData.Type.String, "1", "Position"), new ColumnMetaData("ID", ColumnMetaData.Type.String, "1", "Id or rsId"), new ColumnMetaData("REF", ColumnMetaData.Type.String, "1", "Reference Allele"), new ColumnMetaData("ALT", ColumnMetaData.Type.String, ".", "Alternate Alleles"), new ColumnMetaData("QUAL", ColumnMetaData.Type.String, "1", "Quality"), new ColumnMetaData("FILTER", ColumnMetaData.Type.String, "1", "Filter"), new ColumnMetaData("INFO", ColumnMetaData.Type.String, ".", "Info")));
    }

    private void addTopMostHeaders(History history) {
        List headers = history.getMetaData().getOriginalHeader();
        if (!this.isHeaderExists("##fileformat", history)) {
            headers.add(0, "##fileformat=VCFv4.2");
        }
        if (!this.isHeaderExists("##fileDate", history)) {
            this.insertAfter("##fileDate=" + new SimpleDateFormat("yyyyMMdd").format(new Date()), "##fileformat", history);
        }
        if (!this.isHeaderExists("##source", history)) {
            this.insertAfter("##source=bior_tjson_to_vcf", "##fileDate", history);
        }
    }

    private void insertAfter(String headerLine, String keyToInsertAfter, History history) {
        int lineOfKeyToInsertAfter = this.getHeaderRowIndex(keyToInsertAfter, history);
        history.getMetaData().getOriginalHeader().add(lineOfKeyToInsertAfter + 1, headerLine);
    }

    protected boolean isHeaderExists(String headerKey, History history) {
        return -1 != this.getHeaderRowIndex(headerKey, history);
    }

    private int getHeaderRowIndex(String headerKey, History history) {
        List headers = history.getMetaData().getOriginalHeader();
        String headerKeyLower = headerKey.toLowerCase();
        for (int i = 0; i < headers.size(); ++i) {
            String key;
            int idxEq = ((String)headers.get(i)).indexOf("=");
            if (idxEq == -1 || !headerKeyLower.equals(key = ((String)headers.get(i)).toLowerCase().substring(0, idxEq))) continue;
            return i;
        }
        return -1;
    }

    public HistoryMetaData removeColumnHeader(HistoryMetaData metaData, Map<Integer, String> biorindexes2) {
        List columns = metaData.getColumns();
        ArrayList<Integer> indexes = new ArrayList<Integer>(biorindexes2.keySet());
        Collections.sort(indexes);
        Collections.reverse(indexes);
        Iterator i$ = indexes.iterator();
        while (i$.hasNext()) {
            int j = (Integer)i$.next();
            ColumnMetaData cmd = (ColumnMetaData)columns.get(j);
            columns.remove(cmd);
        }
        return metaData;
    }
}

