/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.functions;

import java.util.Iterator;
import java.util.Random;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.functions.AbstractCrossOverFunction;
import org.biojavax.ga.functions.GACrossResult;
import org.biojavax.ga.functions.SimpleGACrossResult;

public class OrderCrossover
extends AbstractCrossOverFunction {
    public OrderCrossover() {
        this.setMaxCrossOvers(2);
        double[] pro = new double[]{0.5};
        this.setCrossOverProbs(pro);
    }

    public GACrossResult performCrossOver(SymbolList chromA, SymbolList chromB) throws ChangeVetoException {
        int[] crosslocations = this.generateCrossoverLocations(chromA.length());
        if ((double)crosslocations[1] != 0.0) {
            Iterator<Symbol> it;
            if ((double)crosslocations[0] == 0.0) {
                crosslocations[0] = crosslocations[1];
                crosslocations[1] = chromA.length();
            }
            Alphabet alphA = chromA.getAlphabet();
            Alphabet alphB = chromB.getAlphabet();
            SymbolList snipA = chromA.subList(crosslocations[0], crosslocations[1]);
            SymbolList snipB = chromB.subList(crosslocations[0], crosslocations[1]);
            SymbolList snipAwoB = snipA.subList(1, snipA.length());
            SymbolList snipBwoA = snipB.subList(1, snipB.length());
            block12: for (int i = 1; i <= snipB.length(); ++i) {
                int j = 1;
                it = snipAwoB.iterator();
                boolean notfound = true;
                while (it.hasNext() && notfound) {
                    if (it.next().equals(snipB.symbolAt(i))) {
                        try {
                            snipAwoB.edit(new Edit(j, 1, SymbolList.EMPTY_LIST));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++j;
                }
                Iterator<Symbol> it2 = snipBwoA.iterator();
                j = 1;
                while (it2.hasNext()) {
                    if (it2.next().equals(snipA.symbolAt(i))) {
                        try {
                            snipBwoA.edit(new Edit(j, 1, SymbolList.EMPTY_LIST));
                            continue block12;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
            }
            int sniplength = crosslocations[1] - crosslocations[0] + 1;
            try {
                Iterator<Symbol> it3;
                Symbol current;
                chromA.edit(new Edit(crosslocations[0], sniplength, SymbolList.EMPTY_LIST));
                chromB.edit(new Edit(crosslocations[0], sniplength, SymbolList.EMPTY_LIST));
                Iterator<Symbol> it1 = snipA.iterator();
                block15: while (it1.hasNext()) {
                    current = it1.next();
                    Iterator<Symbol> it2 = chromB.iterator();
                    it3 = chromA.iterator();
                    int position = 1;
                    while (it2.hasNext()) {
                        if (it2.next().equals(current)) {
                            chromB.edit(new Edit(position, 1, SymbolList.EMPTY_LIST));
                            continue block15;
                        }
                        ++position;
                    }
                }
                it1 = snipB.iterator();
                block17: while (it1.hasNext()) {
                    current = it1.next();
                    Iterator<Symbol> it2 = chromA.iterator();
                    it3 = chromB.iterator();
                    int position = 1;
                    boolean notfound = true;
                    while (it2.hasNext() && notfound) {
                        if (it2.next().equals(current)) {
                            chromA.edit(new Edit(position, 1, SymbolList.EMPTY_LIST));
                            notfound = false;
                            continue block17;
                        }
                        ++position;
                    }
                }
            }
            catch (IllegalAlphabetException e) {
                System.out.println("Sorry, you used an illegal alphabet");
                e.printStackTrace();
            }
            try {
                chromA.edit(new Edit(1, 0, snipB));
                chromA.edit(new Edit(1, 0, snipAwoB));
                chromB.edit(new Edit(1, 0, snipA));
                chromB.edit(new Edit(1, 0, snipBwoA));
            }
            catch (IllegalAlphabetException e) {
                e.printStackTrace();
            }
            int newposition = 1;
            it = chromA.iterator();
            while (it.hasNext() && !it.next().equals(snipB.symbolAt(1))) {
                ++newposition;
            }
            int versatz = crosslocations[0] - newposition;
            if (versatz < 0) {
                versatz = Math.abs(versatz);
                try {
                    SymbolList temp = chromA.subList(1, versatz);
                    chromA.edit(new Edit(1, versatz, SymbolList.EMPTY_LIST));
                    chromA.edit(new Edit(chromA.length() + 1, 0, temp));
                    temp = chromB.subList(1, versatz);
                    chromB.edit(new Edit(1, versatz, SymbolList.EMPTY_LIST));
                    chromB.edit(new Edit(chromB.length() + 1, 0, temp));
                }
                catch (IllegalAlphabetException e) {
                    e.printStackTrace();
                }
            } else if (versatz > 0) {
                try {
                    int start = chromA.length() - --versatz;
                    SymbolList temp = chromA.subList(start, chromA.length());
                    chromA.edit(new Edit(start, chromA.length() - (start - 1), SymbolList.EMPTY_LIST));
                    chromA.edit(new Edit(1, 0, temp));
                    temp = chromB.subList(start, chromB.length());
                    chromB.edit(new Edit(start, chromB.length() - (start - 1), SymbolList.EMPTY_LIST));
                    chromB.edit(new Edit(1, 0, temp));
                }
                catch (IllegalAlphabetException e) {
                    e.printStackTrace();
                }
            }
            PointLocation[] points = new PointLocation[]{new PointLocation(crosslocations[0]), new PointLocation(crosslocations[1])};
            SimpleGACrossResult result = new SimpleGACrossResult(points, new SymbolList[]{chromA, chromB});
            return result;
        }
        return null;
    }

    private synchronized int[] generateCrossoverLocations(int chromlength) {
        Random n = new Random();
        int[] locations = new int[2];
        double[] crosses = new double[chromlength];
        int maxIndex = this.getCrossOverProbs().length - 1;
        for (int i = 1; i <= chromlength; ++i) {
            int index = Math.min(i - 1, maxIndex);
            double crossProb = this.getCrossOverProbs()[index] - n.nextDouble();
            crosses[i - 1] = crossProb >= 0.0 ? crossProb : 0.0;
        }
        double highest = 0.0;
        double second = 0.0;
        for (int j = 0; j < crosses.length; ++j) {
            double current = crosses[j];
            if (!(current > second)) continue;
            if (current > highest) {
                locations[0] = locations[1];
                second = highest;
                locations[1] = j + 1;
                highest = current;
                continue;
            }
            second = current;
            locations[0] = j + 1;
        }
        if (locations[0] > locations[1]) {
            int temp = locations[0];
            locations[0] = locations[1];
            locations[1] = temp;
        }
        return locations;
    }
}

