/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileOutput;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.PixelGrabber;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JFrame;

public class DigiGraph
extends Canvas
implements MouseListener {
    private Image pic = null;
    private String imagePath = null;
    private String imageName = null;
    private String extension = null;
    private String outputFile = null;
    private FileOutput fout = null;
    private int trunc = 16;
    private String path = "C:";
    private int windowWidth = 0;
    private int windowHeight = 0;
    private int closeChoice = 1;
    private int xPos = 0;
    private int yPos = 0;
    private int button = 0;
    private int sumX = 0;
    private int sumY = 0;
    private int iSum = 0;
    private boolean mouseEntered = false;
    private double lowYvalue = 0.0;
    private double lowYaxisXpixel = 0.0;
    private double lowYaxisYpixel = 0.0;
    private double highYvalue = 0.0;
    private double highYaxisXpixel = 0.0;
    private double highYaxisYpixel = 0.0;
    private double lowXvalue = 0.0;
    private double lowXaxisXpixel = 0.0;
    private double lowXaxisYpixel = 0.0;
    private double highXvalue = 0.0;
    private double highXaxisXpixel = 0.0;
    private double highXaxisYpixel = 0.0;
    private ArrayList<Integer> xAndYvalues = new ArrayList();
    private int iCounter = 0;
    private double angleXaxis = 0.0;
    private double angleYaxis = 0.0;
    private double angleMean = 0.0;
    private double angleTolerance = 0.0;
    private boolean rotationDone = false;
    private double[] xPosPixel = null;
    private double[] yPosPixel = null;
    private double[] xPositions = null;
    private double[] yPositions = null;
    private int nData = 0;
    private int nInterpPoints = 0;
    private boolean interpOpt = false;
    private double[] xInterp = null;
    private double[] yInterp = null;
    private boolean plotOpt = true;
    private boolean noIdentical = true;
    private int imageFormat = 0;
    private boolean digitizationDone = false;
    private boolean noYlow = true;
    private boolean noXlow = true;
    private boolean noYhigh = true;
    private boolean noXhigh = true;
    private boolean resize = false;
    private JFrame window = new JFrame("Michael T Flanagan's digitizing program - DigiGraph");

    public DigiGraph() {
        this.setWindowSize();
        this.selectImage();
        this.setImage();
        this.outputFileChoice();
        this.addMouseListener(this);
    }

    public DigiGraph(String windowPath) {
        this.setWindowSize();
        this.path = windowPath;
        this.selectImage();
        this.setImage();
        this.outputFileChoice();
        this.addMouseListener(this);
    }

    private void setWindowSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.windowWidth = screenSize.width - 30;
        this.windowHeight = screenSize.height - 40;
    }

    private void selectImage() {
        String computerName = null;
        try {
            InetAddress localaddress = InetAddress.getLocalHost();
            computerName = localaddress.getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println("Cannot detect local host : " + e);
        }
        if (computerName.equals("name")) {
            this.path = "C:\\DigiGraphDirectory";
        }
        FileChooser fc = new FileChooser(this.path);
        this.imageName = fc.selectFile();
        if (!fc.fileFound()) {
            System.out.println("Class DigiGraph: No successful selection of an image file occurred");
            System.exit(0);
        }
        this.imagePath = fc.getPathName();
        int lastDot = this.imagePath.lastIndexOf(46);
        this.extension = this.imagePath.substring(lastDot + 1);
        if (this.extension.equalsIgnoreCase("gif")) {
            this.imageFormat = 1;
        }
        if (this.extension.equalsIgnoreCase("jpg")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jpeg")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jpe")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("jfif")) {
            this.imageFormat = 2;
        }
        if (this.extension.equalsIgnoreCase("png")) {
            this.imageFormat = 3;
        }
    }

    private void setImage() {
        this.pic = Toolkit.getDefaultToolkit().getImage(this.imagePath);
    }

    private void outputFileChoice() {
        int posdot = this.imagePath.lastIndexOf(46);
        this.outputFile = this.imagePath.substring(0, posdot) + "_digitized.txt";
        this.outputFile = Db.readLine("Enter output file name ", this.outputFile);
        this.fout = new FileOutput(this.outputFile);
        this.trunc = Db.readInt("Enter number of decimal places required in output data ", this.trunc);
    }

    public void setTruncation(int trunc) {
        this.trunc = trunc;
    }

    public void setRotationTolerance(double tol) {
        this.angleTolerance = tol;
    }

    public void noPlot() {
        this.plotOpt = false;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public void setCloseChoice(int choice) {
        this.closeChoice = choice;
    }

    public void keepIdenticalPoints() {
        this.noIdentical = false;
    }

    @Override
    public void paint(Graphics g) {
        this.graph(g);
    }

    public void digitize() {
        this.window.setSize(this.windowWidth, this.windowHeight);
        this.window.getContentPane().setBackground(Color.white);
        if (this.closeChoice == 1) {
            this.window.setDefaultCloseOperation(3);
        } else {
            this.window.setDefaultCloseOperation(1);
        }
        this.window.getContentPane().add("Center", this);
        this.window.pack();
        this.window.setResizable(true);
        this.window.toFront();
        this.window.setVisible(true);
    }

    public void digitise() {
        this.digitize();
    }

    private void graph(Graphics g) {
        g.drawImage(this.pic, 10, 30, this);
        if (!this.resize) {
            g.drawString("RIGHT click anywhere on the screen", 5, 10);
            int width = this.pic.getWidth(null);
            int height = this.pic.getHeight(null);
            System.out.println(width + " xxx " + height);
            g.drawString("  ", 5, 10);
            double factor = (double)(this.windowHeight - 30) / (double)height;
            if ((int)((double)width * factor) > this.windowWidth - 10) {
                factor = (double)(this.windowWidth - 10) / (double)width;
            }
            height = (int)((double)(height - 30) * factor * 0.95);
            width = (int)((double)(width - 10) * factor + 0.95);
            this.pic = this.pic.getScaledInstance(width, height, 1);
            g.drawImage(this.pic, 10, 30, this);
            this.resize = true;
        }
        boolean test = true;
        if (this.xPos == 0 && this.yPos == 0) {
            test = false;
        }
        if (test) {
            this.cursorDoneSign(g, this.xPos, this.yPos);
        }
        if (!this.digitizationDone) {
            switch (this.iCounter) {
                case 0: {
                    g.drawString("RIGHT click on lower Y-axis calibration point", 5, 10);
                    break;
                }
                case 1: {
                    if (this.noYlow) {
                        this.lowYvalue = Db.readDouble("Enter lower Y-axis calibration value");
                        this.noYlow = false;
                    }
                    g.drawString("RIGHT click on higher Y-axis calibration point", 5, 10);
                    break;
                }
                case 2: {
                    if (this.noYhigh) {
                        this.highYvalue = Db.readDouble("Enter higher Y-axis calibration value");
                        this.noYhigh = false;
                    }
                    g.drawString("RIGHT click on lower X-axis calibration point", 5, 10);
                    break;
                }
                case 3: {
                    if (this.noXlow) {
                        this.lowXvalue = Db.readDouble("Enter lower X-axis calibration value");
                        this.noXlow = false;
                    }
                    g.drawString("RIGHT click on higher X-axis calibration point", 5, 10);
                    break;
                }
                case 4: {
                    if (this.noXhigh) {
                        this.highXvalue = Db.readDouble("Enter higher X-axis calibration value");
                        this.noXhigh = false;
                    }
                    g.drawString("LEFT click on points to be digitized [right click when finished digitizing]", 5, 10);
                    break;
                }
                default: {
                    g.drawString("LEFT click on points to be digitized [right click when finished digitizing]", 5, 10);
                    break;
                }
            }
        } else {
            g.drawString("You may now close this window", 5, 10);
        }
    }

    private void cursorDoneSign(Graphics g, int x, int y) {
        g.drawLine(x - 5, y, x + 5, y);
        g.drawLine(x, y - 5, x, y + 5);
        g.fillOval(x - 3, y - 3, 7, 7);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.digitizationDone) {
            switch (this.iCounter) {
                case 0: {
                    this.xPos = me.getX();
                    this.yPos = me.getY();
                    this.button = me.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.lowYaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.lowYaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 1: {
                    this.xPos = me.getX();
                    this.yPos = me.getY();
                    this.button = me.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.highYaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.highYaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 2: {
                    this.xPos = me.getX();
                    this.yPos = me.getY();
                    this.button = me.getButton();
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.lowXaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.lowXaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                case 3: {
                    this.xPos = me.getX();
                    this.yPos = me.getY();
                    this.button = me.getButton();
                    PixelGrabber pixelGrabber = new PixelGrabber(this.pic, this.xPos, this.yPos, 1, 1, false);
                    if (this.button == 1) {
                        this.sumX += this.xPos;
                        this.sumY += this.yPos;
                        ++this.iSum;
                        break;
                    }
                    if (this.button != 3) break;
                    this.sumX += this.xPos;
                    this.sumY += this.yPos;
                    ++this.iSum;
                    this.highXaxisXpixel = (double)this.sumX / (double)this.iSum;
                    this.highXaxisYpixel = (double)this.windowHeight - (double)this.sumY / (double)this.iSum;
                    ++this.iCounter;
                    this.sumX = 0;
                    this.sumY = 0;
                    this.iSum = 0;
                    break;
                }
                default: {
                    this.xPos = me.getX();
                    this.yPos = me.getY();
                    this.button = me.getButton();
                    if (this.button == 1) {
                        this.xAndYvalues.add(new Integer(this.xPos));
                        this.xAndYvalues.add(new Integer(this.yPos));
                    }
                    if (this.button != 3 || this.xAndYvalues.size() / 2 == 0) break;
                    this.outputData();
                    this.digitizationDone = true;
                }
            }
        }
        this.repaint();
    }

    private void outputData() {
        int i;
        int i2;
        this.nData = this.xAndYvalues.size() / 2;
        System.out.println("nData " + this.nData);
        this.xPositions = new double[this.nData];
        this.yPositions = new double[this.nData];
        this.xPosPixel = new double[this.nData];
        this.yPosPixel = new double[this.nData];
        int ii = 0;
        for (i2 = 0; i2 < this.nData; ++i2) {
            int xx = this.xAndYvalues.get(ii);
            int yy = this.xAndYvalues.get(++ii);
            ++ii;
            this.xPosPixel[i2] = xx;
            this.yPosPixel[i2] = (double)this.windowHeight - (double)yy;
        }
        this.checkForRotation();
        for (i2 = 0; i2 < this.nData; ++i2) {
            this.xPositions[i2] = this.lowXvalue + (this.xPosPixel[i2] - this.lowXaxisXpixel) * (this.highXvalue - this.lowXvalue) / (this.highXaxisXpixel - this.lowXaxisXpixel);
            this.yPositions[i2] = this.lowYvalue + (this.yPosPixel[i2] - this.lowYaxisYpixel) * (this.highYvalue - this.lowYvalue) / (this.highYaxisYpixel - this.lowYaxisYpixel);
        }
        if (this.noIdentical) {
            this.checkForIdenticalPoints();
        }
        String message = "Do you wish to increase number of data points\n";
        boolean opt = Db.noYes(message = message + "using cubic spline interpolation?");
        if (opt) {
            this.nInterpPoints = Db.readInt("Enter number of interpolation points", 200);
            this.interpolation();
            this.interpOpt = true;
        } else if (this.plotOpt) {
            this.plotDigitisedPoints();
        }
        this.fout.println("Digitization output for DigiGraph class (M. T. Flanagan Java Library)");
        this.fout.println();
        this.fout.dateAndTimeln();
        this.fout.println();
        this.fout.println("Image used in the digitization:                 " + this.imageName);
        this.fout.println("Location of the image used in the digitization: " + this.imagePath);
        this.fout.println();
        this.fout.println("X-axis skew angle    " + Fmath.truncate(this.angleXaxis, 4) + " degrees");
        this.fout.println("Y-axis skew angle    " + Fmath.truncate(this.angleYaxis, 4) + " degrees");
        this.fout.println("Axes mean skew angle " + Fmath.truncate(this.angleMean, 4) + " degrees");
        if (this.rotationDone) {
            this.fout.println("Axes and all points rotated to bring axes to normal position");
        } else {
            this.fout.println("No rotation of axes or points performed");
        }
        this.fout.println();
        this.fout.println("Number of digitized points: " + this.nData);
        this.fout.println();
        this.fout.printtab("X-value");
        this.fout.println("Y-value");
        for (i = 0; i < this.nData; ++i) {
            this.fout.printtab(Fmath.truncate(this.xPositions[i], this.trunc));
            this.fout.println(Fmath.truncate(this.yPositions[i], this.trunc));
        }
        this.fout.println();
        if (this.interpOpt) {
            this.fout.println();
            this.fout.println("Interpolated data (cubic spline)");
            this.fout.println();
            this.fout.println("Number of interpolated points: " + this.nInterpPoints);
            this.fout.println();
            this.fout.printtab("X-value");
            this.fout.println("Y-value");
            for (i = 0; i < this.nInterpPoints; ++i) {
                this.fout.printtab(Fmath.truncate(this.xInterp[i], this.trunc));
                this.fout.println(Fmath.truncate(this.yInterp[i], this.trunc));
            }
        }
        this.fout.close();
    }

    private void checkForRotation() {
        double tangent = (this.highYaxisXpixel - this.lowYaxisXpixel) / (this.highYaxisYpixel - this.lowYaxisYpixel);
        this.angleYaxis = Math.toDegrees(Math.atan(tangent));
        tangent = (this.lowXaxisYpixel - this.highXaxisYpixel) / (this.highXaxisXpixel - this.lowXaxisXpixel);
        this.angleXaxis = Math.toDegrees(Math.atan(tangent));
        this.angleMean = (this.angleXaxis + this.angleYaxis) / 2.0;
        double absMean = Math.abs(this.angleMean);
        if (absMean != 0.0 && absMean > this.angleTolerance) {
            this.performRotation();
        }
    }

    private void performRotation() {
        double tangentX = (this.highXaxisYpixel - this.lowXaxisYpixel) / (this.highXaxisXpixel - this.lowXaxisXpixel);
        double interceptX = this.highXaxisYpixel - tangentX * this.highXaxisXpixel;
        double tangentY = (this.highYaxisYpixel - this.lowYaxisYpixel) / (this.highYaxisXpixel - this.lowYaxisXpixel);
        double interceptY = this.highYaxisYpixel - tangentY * this.highYaxisXpixel;
        double originX = (interceptX - interceptY) / (tangentY - tangentX);
        double originY = tangentY * originX + interceptY;
        double angleMeanRad = Math.toRadians(this.angleMean);
        double cosphi = Math.cos(-angleMeanRad);
        double sinphi = Math.sin(-angleMeanRad);
        double highXaxisXpixelR = (this.highXaxisXpixel - originX) * cosphi + (this.highXaxisYpixel - originY) * sinphi + originX;
        double highXaxisYpixelR = -(this.highXaxisXpixel - originX) * sinphi + (this.highXaxisYpixel - originY) * cosphi + originY;
        double lowXaxisXpixelR = (this.lowXaxisXpixel - originX) * cosphi + (this.lowXaxisYpixel - originY) * sinphi + originX;
        double lowXaxisYpixelR = -(this.lowXaxisXpixel - originX) * sinphi + (this.lowXaxisYpixel - originY) * cosphi + originY;
        double highYaxisXpixelR = (this.highYaxisXpixel - originX) * cosphi + (this.highYaxisYpixel - originY) * sinphi + originX;
        double highYaxisYpixelR = -(this.highYaxisXpixel - originX) * sinphi + (this.highYaxisYpixel - originY) * cosphi + originY;
        double lowYaxisXpixelR = -(this.lowYaxisXpixel - originX) * cosphi + (this.lowYaxisYpixel - originY) * sinphi + originX;
        double lowYaxisYpixelR = (this.lowYaxisXpixel - originX) * sinphi + (this.lowYaxisYpixel - originY) * cosphi + originY;
        this.highXaxisXpixel = highXaxisXpixelR;
        this.highXaxisYpixel = highXaxisYpixelR;
        this.lowXaxisXpixel = lowXaxisXpixelR;
        this.lowXaxisYpixel = lowXaxisYpixelR;
        this.highYaxisXpixel = highYaxisXpixelR;
        this.highYaxisYpixel = highYaxisYpixelR;
        this.lowYaxisXpixel = lowYaxisXpixelR;
        this.lowYaxisYpixel = lowYaxisYpixelR;
        for (int i = 0; i < this.nData; ++i) {
            double xx = (this.xPosPixel[i] - originX) * cosphi + (this.yPosPixel[i] - originY) * sinphi + originX;
            double yy = -(this.xPosPixel[i] - originX) * sinphi + (this.yPosPixel[i] - originY) * cosphi + originY;
            this.xPosPixel[i] = xx;
            this.yPosPixel[i] = yy;
        }
        this.rotationDone = true;
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.mouseEntered = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.mouseEntered = false;
        this.repaint();
    }

    private void interpolation() {
        this.xInterp = new double[this.nInterpPoints];
        this.yInterp = new double[this.nInterpPoints];
        double incr = (this.xPositions[this.nData - 1] - this.xPositions[0]) / (double)(this.nInterpPoints - 1);
        this.xInterp[0] = this.xPositions[0];
        for (int i = 1; i < this.nInterpPoints - 1; ++i) {
            this.xInterp[i] = this.xInterp[i - 1] + incr;
        }
        this.xInterp[this.nInterpPoints - 1] = this.xPositions[this.nData - 1];
        CubicSpline cs = new CubicSpline(this.xPositions, this.yPositions);
        for (int i = 0; i < this.nInterpPoints; ++i) {
            this.yInterp[i] = cs.interpolate(this.xInterp[i]);
        }
        if (this.plotOpt) {
            int nMax = Math.max(this.nInterpPoints, this.nData);
            double[][] plotData = PlotGraph.data(2, nMax);
            plotData[0] = this.xPositions;
            plotData[1] = this.yPositions;
            plotData[2] = this.xInterp;
            plotData[3] = this.yInterp;
            PlotGraph pg = new PlotGraph(plotData);
            pg.setGraphTitle("Cubic Spline Interpolation of Digitised Points");
            pg.setGraphTitle2(this.imagePath);
            pg.setXaxisLegend("x");
            pg.setYaxisLegend("y");
            int[] lineOpt = new int[]{0, 3};
            pg.setLine(lineOpt);
            int[] pointOpt = new int[]{4, 0};
            pg.setPoint(pointOpt);
            pg.plot();
        }
    }

    public void checkForIdenticalPoints() {
        int i;
        int nP = this.nData;
        boolean test1 = true;
        int ii = 0;
        while (test1) {
            boolean test2 = true;
            int jj = ii + 1;
            while (test2) {
                System.out.println("ii " + ii + "  jj  " + jj);
                if (this.xPositions[ii] == this.xPositions[jj] && this.yPositions[ii] == this.yPositions[jj]) {
                    System.out.print("Class DigiGraph: two identical points, " + this.xPositions[ii] + ", " + this.yPositions[ii]);
                    System.out.println(", in data array at indices " + ii + " and " + jj + ", one point removed");
                    for (i = jj; i < nP; ++i) {
                        this.xPositions[i - 1] = this.xPositions[i];
                        this.yPositions[i - 1] = this.yPositions[i];
                    }
                    if (--nP - 1 != ii) continue;
                    test2 = false;
                    continue;
                }
                if (++jj < nP) continue;
                test2 = false;
            }
            if (++ii < nP - 1) continue;
            test1 = false;
        }
        if (nP != this.nData) {
            double[] holdX = new double[nP];
            double[] holdY = new double[nP];
            for (i = 0; i < nP; ++i) {
                holdX[i] = this.xPositions[i];
                holdY[i] = this.yPositions[i];
            }
            this.xPositions = holdX;
            this.yPositions = holdY;
            this.nData = nP;
        }
    }

    private void plotDigitisedPoints() {
        double[][] plotData = PlotGraph.data(1, this.nData);
        plotData[0] = this.xPositions;
        plotData[1] = this.yPositions;
        PlotGraph pg = new PlotGraph(plotData);
        pg.setGraphTitle("Plot of the Digitised Points");
        pg.setGraphTitle2(this.imagePath);
        pg.setXaxisLegend("x");
        pg.setYaxisLegend("y");
        int[] lineOpt = new int[]{0};
        pg.setLine(lineOpt);
        int[] pointOpt = new int[]{4};
        pg.setPoint(pointOpt);
        pg.plot();
    }
}

