/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.BiCubicSplinePartialDerivative;
import flanagan.interpolation.CubicSpline;
import flanagan.math.Fmath;

public class BiCubicSplineFirstDerivative {
    private int nPoints = 0;
    private int mPoints = 0;
    private double[][] y = null;
    private double[][] yTranspose = null;
    private double[] x1 = null;
    private double[] x2 = null;
    private double[] xMin = new double[2];
    private double[] xMax = new double[2];
    private BiCubicSplinePartialDerivative cspdY = null;
    private BiCubicSplinePartialDerivative cspdYt = null;
    private boolean averageIdenticalAbscissae = false;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = true;

    public BiCubicSplineFirstDerivative(double[] x1, double[] x2, double[][] y) {
        int j;
        int i;
        this.nPoints = x1.length;
        this.mPoints = x2.length;
        if (this.nPoints != y.length) {
            throw new IllegalArgumentException("Arrays x1 and y-row are of different length " + this.nPoints + " " + y.length);
        }
        if (this.mPoints != y[0].length) {
            throw new IllegalArgumentException("Arrays x2 and y-column are of different length " + this.mPoints + " " + y[0].length);
        }
        if (this.nPoints < 3 || this.mPoints < 3) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of 3 X 3");
        }
        this.x1 = new double[this.nPoints];
        this.x2 = new double[this.mPoints];
        this.y = new double[this.nPoints][this.mPoints];
        this.yTranspose = new double[this.mPoints][this.nPoints];
        for (i = 0; i < this.nPoints; ++i) {
            this.x1[i] = x1[i];
        }
        this.xMin[0] = Fmath.minimum(this.x1);
        this.xMax[0] = Fmath.maximum(this.x1);
        for (int j2 = 0; j2 < this.mPoints; ++j2) {
            this.x2[j2] = x2[j2];
        }
        this.xMin[1] = Fmath.minimum(this.x2);
        this.xMax[1] = Fmath.maximum(this.x2);
        for (i = 0; i < this.nPoints; ++i) {
            for (j = 0; j < this.mPoints; ++j) {
                this.y[i][j] = y[i][j];
            }
        }
        for (i = 0; i < this.nPoints; ++i) {
            for (j = 0; j < this.mPoints; ++j) {
                this.yTranspose[j][i] = this.y[i][j];
            }
        }
        this.cspdY = new BiCubicSplinePartialDerivative(x1, x2, y);
        this.cspdYt = new BiCubicSplinePartialDerivative(x2, x1, this.yTranspose);
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        CubicSpline.noRoundingErrorCheck();
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        BiCubicSplineFirstDerivative.potentialRoundingError = potentialRoundingError;
        CubicSpline.potentialRoundingError(potentialRoundingError);
    }

    public void averageIdenticalAbscissae() {
        this.averageIdenticalAbscissae = true;
        this.cspdY.averageIdenticalAbscissae();
        this.cspdYt.averageIdenticalAbscissae();
    }

    public double[] getXmin() {
        return this.xMin;
    }

    public double[] getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin[0], this.xMax[0], this.xMin[1], this.xMax[1]};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        for (int i = 0; i < 2; ++i) {
            System.out.println("The limits to the x array " + i + " are " + this.xMin[i] + " and " + this.xMax[i]);
        }
        System.out.println(" ");
    }

    public double[] interpolate(double xx1, double xx2) {
        double[] interpY = this.cspdY.interpolate(xx1, xx2);
        double[] interpYt = this.cspdYt.interpolate(xx2, xx1);
        double averageY = (interpY[0] + interpYt[0]) / 2.0;
        double[] ret = new double[]{averageY, interpY[1], interpYt[1], interpY[0], interpYt[0]};
        return ret;
    }
}

