/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.Cronbach;
import flanagan.analysis.PCA;
import flanagan.analysis.Scores;
import flanagan.analysis.Stat;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class RankAnalysis {
    private double[][] values = null;
    private double[][] errors = null;
    private double[] valuesDiagonal = null;
    private double[] errorsDiagonal = null;
    private double[][] reducedValues = null;
    private double[][] reducedErrors = null;
    private double[] reducedValuesDiagonal = null;
    private double[] reducedErrorsDiagonal = null;
    private double[] reducedValueOverError = null;
    private double[] probabilityValues = null;
    private double[] mcMullen = null;
    private int numberOfRows = 0;
    private int numberOfColumns = 0;
    private int diagonalLength = 0;
    private int errorType = 3;
    private double[] errorRowMeans = null;
    private double[] errorColumnMeans = null;
    private int numberOfMissingErrors = 0;
    private boolean rowOption = true;
    private boolean rankAnalysisDone = false;

    public RankAnalysis(double[][] values, double[][] errors) {
        this.values = Conv.copy(values);
        this.errors = Conv.copy(errors);
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] values, float[][] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] values, long[][] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] values, int[][] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] values, BigDecimal[][] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] values, BigInteger[][] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] values, ArrayMaths[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] values, ArrayList<Object>[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] values, Vector<Object>[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        Matrix mate = new Matrix(errors);
        this.errors = mate.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(Matrix values, Matrix errors) {
        this.values = values.getArrayCopy();
        this.errors = errors.getArrayCopy();
        this.errorType = 0;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] values, double[] errors) {
        this.values = Conv.copy(values);
        this.errors = this.oneToTwo(Conv.copy(errors), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(float[][] values, float[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(long[][] values, long[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(int[][] values, int[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigDecimal[][] values, BigDecimal[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(BigInteger[][] values, BigInteger[] errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayMaths[] values, ArrayMaths errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errors = this.oneToTwo(errors.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(ArrayList<Object>[] values, ArrayList<Object> errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Vector<Object>[] values, Vector<Object> errors) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Scores values) {
        this.values = values.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(Cronbach values) {
        this.values = values.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(PCA values) {
        this.values = values.usedScoresAsRowPerItem();
        Matrix mat = new Matrix(this.values);
        double[] errors = mat.rowStandardDeviations();
        ArrayMaths ame = new ArrayMaths(errors);
        this.errors = this.oneToTwo(ame.array(), this.values[0].length);
        this.errorType = 1;
        this.preprocessDataOne();
    }

    public RankAnalysis(double[][] values, double commonError) {
        this.values = Conv.copy(values);
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(float[][] values, float commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(long[][] values, long commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(int[][] values, int commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(BigDecimal[][] values, BigDecimal commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError.doubleValue());
    }

    public RankAnalysis(BigInteger[][] values, BigInteger commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError.doubleValue());
    }

    public RankAnalysis(ArrayMaths[] values, double commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(ArrayList<Object>[] values, double commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(Vector<Object>[] values, double commonError) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(Matrix values, double commonError) {
        this.values = values.getArrayCopy();
        this.errorType = 2;
        this.preprocessDataTwo(commonError);
    }

    public RankAnalysis(double[][] values) {
        this.values = Conv.copy(values);
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(float[][] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(long[][] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(int[][] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigDecimal[][] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(BigInteger[][] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayMaths[] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(ArrayList<Object>[] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Vector<Object>[] values) {
        Matrix matv = new Matrix(values);
        this.values = matv.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    public RankAnalysis(Matrix values) {
        this.values = values.getArrayCopy();
        this.errorType = 3;
        this.preprocessDataThree();
    }

    private double[][] oneToTwo(double[] errors, int nCols) {
        int nRows = errors.length;
        double[][] ret = new double[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                ret[i][j] = errors[i];
            }
        }
        return ret;
    }

    private void preprocessDataOne() {
        int i;
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (this.values[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        for (i = 0; i < this.numberOfRows; ++i) {
            if (this.errors[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the error matrix must be of the same length as those of the value matrix");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                double[] dArray = this.errors[i];
                int n = j;
                dArray[n] = dArray[n] * this.errors[i][j];
            }
        }
    }

    private void preprocessDataTwo(double commonError) {
        int i;
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (i = 1; i < this.numberOfRows; ++i) {
            if (this.values[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        for (i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.errors[i][j] = commonError * commonError;
            }
        }
    }

    private void preprocessDataThree() {
        this.numberOfRows = this.values.length;
        this.numberOfColumns = this.values[0].length;
        for (int i = 1; i < this.numberOfRows; ++i) {
            if (this.values[i].length == this.numberOfColumns) continue;
            throw new IllegalArgumentException("All rows of the value matrix must be of the same length");
        }
        this.diagonalLength = this.numberOfRows;
        if (this.numberOfRows > this.numberOfColumns) {
            this.diagonalLength = this.numberOfColumns;
        }
        this.errors = new double[this.numberOfRows][this.numberOfColumns];
        double error = 0.0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                error = Math.pow(10.0, Math.floor(Math.log10(Math.abs(this.values[i][j])))) * 5.0E-16;
                this.errors[i][j] = error * error;
            }
        }
    }

    public void useErrorRowMean() {
        this.rowOption = true;
    }

    public void useErrorColumnMean() {
        this.rowOption = false;
    }

    public int nMissingErrors() {
        return this.numberOfMissingErrors;
    }

    private void rankAnalysis() {
        int j;
        int i;
        int j2;
        int counter;
        this.errorRowMeans = new double[this.numberOfRows];
        this.errorColumnMeans = new double[this.numberOfColumns];
        this.numberOfMissingErrors = 0;
        int i2 = 0;
        while (i2 < this.numberOfRows) {
            counter = 0;
            for (j2 = 0; j2 < this.numberOfColumns; ++j2) {
                if (!Double.isNaN(this.errors[i2][j2])) {
                    if (this.errors[i2][j2] < 0.0) {
                        double[] dArray = this.errors[i2];
                        int n = j2;
                        dArray[n] = dArray[n] * -1.0;
                    }
                    int n = i2;
                    this.errorRowMeans[n] = this.errorRowMeans[n] + this.errors[i2][j2];
                    ++counter;
                    continue;
                }
                ++this.numberOfMissingErrors;
            }
            int n = i2++;
            this.errorRowMeans[n] = this.errorRowMeans[n] / (double)counter;
        }
        i2 = 0;
        while (i2 < this.numberOfColumns) {
            counter = 0;
            for (j2 = 0; j2 < this.numberOfRows; ++j2) {
                if (Double.isNaN(this.errors[j2][i2])) continue;
                int n = i2;
                this.errorColumnMeans[n] = this.errorColumnMeans[n] + this.errors[j2][i2];
                ++counter;
            }
            int n = i2++;
            this.errorColumnMeans[n] = this.errorColumnMeans[n] / (double)counter;
        }
        if (this.numberOfMissingErrors > 0) {
            for (i2 = 0; i2 < this.numberOfRows; ++i2) {
                for (int j3 = 0; j3 < this.numberOfColumns; ++j3) {
                    if (!Double.isNaN(this.errors[i2][j3])) continue;
                    this.errors[i2][j3] = this.rowOption ? this.errorRowMeans[i2] : this.errorColumnMeans[i2];
                }
            }
        }
        this.reducedValues = this.values;
        this.reducedErrors = this.errors;
        Matrix matv0 = new Matrix(this.reducedValues);
        Matrix mate0 = new Matrix(this.reducedErrors);
        int nn = this.diagonalLength - 1;
        for (i = 0; i < nn; ++i) {
            matv0 = new Matrix(this.reducedValues);
            int nrow = this.numberOfRows - i;
            int ncol = this.numberOfColumns - i;
            Matrix mat1 = matv0.getSubMatrix(i, i, this.numberOfRows - 1, this.numberOfColumns - 1);
            double[][] subv = mat1.getArrayCopy();
            int[] max = mat1.pivot();
            int pivotI = max[0] + i;
            int pivotJ = max[1] + i;
            double[] holdv1 = this.reducedValues[i];
            double[] holde1 = this.reducedErrors[i];
            this.reducedValues[i] = this.reducedValues[pivotI];
            this.reducedErrors[i] = this.reducedErrors[pivotI];
            this.reducedValues[pivotI] = holdv1;
            this.reducedErrors[pivotI] = holde1;
            double holdv2 = 0.0;
            double holde2 = 0.0;
            for (int j4 = 0; j4 < this.numberOfRows; ++j4) {
                holdv2 = this.reducedValues[j4][i];
                holde2 = this.reducedErrors[j4][i];
                this.reducedValues[j4][i] = this.reducedValues[j4][pivotJ];
                this.reducedErrors[j4][i] = this.reducedErrors[j4][pivotJ];
                this.reducedValues[j4][pivotJ] = holdv2;
                this.reducedErrors[j4][pivotJ] = holde2;
            }
            Matrix matValueHold = new Matrix(this.reducedValues);
            Matrix matErrorHold = new Matrix(this.reducedErrors);
            double[][] valueHold = matValueHold.getArrayCopy();
            double[][] errorHold = matErrorHold.getArrayCopy();
            for (int j5 = i + 1; j5 < this.numberOfRows; ++j5) {
                for (int k = i; k < this.numberOfColumns; ++k) {
                    double ratio1 = 1.0;
                    if (this.reducedValues[j5][i] != this.reducedValues[i][i]) {
                        ratio1 = this.reducedValues[j5][i] / this.reducedValues[i][i];
                    }
                    valueHold[j5][k] = this.reducedValues[j5][k] - ratio1 * this.reducedValues[i][k];
                    double hold = this.reducedErrors[j5][k] + this.reducedErrors[i][k] * ratio1 * ratio1;
                    double ratio2 = 1.0;
                    if (this.reducedValues[i][k] != this.reducedValues[i][i]) {
                        ratio2 = this.reducedValues[i][k] / this.reducedValues[i][i];
                    }
                    errorHold[j5][k] = (hold += this.reducedErrors[j5][i] * ratio2 * ratio2) + this.reducedErrors[i][i] * ratio1 * ratio1 * ratio2 * ratio2;
                }
            }
            matValueHold = new Matrix(valueHold);
            matErrorHold = new Matrix(errorHold);
            this.reducedValues = matValueHold.getArrayCopy();
            this.reducedErrors = matErrorHold.getArrayCopy();
        }
        for (i = 0; i < this.numberOfRows; ++i) {
            for (j = 0; j < this.numberOfColumns; ++j) {
                this.reducedErrors[i][j] = Math.sqrt(this.reducedErrors[i][j]);
            }
        }
        for (i = 1; i < this.diagonalLength; ++i) {
            for (j = 0; j < i; ++j) {
                this.reducedValues[i][j] = 0.0;
                this.reducedErrors[i][j] = 0.0;
            }
        }
        if (this.diagonalLength < this.numberOfRows) {
            for (i = this.diagonalLength; i < this.numberOfRows; ++i) {
                for (j = 0; j < this.numberOfColumns; ++j) {
                    this.reducedValues[i][j] = 0.0;
                    this.reducedErrors[i][j] = 0.0;
                }
            }
        }
        this.reducedValuesDiagonal = new double[this.diagonalLength];
        this.reducedErrorsDiagonal = new double[this.diagonalLength];
        this.reducedValueOverError = new double[this.diagonalLength];
        this.probabilityValues = new double[this.diagonalLength];
        this.mcMullen = new double[this.numberOfRows];
        for (i = 0; i < this.diagonalLength; ++i) {
            this.reducedValuesDiagonal[i] = this.reducedValues[i][i];
            this.reducedErrorsDiagonal[i] = this.reducedErrors[i][i];
            this.reducedValueOverError[i] = Math.abs(this.reducedValuesDiagonal[i] / this.reducedErrorsDiagonal[i]);
            this.probabilityValues[i] = 1.0 - Stat.gaussianCDF(0.0, 1.0, -this.reducedValueOverError[i], this.reducedValueOverError[i]);
        }
        for (i = 0; i < this.numberOfRows; ++i) {
            double sum = 0.0;
            for (int j6 = i; j6 < this.numberOfColumns; ++j6) {
                sum += this.reducedValues[i][j6] * this.reducedValues[i][j6];
            }
            this.mcMullen[i] = Math.sqrt(sum) / (double)(this.numberOfColumns - i);
        }
        this.rankAnalysisDone = true;
    }

    public void analysis() {
        this.analysis("RankAnalysisOutput.txt");
    }

    public void analysis(String fileName) {
        int posdot;
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        if ((posdot = fileName.indexOf(".")) == -1) {
            fileName = fileName + ".txt";
        }
        FileOutput fout = new FileOutput(fileName);
        fout.println("Rank Analysis");
        fout.println("File name:   " + fileName);
        Date d = new Date();
        String day = DateFormat.getDateInstance().format(d);
        String tim = DateFormat.getTimeInstance().format(d);
        fout.println("Program executed at " + tim + " on " + day);
        fout.println();
        fout.println("Number of rows    " + this.numberOfRows);
        fout.println("Number of columns " + this.numberOfColumns);
        if (this.numberOfMissingErrors > 0) {
            fout.println("Number of substituted missing errors" + this.numberOfMissingErrors);
            if (this.rowOption) {
                fout.println("Row means used as the substituted value/s");
            } else {
                fout.println("Column means used as the substituted value/s");
            }
        }
        fout.println();
        switch (this.errorType) {
            case 0: {
                fout.println("Matrix of individual errors supplied");
                break;
            }
            case 1: {
                fout.println("Common error for all elements in each each row supplied");
                break;
            }
            case 2: {
                fout.println("Single common error for all elements in the matrix supplied");
                break;
            }
            case 3: {
                fout.println("No errors supplied - estimate of the rounding errors used");
            }
        }
        fout.println();
        int field1 = 30;
        int field2 = 15;
        int trunc = 4;
        if (this.errorType != 3) {
            fout.print("Reduced", field2);
            fout.print("Reduced", field2);
            fout.print("V/E Ratio", field2);
            fout.print("P-value", field2);
            fout.println("McMullen");
            fout.print("Value", field2);
            fout.print("Error", field2);
            fout.print("    ", field2);
            fout.print("    ", field2);
            fout.println("rms");
            fout.print("Diagonal (V)", field2);
            fout.print("Diagonal (E)", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
        } else {
            fout.print("Reduced", field2);
            fout.print("Reduced", field2);
            fout.print("V/E Ratio", field2);
            fout.print("P-value", field2);
            fout.println("McMullen");
            fout.print("Value", field2);
            fout.print("Estimated", field2);
            fout.print("    ", field2);
            fout.print("    ", field2);
            fout.println("rms");
            fout.print("Diagonal (V)", field2);
            fout.print("Rounding", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
            fout.print("   ", field2);
            fout.print("Error (E)", field2);
            fout.print("   ", field2);
            fout.print("   ", field2);
            fout.println("   ");
        }
        for (int i = 0; i < this.diagonalLength; ++i) {
            fout.print(Fmath.truncate(this.reducedValuesDiagonal[i], trunc), field2);
            fout.print(Fmath.truncate(this.reducedErrorsDiagonal[i], trunc), field2);
            fout.print(Fmath.truncate(this.reducedValueOverError[i], trunc), field2);
            fout.print(Fmath.truncate(this.probabilityValues[i], trunc), field2);
            fout.println(Fmath.truncate(this.mcMullen[i], trunc));
        }
        System.out.println("Analysis written to text file " + fileName);
        fout.close();
    }

    public double[][] originalValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.values;
    }

    public double[][] originalErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.errors;
    }

    public double[][] reducedValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValues;
    }

    public double[][] reducedErrors() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrors;
    }

    public double[] reducedValuesDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValuesDiagonal;
    }

    public double[] reducedErrorsDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedErrorsDiagonal;
    }

    public double[] reducedRatiosDiagonal() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.reducedValueOverError;
    }

    public double[] probabilityValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.probabilityValues;
    }

    public double[] mcMullenValues() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.mcMullen;
    }

    public int nRows() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfRows;
    }

    public int nColumns() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.numberOfColumns;
    }

    public int nDiagonalElements() {
        if (!this.rankAnalysisDone) {
            this.rankAnalysis();
        }
        return this.diagonalLength;
    }
}

