/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaNSequence;
import ca.mcgill.mcb.pcingola.binseq.coder.DnaCoder;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesDnaNSequence
extends TestCase {
    public static boolean verbose = false;

    String change(String sequence, int numChanges, Random rand) {
        HashSet<Integer> changedPos = new HashSet<Integer>();
        char[] chars = sequence.toCharArray();
        int i = 0;
        while (i < numChanges) {
            char newBase;
            int pos = rand.nextInt(chars.length);
            if (changedPos.contains(pos) || chars[pos] == (newBase = this.randBase(rand))) continue;
            chars[pos] = newBase;
            changedPos.add(pos);
            ++i;
        }
        return new String(chars);
    }

    char randBase(Random rand) {
        int r = rand.nextInt(5);
        if (r < 4) {
            return DnaCoder.get().toBase(r);
        }
        return 'N';
    }

    public void randDnaSeqGetBasesTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq = this.randSeq(len, rand);
            DnaNSequence bseq = new DnaNSequence(seq);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                int randLen = rand.nextInt(len - randPos);
                String basesOri = seq.substring(randPos, randPos + randLen);
                String basesBin = bseq.getBases(randPos, randLen);
                Assert.assertEquals((String)basesOri, (String)basesBin);
                if (!verbose) continue;
                System.out.println("randDnaSeqGetBasesTest:\tPos: " + randPos + "\t" + "Len: " + randLen + "\t'" + basesOri + "'\t=\t'" + basesBin + "'");
            }
        }
    }

    public void randDnaSeqGetBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaNSequence test:" + t + "\tlen:" + len + "\t" + seq);
            }
            DnaNSequence bseq = new DnaNSequence(seq);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                char baseOri = seq.charAt(randPos);
                char baseBin = bseq.getBase(randPos);
                Assert.assertEquals((char)baseOri, (char)baseBin);
            }
        }
    }

    public void randDnaSeqTest(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaNSequence test:" + t + "\tlen:" + len + "\t" + seq);
            }
            DnaNSequence bseq = new DnaNSequence(seq);
            Assert.assertEquals((String)seq, (String)bseq.toString());
        }
    }

    public void randReplaceBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq = this.randSeq(len, rand);
            DnaNSequence bseq = new DnaNSequence(seq);
            if (verbose) {
                System.out.println("randReplaceBaseTest\nOri    :\t" + seq);
            }
            for (int i = 0; i < numTestsPerSeq; ++i) {
                char baseOri;
                int randPos = rand.nextInt(len);
                char randBase = baseOri = seq.charAt(randPos);
                while (randBase == baseOri) {
                    randBase = this.randBase(rand);
                }
                char[] seqChars = seq.toCharArray();
                seqChars[randPos] = randBase;
                seq = new String(seqChars);
                bseq.setBase(randPos, randBase);
                if (verbose) {
                    System.out.println("Changed:\t" + seq + "\tpos: " + randPos + "\trandbase: " + randBase + "\n\t\t" + bseq);
                }
                Assert.assertEquals((String)seq, (String)bseq.toString());
            }
        }
    }

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(this.randBase(rand));
        }
        return sb.toString();
    }

    public void test_01_short() {
        long seed = 20100615L;
        int lenMask = 255;
        int numTests = 1000;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    public void test_01_short_getBase() {
        long seed = 20110217L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_01_short_getBases() {
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_01_short_replaceBase() {
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long() {
        long seed = 20100614L;
        int lenMask = 65535;
        int numTests = 10;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    public void test_02_long_getBase() {
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long_getBases() {
        long seed = 20110218L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_02_long_replaceBase() {
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    public void test_13_reverseWc() {
        long seed = 20100615L;
        int lenMask = 4095;
        int numTests = 1000;
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            int len = (rand.nextInt() & lenMask) + 10;
            String seq = this.randSeq(len, rand);
            String seqRwc = GprSeq.reverseWc(seq);
            DnaNSequence bseq = new DnaNSequence(seq);
            DnaNSequence rwc = (DnaNSequence)bseq.reverseWc();
            TestCasesDnaNSequence.assertEquals((String)seqRwc.toUpperCase(), (String)rwc.getSequence().toUpperCase());
        }
    }
}

