/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.RegulationConsensusMultipleBed;
import ca.mcgill.mcb.pcingola.RegulationFileConsensus;
import ca.mcgill.mcb.pcingola.codons.FindRareAaIntervals;
import ca.mcgill.mcb.pcingola.fileIterator.RegulationGffFileIterator;
import ca.mcgill.mcb.pcingola.interval.ExonSpliceCaracterizer;
import ca.mcgill.mcb.pcingola.interval.RareAminoAcid;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdCds;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEffCmdProtein;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactory;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryEmbl;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGenBank;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGenesFile;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff2;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGff3;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryKnownGene;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.File;
import java.util.Collection;

public class SnpEffCmdBuild
extends SnpEff {
    public static boolean debug = false;
    SnpEff.GeneDatabaseFormat geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GTF22;
    boolean onlyRegulation = false;
    String cellType = null;

    void checkDb() {
        System.out.print("CDS check:\n\t");
        String cdsFile = this.config.getFileNameCds();
        if (Gpr.canRead(cdsFile)) {
            SnpEffCmdCds snpEffCmdCds = new SnpEffCmdCds(this.config);
            snpEffCmdCds.setVerbose(this.verbose);
            snpEffCmdCds.run();
        } else {
            System.out.println("\tOptional file '" + cdsFile + "' not found, nothing done.");
        }
        System.out.print("Protein check:\n\t");
        String protFile = this.config.getFileNameProteins();
        if (Gpr.canRead(protFile)) {
            SnpEffCmdProtein snpEffCmdProtein = new SnpEffCmdProtein(this.config);
            snpEffCmdProtein.setVerbose(this.verbose);
            snpEffCmdProtein.run();
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            SnpEffCmdProtein snpEffCmdProtein = new SnpEffCmdProtein(this.config, this.config.getBaseFileNameGenes() + ".gb");
            snpEffCmdProtein.setVerbose(this.verbose);
            snpEffCmdProtein.run();
        } else {
            System.out.println("\tOptional file '" + protFile + "' not found, nothing done.");
        }
    }

    SnpEffectPredictor createSnpEffPredictor() {
        SnpEffPredictorFactory factory = null;
        if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GTF22) {
            factory = new SnpEffPredictorFactoryGtf22(this.config, this.inOffset);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF3) {
            factory = new SnpEffPredictorFactoryGff3(this.config, this.inOffset);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GFF2) {
            factory = new SnpEffPredictorFactoryGff2(this.config, this.inOffset);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.REFSEQ) {
            factory = new SnpEffPredictorFactoryRefSeq(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.KNOWN_GENES) {
            factory = new SnpEffPredictorFactoryKnownGene(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.GENBANK) {
            factory = new SnpEffPredictorFactoryGenBank(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.EMBL) {
            factory = new SnpEffPredictorFactoryEmbl(this.config);
        } else if (this.geneDatabaseFormat == SnpEff.GeneDatabaseFormat.BIOMART) {
            factory = new SnpEffPredictorFactoryGenesFile(this.config, this.inOffset);
        } else {
            throw new RuntimeException("Unimplemented format " + (Object)((Object)this.geneDatabaseFormat));
        }
        factory.setVerbose(this.verbose);
        return ((SnpEffPredictorFactory)factory).create();
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("-c") || args[i].equalsIgnoreCase("-config")) {
                    if (i + 1 < args.length) {
                        this.configFile = args[++i];
                        continue;
                    }
                    this.usage("Option '-c' without config file argument");
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gff3")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF3;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gff2")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GFF2;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equals("-gtf22")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GTF22;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equals("-refseq")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.REFSEQ;
                    this.outOffset = 0;
                    this.inOffset = 0;
                    continue;
                }
                if (args[i].equals("-genbank")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.GENBANK;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equals("-knowngenes")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.KNOWN_GENES;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equals("-embl")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.EMBL;
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-txt")) {
                    this.geneDatabaseFormat = SnpEff.GeneDatabaseFormat.BIOMART;
                    continue;
                }
                if (args[i].equals("-v") || args[i].equalsIgnoreCase("-verbose")) {
                    this.verbose = true;
                    this.quiet = false;
                    continue;
                }
                if (args[i].equals("-onlyReg")) {
                    this.onlyRegulation = true;
                    continue;
                }
                if (args[i].equals("-cellType")) {
                    if (i + 1 >= args.length) continue;
                    this.cellType = args[++i];
                    continue;
                }
                if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                    this.quiet = true;
                    this.verbose = false;
                    continue;
                }
                if (args[i].equals("-if") || args[i].equalsIgnoreCase("-inOffset")) {
                    if (i + 1 >= args.length) continue;
                    this.inOffset = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                if (args[i].equals("-of") || args[i].equalsIgnoreCase("-outOffset")) {
                    if (i + 1 >= args.length) continue;
                    this.outOffset = Gpr.parseIntSafe(args[++i]);
                    continue;
                }
                if (args[i].equals("-1")) {
                    this.outOffset = 1;
                    this.inOffset = 1;
                    continue;
                }
                if (args[i].equals("-0")) {
                    this.outOffset = 0;
                    this.inOffset = 0;
                    continue;
                }
                if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    System.exit(0);
                    continue;
                }
                this.usage("Unknow option '" + args[i] + "'");
                continue;
            }
            if (this.genomeVer.length() <= 0) {
                this.genomeVer = args[i];
                continue;
            }
            this.usage("Unknow parameter '" + args[i] + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
    }

    void rareAa(SnpEffectPredictor snpEffectPredictor) {
        block7: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Rare amino acid annotations");
            }
            String proteinsFile = this.config.getFileNameProteins();
            try {
                FindRareAaIntervals findRare = new FindRareAaIntervals(snpEffectPredictor.getGenome());
                findRare.setVerbose(this.verbose);
                Collection<RareAminoAcid> raas = findRare.findRareAa(proteinsFile);
                for (RareAminoAcid raa : raas) {
                    if (this.verbose) {
                        System.err.println("\tAdding: " + raa);
                    }
                    snpEffectPredictor.add(raa);
                }
                if (this.verbose) {
                    Timer.showStdErr("Done.");
                }
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional protein sequence file '" + proteinsFile + "', nothing done.");
                }
                if (!debug) break block7;
                t.printStackTrace();
            }
        }
    }

    void readRegulationBed() {
        if (this.verbose) {
            Timer.showStdErr("[Optional] Reading regulation elements: BED ");
        }
        String inDir = this.config.getDirRegulationBed();
        String outDir = this.config.getDirDataVersion();
        File dir = new File(inDir);
        if (!dir.exists() || !dir.isDirectory()) {
            if (this.verbose) {
                Timer.showStdErr("Cannot find optional regulation dir '" + inDir + "', nothing done.");
            }
            return;
        }
        RegulationConsensusMultipleBed regBeds = new RegulationConsensusMultipleBed(inDir, outDir);
        regBeds.setVerbose(this.verbose);
        regBeds.setCellType(this.cellType);
        regBeds.run();
    }

    void readRegulationGff() {
        block5: {
            if (this.verbose) {
                Timer.showStdErr("[Optional] Reading regulation elements: GFF");
            }
            String regulationFileName = this.config.getBaseFileNameRegulation() + ".gff";
            try {
                RegulationGffFileIterator regulationFileIterator = new RegulationGffFileIterator(regulationFileName);
                RegulationFileConsensus regulationGffConsensus = new RegulationFileConsensus(this.verbose);
                regulationGffConsensus.readFile(regulationFileIterator);
                regulationGffConsensus.save(this.config.getDirDataVersion());
                if (this.verbose) {
                    Timer.showStdErr("Done.");
                }
            }
            catch (Throwable t) {
                if (this.verbose) {
                    Timer.showStdErr("Warning: Cannot read optional regulation file '" + regulationFileName + "', nothing done.");
                }
                if (!debug) break block5;
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Building database for '" + this.genomeVer + "'");
        }
        this.config = new Config(this.genomeVer, this.configFile);
        if (!this.onlyRegulation) {
            SnpEffectPredictor snpEffectPredictor = this.createSnpEffPredictor();
            this.config.setSnpEffectPredictor(snpEffectPredictor);
            ExonSpliceCaracterizer exonSpliceCaracterizer = new ExonSpliceCaracterizer(snpEffectPredictor.getGenome());
            exonSpliceCaracterizer.setVerbose(this.verbose);
            exonSpliceCaracterizer.caracterize();
            this.rareAa(snpEffectPredictor);
            if (this.verbose) {
                Timer.showStdErr("Saving database");
            }
            snpEffectPredictor.save(this.config);
            this.checkDb();
        }
        if (this.cellType == null) {
            this.readRegulationGff();
        }
        this.readRegulationBed();
        if (this.verbose) {
            Timer.showStdErr("Done");
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani");
        System.err.println("Usage: snpEff build [options] genome_version");
        System.err.println("\nBuild DB options:");
        System.err.println("\t-embl                   : Use Embl format. It implies '-1'.");
        System.err.println("\t-genbank                : Use GenBank format. It implies '-1'.");
        System.err.println("\t-gff2                   : Use GFF2 format (obsolete). It implies '-1'.");
        System.err.println("\t-gff3                   : Use GFF3 format. It implies '-1'");
        System.err.println("\t-gtf22                  : Use GTF 2.2 format. It implies '-1'. Default");
        System.err.println("\t-knowngenes             : Use KnownGenes table from UCSC. It implies '-0'.");
        System.err.println("\t-refseq                 : Use RefSeq table from UCSC. It implies '-0'.");
        System.err.println("\t-txt                    : Use TXT format (obsolete).");
        System.err.println("\t-onlyReg                : Only build regulation tracks.");
        System.err.println("\t-cellType <type>        : Only build regulation tracks for cellType <type>.");
        System.err.println("\nGeneric options:");
        System.err.println("\t-0                      : File positions are zero-based (same as '-inOffset 0 -outOffset 0')");
        System.err.println("\t-1                      : File positions are one-based (same as '-inOffset 1 -outOffset 1')");
        System.err.println("\t-c , -config            : Specify config file");
        System.err.println("\t-h , -help              : Show this help and exit");
        System.err.println("\t-if, -inOffset          : Offset input by a number of bases. E.g. '-inOffset 1' for one-based input files");
        System.err.println("\t-of, -outOffset         : Offset output by a number of bases. E.g. '-outOffset 1' for one-based output files");
        System.err.println("\t-noLog                  : Do not report usage statistics to server");
        System.err.println("\t-q , -quiet             : Quiet mode (do not show any messages or errors)");
        System.err.println("\t-v , -verbose           : Verbose mode");
        System.exit(-1);
    }
}

