/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;

public class SpliceSiteDonor
extends SpliceSite {
    private static final long serialVersionUID = -2117470153797320999L;

    public SpliceSiteDonor() {
        this.type = ChangeEffect.EffectType.SPLICE_SITE_DONOR;
    }

    public SpliceSiteDonor(Exon parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        this.type = ChangeEffect.EffectType.SPLICE_SITE_DONOR;
    }

    @Override
    public boolean intersectsCoreSpliceSite(Marker marker) {
        int coreEnd;
        int coreStart;
        if (this.size() <= 2) {
            return true;
        }
        if (!this.getChromosomeName().equals(marker.getChromosomeName())) {
            return false;
        }
        if (this.isStrandPlus()) {
            coreStart = this.start;
            coreEnd = coreStart + 2 - 1;
        } else {
            coreEnd = this.end;
            coreStart = coreEnd - 2 + 1;
        }
        return marker.intersects(coreStart, coreEnd);
    }
}

