/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import edu.mayo.cli.CLIErrorHandler;
import edu.mayo.cli.CLIInitialization;
import edu.mayo.cli.CLILogHandler;
import edu.mayo.cli.CLIUsageHandler;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.CommandPluginFactory;
import edu.mayo.cli.util.PropertiesUtil;
import edu.mayo.cli.util.SageUtil;
import edu.mayo.sage.Usage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.PosixParser;

public class CommandLineApp {
    private CommandLineParser mParser = new PosixParser();
    private ByteArrayOutputStream mSystemErrorOutStream;
    private ByteArrayOutputStream mSystemOutOutStream;
    private PrintStream mSysOut;
    private PrintStream mSysErr;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java " + CommandLineApp.class.getName() + " <plugin classname> <script name> <arg1> <arg2> <arg3>...");
            System.exit(1);
        }
        String pluginClassName = args[0];
        String scriptName = args[1];
        String[] cmdArgs = Arrays.copyOfRange(args, 2, args.length);
        CommandLineApp app = new CommandLineApp();
        int exitCode = app.runApplication(pluginClassName, scriptName, cmdArgs);
        System.exit(exitCode);
    }

    public int runApplication(String pluginClassName, String scriptName, String[] cmdArgs) {
        CLIInitialization initialization = null;
        CLIErrorHandler cliErrorHandler = null;
        try {
            CLILogHandler logHandler = new CLILogHandler();
            initialization = new CLIInitialization(pluginClassName, scriptName, cmdArgs, logHandler.getDefaultLogName());
            CLIUsageHandler usageHandler = new CLIUsageHandler(initialization);
            logHandler.processLogFlags(cmdArgs, initialization.getOptions(), usageHandler);
            cliErrorHandler = new CLIErrorHandler(initialization, logHandler, usageHandler);
            initialization.verify();
            if (usageHandler.isHelpFlagUsed()) {
                System.out.println(usageHandler.getHelpText());
                return 0;
            }
            if (usageHandler.isVersionFlagUsed()) {
                String version = usageHandler.getVersionText();
                if (version == null) {
                    System.err.println("Application version unavailable");
                    return 1;
                }
                System.out.println(scriptName + " version " + version);
                return 0;
            }
            CommandPlugin plugin = CommandPluginFactory.loadPlugin(pluginClassName);
            plugin.init(PropertiesUtil.mergeProperties(initialization.getGlobalProperties(), initialization.getPluginProps()));
            CommandLine line = this.mParser.parse(initialization.getOptions(), cmdArgs);
            initialization.verifyStandloneArguments(line.getArgs());
            Usage.logger().logBegin(initialization.getScriptName(), SageUtil.toSageMap(line));
            plugin.execute(line, initialization.getOptions());
            Usage.logger().logEnd(initialization.getScriptName());
            return 0;
        }
        catch (Throwable t) {
            if (initialization == null) {
                String msg = t.toString();
                System.err.println(msg);
                System.err.println("");
                System.err.println("");
                return 1;
            }
            Usage.logger().logError(initialization.getScriptName(), t, 1);
            try {
                if (cliErrorHandler == null) {
                    System.err.println(t.getMessage());
                    System.err.println("");
                    System.err.println("");
                    System.err.println("");
                    return 1;
                }
                cliErrorHandler.processError(t);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return 1;
        }
    }

    public void captureSystemOutAndErrorToStrings() {
        System.err.println("WARNING:  StdErr is being redirected to a string!  This should only be called for TESTING purposes only!!!");
        System.err.println("  NOTE: This msg is printed before redirecting the streams, so it will not show up in either the stderr or stdout strings.");
        this.redirectSystemErrorToString();
        this.redirectSystemOutToString();
    }

    public void resetSystemOutAndError() {
        System.setOut(this.mSysOut);
        System.setErr(this.mSysErr);
    }

    private void redirectSystemErrorToString() {
        this.mSysErr = System.err;
        this.mSystemErrorOutStream = new ByteArrayOutputStream();
        PrintStream printStreamErr = new PrintStream(this.mSystemErrorOutStream);
        System.setErr(printStreamErr);
    }

    private void redirectSystemOutToString() {
        this.mSysOut = System.out;
        this.mSystemOutOutStream = new ByteArrayOutputStream();
        PrintStream printStreamOut = new PrintStream(this.mSystemOutOutStream);
        System.setOut(printStreamOut);
    }

    public String getSystemErrorMessages() throws UnsupportedEncodingException {
        return this.mSystemErrorOutStream.toString("UTF8");
    }

    public String getSystemOutMessages() throws UnsupportedEncodingException {
        return this.mSystemOutOutStream.toString("UTF8");
    }
}

