/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesDel
extends TestCase {
    boolean debug = false;
    boolean forcePositive = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesDel() {
        this.init();
    }

    String codonsNew(SeqChange seqChange) {
        int cdsBaseNum = 0;
        String codonsNew = "";
        char[] currCodon = new char[3];
        boolean useCodon = false;
        currCodon[2] = 32;
        currCodon[1] = 32;
        currCodon[0] = 32;
        for (Exon exon : this.transcript.sortedStrand()) {
            int beg;
            int step = exon.getStrand() >= 0 ? 1 : -1;
            int pos = beg = exon.getStrand() >= 0 ? exon.getStart() : exon.getEnd();
            while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                int cdsCodonPos = cdsBaseNum % 3;
                if (seqChange.intersects(pos)) {
                    useCodon = true;
                } else {
                    char base = this.chromoBases[pos];
                    char c = currCodon[cdsCodonPos] = exon.getStrand() >= 0 ? base : GprSeq.wc(base);
                }
                if (cdsCodonPos == 2) {
                    if (useCodon) {
                        codonsNew = codonsNew + new String(currCodon);
                    }
                    useCodon = false;
                    currCodon[2] = 32;
                    currCodon[1] = 32;
                    currCodon[0] = 32;
                }
                pos += step;
                ++cdsBaseNum;
            }
        }
        if (useCodon) {
            codonsNew = codonsNew + new String(currCodon);
        }
        return this.removeWhiteSpaces(codonsNew);
    }

    String codonsOld(SeqChange seqChange) {
        int cdsBaseNum = 0;
        String codonsOld = "";
        char[] currCodon = new char[3];
        boolean useCodon = false;
        currCodon[2] = 32;
        currCodon[1] = 32;
        currCodon[0] = 32;
        for (Exon exon : this.transcript.sortedStrand()) {
            int beg;
            int step = exon.getStrand() >= 0 ? 1 : -1;
            int pos = beg = exon.getStrand() >= 0 ? exon.getStart() : exon.getEnd();
            while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                int cdsCodonPos = cdsBaseNum % 3;
                useCodon |= seqChange.intersects(pos);
                char base = this.chromoBases[pos];
                char c = currCodon[cdsCodonPos] = exon.getStrand() >= 0 ? base : GprSeq.wc(base);
                if (cdsCodonPos == 2) {
                    if (useCodon) {
                        codonsOld = codonsOld + new String(currCodon);
                    }
                    useCodon = false;
                    currCodon[2] = 32;
                    currCodon[1] = 32;
                    currCodon[0] = 32;
                }
                pos += step;
                ++cdsBaseNum;
            }
        }
        if (useCodon) {
            codonsOld = codonsOld + new String(currCodon);
        }
        return this.removeWhiteSpaces(codonsOld);
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        sepf.setForcePositive(this.forcePositive);
        if (this.forcePositive) {
            Gpr.debug("WARNING: Positive strand only tests!");
        }
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    String removeWhiteSpaces(String str) {
        String strNoWs = "";
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            strNoWs = strNoWs + str.charAt(i);
        }
        return strNoWs;
    }

    public void test_01() {
        int N = 1000;
        CodonTable codonTable = this.genome.codonTable();
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("DEL Test iteration: " + i + "\n" + this.transcript);
            } else {
                System.out.println("DEL Test iteration: " + i + "\t" + this.transcript.cds());
            }
            int cdsBaseNum = 0;
            for (Exon exon : this.transcript.sortedStrand()) {
                int beg;
                int step = exon.getStrand() >= 0 ? 1 : -1;
                int pos = beg = exon.getStrand() >= 0 ? exon.getStart() : exon.getEnd();
                while (pos >= exon.getStart() && pos <= exon.getEnd()) {
                    int seqChangeStrand;
                    String delPlus;
                    int delLen = this.rand.nextInt(10) + 1;
                    int start = pos;
                    int end = pos + delLen;
                    if (this.transcript.getStrand() < 0) {
                        start = pos - delLen;
                        end = pos;
                    }
                    if (start < 0) {
                        start = 0;
                    }
                    if (end > this.chromosome.getEnd()) {
                        end = this.chromosome.getEnd();
                    }
                    delLen = end - start + 1;
                    String del = delPlus = this.chromoSequence.substring(start, end + 1);
                    int cdsCodonNum = cdsBaseNum / 3;
                    int cdsCodonPos = cdsBaseNum % 3;
                    int n = seqChangeStrand = this.rand.nextBoolean() ? 1 : -1;
                    if (this.forcePositive) {
                        seqChangeStrand = 1;
                    }
                    if (seqChangeStrand < 0) {
                        del = GprSeq.reverseWc(delPlus);
                    }
                    SeqChange seqChange = new SeqChange(this.chromosome, start, "", "-" + del, seqChangeStrand, "", 1.0, 1);
                    Assert.assertEquals((boolean)true, (boolean)seqChange.isDel());
                    Assert.assertEquals((int)del.length(), (int)seqChange.size());
                    String effectExpected = "";
                    String codonsOld = this.codonsOld(seqChange);
                    codonsOld = codonsOld.toUpperCase();
                    String aaOld = codonTable.aa(codonsOld);
                    String codonsNew = this.codonsNew(seqChange);
                    String aaNew = codonTable.aa(codonsNew);
                    String netChange = "";
                    for (Exon ex : this.transcript.sortedStrand()) {
                        netChange = netChange + seqChange.netChange(ex);
                    }
                    if (codonsOld.isEmpty()) {
                        codonsOld = "-";
                    }
                    if (codonsNew.isEmpty()) {
                        codonsNew = "-";
                    }
                    if (aaOld.isEmpty()) {
                        aaOld = "-";
                    }
                    if (aaNew.isEmpty()) {
                        aaNew = "-";
                    }
                    if (seqChange.includes(exon)) {
                        effectExpected = "EXON_DELETED";
                    } else if (netChange.length() % 3 != 0) {
                        effectExpected = "FRAME_SHIFT(-)";
                    } else {
                        effectExpected = cdsCodonPos == 0 ? "CODON_DELETION(" + aaOld + "/-)" : (codonsOld.startsWith(codonsNew) || codonsNew.equals("-") ? "CODON_DELETION(" + aaOld + "/" + aaNew + ")" : "CODON_CHANGE_PLUS_CODON_DELETION(" + aaOld + "/" + aaNew + ")");
                        if (cdsCodonNum == 0 && codonTable.isStartFirst(codonsOld) && !codonTable.isStartFirst(codonsNew)) {
                            effectExpected = "START_LOST(" + aaOld + "/" + aaNew + ")";
                        } else if (aaOld.indexOf(42) >= 0 && aaNew.indexOf(42) < 0) {
                            effectExpected = "STOP_LOST(" + aaOld + "/" + aaNew + ")";
                        } else if (aaNew.indexOf(42) >= 0 && aaOld.indexOf(42) < 0) {
                            effectExpected = "STOP_GAINED(" + aaOld + "/" + aaNew + ")";
                        }
                    }
                    List<ChangeEffect> effectsAll = this.snpEffectPredictor.seqChangeEffect(seqChange);
                    ArrayList<ChangeEffect> effects = new ArrayList<ChangeEffect>();
                    for (ChangeEffect eff : effectsAll) {
                        boolean copy = true;
                        if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_ACCEPTOR) {
                            copy = false;
                        }
                        if (eff.getEffectType() == ChangeEffect.EffectType.SPLICE_SITE_DONOR) {
                            copy = false;
                        }
                        if (eff.getEffectType() == ChangeEffect.EffectType.INTRON) {
                            copy = false;
                        }
                        if (!copy) continue;
                        effects.add(eff);
                    }
                    Assert.assertEquals((boolean)false, (boolean)effects.isEmpty());
                    if (this.debug && effects.size() > 1) {
                        System.out.println("Found more than one effect: " + effects.size() + "\n" + this.transcript);
                        for (ChangeEffect eff : effects) {
                            System.out.println("\t" + eff);
                        }
                    }
                    ChangeEffect effect = (ChangeEffect)effects.get(0);
                    String effStr = effect.effect(true, true, true);
                    if (this.debug) {
                        System.out.println("\tIteration: " + i + "\tPos: " + pos + "\n\t\tCDS base [codon] : " + cdsBaseNum + " [" + cdsCodonNum + ":" + cdsCodonPos + "]" + "\n\t\tSeqChange        : " + seqChange + "_strand" + (seqChangeStrand >= 0 ? "+" : "-") + "\tsize: " + seqChange.size() + "\tdelPlus: " + delPlus + "\n\t\tNetCdsChange     : " + netChange + "\n\t\tExpected         : " + effectExpected + "\n\t\tEffect           : " + effStr + "\n\t\tAA               : '" + aaOld + "' / '" + aaNew + "'" + "\n\t\tAA (eff)         : '" + effect.getAaOld() + "' / '" + effect.getAaNew() + "'" + "\n\t\tCodon            : '" + codonsOld + "' / '" + codonsNew + "'" + "\n\t\tCodons(eff)      : '" + effect.getCodonsOld().toUpperCase() + "' / '" + effect.getCodonsNew().toUpperCase() + "'" + "\n");
                    }
                    Assert.assertEquals((String)effectExpected, (String)effStr);
                    if (effect.getEffectType() != ChangeEffect.EffectType.FRAME_SHIFT && effect.getEffectType() != ChangeEffect.EffectType.EXON_DELETED) {
                        String codonsNewEff;
                        Assert.assertEquals((String)codonsOld, (String)effect.getCodonsOld().toUpperCase());
                        if (codonsNew.equals("-")) {
                            codonsNew = "";
                        }
                        if ((codonsNewEff = effect.getCodonsNew().toUpperCase()).equals("-")) {
                            codonsNewEff = "";
                        }
                        Assert.assertEquals((String)codonsNew, (String)codonsNewEff);
                    }
                    pos += step;
                    ++cdsBaseNum;
                }
            }
        }
    }
}

