/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import java.util.Collection;

public class Keyword {
    private String uniqueName;
    private String description;
    private String metadata;

    protected Keyword() {
        this.metadata = null;
        this.description = null;
        this.uniqueName = null;
    }

    public Keyword(String uniqueName, String description, String metadata) {
        this.uniqueName = uniqueName;
        this.description = description;
        this.metadata = metadata;
    }

    public static final Keyword getFromList(Collection<Keyword> theKeywords, String key) {
        if (key == null) {
            return null;
        }
        for (Keyword theKeyword : theKeywords) {
            if (!theKeyword.uniqueName.equalsIgnoreCase(key)) continue;
            return theKeyword;
        }
        return null;
    }

    public final String getName() {
        return this.uniqueName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uniqueName == null ? 0 : this.uniqueName.toLowerCase().hashCode());
        if (this.uniqueName == null) {
            result = 31 * result + (this.description == null ? 0 : this.description.toLowerCase().hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return Keyword.compareValue((String)obj, this.uniqueName);
        }
        if (!(obj instanceof Keyword)) {
            return false;
        }
        Keyword other = (Keyword)obj;
        if (this.description == null || other.description == null) {
            return Keyword.compareValue(other.uniqueName, this.uniqueName);
        }
        if (this.uniqueName == null ? other.uniqueName != null : !this.uniqueName.equalsIgnoreCase(other.uniqueName)) {
            return false;
        }
        return this.description.equalsIgnoreCase(other.description);
    }

    private static final boolean compareValue(String test, String value) {
        if (value == null) {
            return test == null;
        }
        return value.equalsIgnoreCase(test);
    }

    public String toString() {
        return "Keyword [" + this.uniqueName + " : " + this.description + " : " + this.metadata + "]";
    }
}

