/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.cli.cmd.Cmds;
import edu.mayo.bior.pipeline.SNPEff.SNPEFFPipeline;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.TreatUtils;
import edu.mayo.bior.pipeline.Treat.format.BgiFormatter;
import edu.mayo.bior.pipeline.Treat.format.CosmicFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpClinvarFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpFormatter;
import edu.mayo.bior.pipeline.Treat.format.EspFormatter;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import edu.mayo.bior.pipeline.Treat.format.FormatterPipeFunction;
import edu.mayo.bior.pipeline.Treat.format.HapmapFormatter;
import edu.mayo.bior.pipeline.Treat.format.HgncFormatter;
import edu.mayo.bior.pipeline.Treat.format.MirBaseFormatter;
import edu.mayo.bior.pipeline.Treat.format.NcbiGeneFormatter;
import edu.mayo.bior.pipeline.Treat.format.OmimFormatter;
import edu.mayo.bior.pipeline.Treat.format.SNPEffFormatter;
import edu.mayo.bior.pipeline.Treat.format.ThousandGenomesFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscBlacklistedFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscConservationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscEnhancerFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRegulationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRepeatFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTfbsFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTssFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscUniqueFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPFormatter;
import edu.mayo.bior.pipeline.VEP.VEPPipeline;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.bioinformatics.VCF2VariantPipe;
import edu.mayo.pipes.history.CompressPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.string.TrimSpacesPipe;
import edu.mayo.pipes.util.FieldSpecification;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TreatPipelineSingleThread
extends Pipeline<History, History> {
    private static Logger sLogger = Logger.getLogger(TreatPipelineSingleThread.class.getClass());
    private List<String> mConfigColumnsToOutput;
    private TreatUtils mUtils;
    private List<Metadata> mMetadataToAdd = new ArrayList<Metadata>();
    private List<String> mCatalogForColumn = new ArrayList<String>();

    public TreatPipelineSingleThread() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this(null);
    }

    public TreatPipelineSingleThread(String configFilePath) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this.mUtils = new TreatUtils();
        this.mConfigColumnsToOutput = this.mUtils.loadConfig(configFilePath);
        this.mUtils.validateConfigFileColumns(this.mConfigColumnsToOutput);
        this.initPipes();
    }

    private void initPipes() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        ArrayList<Pipe> pipeList = new ArrayList<Pipe>();
        ArrayList<JsonColumn> order = new ArrayList<JsonColumn>();
        sLogger.info((Object)"\n\n==========================================================================================");
        this.addTrim(pipeList);
        this.addVcfToTjson(order, pipeList);
        this.addVep(order, pipeList);
        this.addSnpEff(order, pipeList);
        this.addSameVariant(order, pipeList, new DbsnpFormatter(), BiorProperties.Key.dbsnpFile, JsonColumn.DBSNP_ALL);
        this.addSameVariant(order, pipeList, new DbsnpClinvarFormatter(), BiorProperties.Key.dbsnpClinvarFile, JsonColumn.DBSNP_CLINVAR);
        this.addSameVariant(order, pipeList, new CosmicFormatter(), BiorProperties.Key.cosmicFile, JsonColumn.COSMIC);
        this.addOverlap(order, pipeList, new UcscBlacklistedFormatter(), BiorProperties.Key.blacklistedFile, JsonColumn.UCSC_BLACKLISTED);
        this.addOverlap(order, pipeList, new UcscConservationFormatter(), BiorProperties.Key.conservationFile, JsonColumn.UCSC_CONSERVATION);
        this.addOverlap(order, pipeList, new UcscEnhancerFormatter(), BiorProperties.Key.enhancerFile, JsonColumn.UCSC_ENHANCER);
        this.addOverlap(order, pipeList, new UcscTfbsFormatter(), BiorProperties.Key.tfbsFile, JsonColumn.UCSC_TFBS);
        this.addOverlap(order, pipeList, new UcscTssFormatter(), BiorProperties.Key.tssFile, JsonColumn.UCSC_TSS);
        this.addOverlap(order, pipeList, new UcscUniqueFormatter(), BiorProperties.Key.uniqueFile, JsonColumn.UCSC_UNIQUE);
        this.addOverlap(order, pipeList, new UcscRepeatFormatter(), BiorProperties.Key.repeatFile, JsonColumn.UCSC_REPEAT);
        this.addOverlap(order, pipeList, new UcscRegulationFormatter(), BiorProperties.Key.regulationFile, JsonColumn.UCSC_REGULATION);
        this.addOverlap(order, pipeList, new MirBaseFormatter(), BiorProperties.Key.mirBaseFile, JsonColumn.MIRBASE);
        this.addSameVariant(order, pipeList, new BgiFormatter(), BiorProperties.Key.bgiFile, JsonColumn.BGI);
        this.addSameVariant(order, pipeList, new EspFormatter(), BiorProperties.Key.espFile, JsonColumn.ESP);
        this.addSameVariant(order, pipeList, new HapmapFormatter(), BiorProperties.Key.hapMapFile, JsonColumn.HAPMAP);
        this.addSameVariant(order, pipeList, new ThousandGenomesFormatter(), BiorProperties.Key.kGenomeFile, JsonColumn.THOUSAND_GENOMES);
        this.addOverlap(order, pipeList, new NcbiGeneFormatter(), BiorProperties.Key.genesFile, JsonColumn.NCBI_GENE);
        this.addLookup(order, pipeList, new HgncFormatter(), BiorProperties.Key.hgncFile, JsonColumn.HGNC, BiorProperties.Key.hgncIndexFile, "GeneID", "Entrez_Gene_ID");
        this.addLookup(order, pipeList, new OmimFormatter(), BiorProperties.Key.omimFile, JsonColumn.OMIM, BiorProperties.Key.omimIndexFile, "mapped_OMIM_ID", "MIM_Number");
        sLogger.info((Object)("Order of output columns: " + order));
        sLogger.info((Object)("Cols from config file:   " + this.mConfigColumnsToOutput));
        FormatterPipeFunction formatterPipe = new FormatterPipeFunction(order, this.mConfigColumnsToOutput);
        pipeList.add((Pipe)new TransformFunctionPipe((PipeFunction)formatterPipe));
        sLogger.info((Object)"==========================================================================================\n\n");
        this.mMetadataToAdd = formatterPipe.getMetadataForUserColumns(this.mCatalogForColumn);
        FieldSpecification fSpec = new FieldSpecification(formatterPipe.getColumnsAdded().size() + "-", FieldSpecification.FieldDirection.RIGHT_TO_LEFT);
        pipeList.add((Pipe)new CompressPipe(Cmds.Names.bior_compress.toString(), fSpec, "|", "\\|", true));
        this.setPipes(pipeList);
    }

    private void addTrim(List<Pipe> pipeList) {
        pipeList.add((Pipe)new TrimSpacesPipe());
    }

    private void addVcfToTjson(List<JsonColumn> order, List<Pipe> pipeList) {
        order.add(JsonColumn.VARIANT);
        this.mCatalogForColumn.add(null);
        pipeList.add((Pipe)new VCF2VariantPipe());
        sLogger.info((Object)"AddPipe:  VCF2VariantPipe");
    }

    private void addSameVariant(List<JsonColumn> order, List<Pipe> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName) throws IOException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        order.add(jsonColName);
        String catalogPath = this.mUtils.getFile(catalogKey);
        this.mCatalogForColumn.add(catalogPath);
        pipeList.add((Pipe)new SameVariantPipe(catalogPath, 1 - order.size()));
        sLogger.info((Object)"AddPipe:  SameVariantPipe");
        sLogger.info((Object)("            Col:     " + (1 - order.size()) + " (this is the first added / VcfToTJson column)"));
        sLogger.info((Object)("            Catalog: " + catalogPath));
    }

    private void addOverlap(List<JsonColumn> order, List<Pipe> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName) throws IOException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        order.add(jsonColName);
        String catalogPath = this.mUtils.getFile(catalogKey);
        this.mCatalogForColumn.add(catalogPath);
        pipeList.add((Pipe)new OverlapPipe(catalogPath, 1 - order.size()));
        sLogger.info((Object)"AddPipe:  OverlapPipe");
        sLogger.info((Object)("            Col:     " + (1 - order.size()) + " (this is the first added / VcfToTJson column)"));
        sLogger.info((Object)("            Catalog: " + catalogPath));
    }

    private void addLookup(List<JsonColumn> order, List<Pipe> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName, BiorProperties.Key indexKey, String jsonPathToDrill, String jsonPathToLookup) throws FileNotFoundException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        this.mUtils.throwErrorIfMissing(indexKey, TreatUtils.FileType.index);
        order.add(order.size() - 1, JsonColumn.IGNORE);
        this.mCatalogForColumn.add(this.mCatalogForColumn.size() - 1, null);
        pipeList.add((Pipe)new DrillPipe(true, new String[]{jsonPathToDrill}));
        order.add(jsonColName);
        String catalogPath = this.mUtils.getFile(catalogKey);
        this.mCatalogForColumn.add(catalogPath);
        String indexDbPath = this.mUtils.getFile(indexKey);
        pipeList.add((Pipe)new LookupPipe(catalogPath, indexDbPath, -2));
        sLogger.info((Object)"AddPipe:  DrillPipe + LookupPipe:");
        sLogger.info((Object)("            DrillPipe:  drilling [" + jsonPathToDrill + "] key from previous JSON (keep JSON!)"));
        sLogger.info((Object)"            LookupPipe: (NOTE: from JSON two columns back because JSON was kept)");
        sLogger.info((Object)("               key:     " + jsonPathToLookup));
        sLogger.info((Object)("               catalog: " + catalogPath));
        sLogger.info((Object)("               index:   " + indexDbPath));
    }

    private void addSnpEff(List<JsonColumn> order, List<Pipe> pipeList) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        if (!this.mUtils.isNeedPipe(new SNPEffFormatter())) {
            return;
        }
        if (DependancyUtil.isSNPEffInstalled()) {
            System.err.println("SNPEFF is requested, bior is starting it up, this will take about 1 min.");
            order.add(JsonColumn.SNPEFF);
            this.mCatalogForColumn.add("/tools/snpeff");
            pipeList.add((Pipe)new SNPEFFPipeline(new String[0], true));
            sLogger.info((Object)"AddPipe:  SNPEFFPipeline (tool)");
        } else {
            System.err.println("Warning: SnpEffect is listed as a required field, but is not installed.  Running without it...");
        }
    }

    private void addVep(List<JsonColumn> order, List<Pipe> pipeList) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        if (!this.mUtils.isNeedPipe(new VEPFormatter())) {
            return;
        }
        if (DependancyUtil.isVEPInstalled()) {
            order.add(JsonColumn.VEP);
            this.mCatalogForColumn.add("/tools/vep");
            pipeList.add((Pipe)new VEPPipeline(new String[0], true));
            sLogger.info((Object)"AddPipe:  VEPPipeline (tool)");
        } else {
            System.err.println("Warning: VEP is listed as a required field, but is not installed.  Running without it...");
        }
    }

    public List<Metadata> getMetadata() {
        return this.mMetadataToAdd;
    }
}

