/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.util.index.IndexDatabaseCreator;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class IndexCommand
implements CommandPlugin {
    private static final char OPTION_CATALOG = 'd';
    private static final char OPTION_INDEX_PATH = 'i';
    private static final char OPTION_KEY = 'p';
    private static final char OPTION_VERBOSE = 'v';

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String bgzipPath = line.getOptionValue('d');
        String key = line.getOptionValue('p');
        boolean isVerbose = opts.hasOption("v");
        File bgzipFile = new File(bgzipPath);
        this.warnIfBgzipIsDirOrNotExists(opts, bgzipPath, bgzipFile);
        String indexDbPathOut = line.getOptionValue('i');
        if (indexDbPathOut == null) {
            indexDbPathOut = IndexUtils.getH2DbIndexPath((String)bgzipPath, (String)key);
        } else {
            this.warnIsDirOrNotSamePrefix(opts, bgzipPath, bgzipFile, indexDbPathOut);
        }
        IndexUtils.createParentDirectories((String)indexDbPathOut);
        IndexDatabaseCreator indexer = new IndexDatabaseCreator();
        indexer.buildIndexH2(bgzipPath, -1, key, indexDbPathOut, isVerbose);
    }

    private void warnIfBgzipIsDirOrNotExists(Options opts, String bgzipPath, File bgzipFile) throws InvalidOptionArgValueException {
        if (bgzipFile.isDirectory()) {
            throw new InvalidOptionArgValueException(opts.getOption("d"), bgzipPath, "The following file is a directory (it must be a file): " + bgzipPath);
        }
        if (!bgzipFile.exists()) {
            throw new InvalidOptionArgValueException(opts.getOption("d"), bgzipPath, "Catalog file could not be found: " + bgzipPath);
        }
    }

    private void warnIsDirOrNotSamePrefix(Options opts, String bgzipPath, File bgzipFile, String indexDbPathOut) throws InvalidOptionArgValueException {
        File f2 = new File(indexDbPathOut);
        if (f2.isDirectory()) {
            throw new InvalidOptionArgValueException(opts.getOption("d"), indexDbPathOut, "The following file is a directory (it must be a file): " + indexDbPathOut);
        }
        if (!f2.getName().startsWith(bgzipFile.getName().replaceAll(".tsv.bgz", ""))) {
            System.err.println("Warning: Your file and your index do not have the same prefix.  Make sure you want to do this\nFile: " + bgzipPath + "\nIndex: " + indexDbPathOut);
        }
    }
}

