/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.catalogremoveduplicates.CatalogRemoveDuplicatesPipe;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.tabix.BgzipWriter;
import edu.mayo.pipes.UNIX.CatAnythingPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CatalogRemoveDuplicatesCommand
implements CommandPlugin {
    private static final char OPTION_INPUT_CATALOG = 'i';
    private static final char OPTION_OUTPUT_CATALOG = 'o';
    private static final char OPTION_JSON_PATH = 'p';
    private static final char OPTION_ANY_ELEMENT_IN_ARRAY = 'a';
    private static final char OPTION_SKIP_REGION = 's';
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String inputCatalogPath = "";
        if (line.hasOption('i')) {
            inputCatalogPath = line.getOptionValue('i');
        }
        String outputCatalogPath = "";
        if (line.hasOption('o')) {
            outputCatalogPath = line.getOptionValue('o');
        }
        ArrayList<String> jsonPathsToCompare = new ArrayList<String>();
        if (line.hasOption('p')) {
            jsonPathsToCompare.addAll(Arrays.asList(line.getOptionValues('p')));
        }
        boolean isCompareAnyInSubset = false;
        if (line.hasOption('a')) {
            isCompareAnyInSubset = true;
        }
        ArrayList<String> regionsToSkip = new ArrayList<String>();
        if (line.hasOption('s')) {
            regionsToSkip.addAll(Arrays.asList(line.getOptionValues('s')));
        }
        this.verifyRegions(regionsToSkip);
        String inputCatalogType = "gzip";
        if (!inputCatalogPath.endsWith(".gz") && !inputCatalogPath.endsWith(".bgz")) {
            inputCatalogType = "text";
        }
        CatAnythingPipe catInputCatalogPipe = new CatAnythingPipe(inputCatalogType);
        HistoryInPipe historyInPipe = new HistoryInPipe();
        CatalogRemoveDuplicatesPipe removeDuplicatesPipe = new CatalogRemoveDuplicatesPipe(jsonPathsToCompare, isCompareAnyInSubset, regionsToSkip);
        BgzipWriter bgzWriterPipe = new BgzipWriter(outputCatalogPath, true);
        Pipeline pipeline = new Pipeline(new Pipe[]{catInputCatalogPipe, historyInPipe, removeDuplicatesPipe, bgzWriterPipe});
        pipeline.setStarts(Arrays.asList(inputCatalogPath));
        while (pipeline.hasNext()) {
            pipeline.next();
        }
    }

    private void verifyRegions(List<String> regionsToSkip) {
        for (String region : regionsToSkip) {
            String[] parts = region.split(":|-");
            boolean isChromMatch = region.matches("[0-9A-Za-z]+");
            boolean isChromAndMinMatch = region.matches("[0-9A-Za-z]+:[0-9]+");
            boolean isChromAndMinMaxMatch = region.matches("[0-9A-Za-z]+:[0-9]+-[0-9]+");
            if (isChromMatch || isChromAndMinMatch || isChromAndMinMaxMatch) continue;
            throw new IllegalArgumentException("Region format incorrect: " + region + ".   Format:  CHROM  or  CHROM:MIN  or  CHROM:MIN-MAX");
        }
    }
}

