/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class SystemProperties {
    private static Logger sLogger = Logger.getLogger(SystemProperties.class);
    private static final String SYS_PROP = "SYS_PROP";
    private static String file = null;
    private Properties prop = null;

    public static void setFile(String f) {
        file = f;
    }

    public SystemProperties() throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            this.prop = new Properties();
            this.prop.load(inStream);
        }
        catch (IOException ex) {
            sLogger.error((Object)"Failed to load system properties!", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {
                sLogger.error((Object)"Failed to close the system properties input stream!", (Throwable)ex);
                throw ex;
            }
        }
    }

    public String get(String key) {
        return this.prop.getProperty(key);
    }

    public Set<String> propertySet() {
        return this.prop.stringPropertyNames();
    }

    static {
        String DEFAULT_PROP_FILE_NAME = "sys.properties";
        if (System.getenv(SYS_PROP) != null) {
            file = System.getenv(SYS_PROP);
        } else if (new File(System.getenv("HOME") + "/" + "sys.properties").exists()) {
            file = System.getenv("HOME") + "/" + "sys.properties";
        } else if (System.getProperty(SYS_PROP) != null) {
            file = System.getProperty(SYS_PROP);
        }
        if (file == null || !new File(file).exists()) {
            String test = System.getenv("user.dir") + "/" + "sys.properties";
            if (new File(test).exists()) {
                file = test;
            } else {
                URL url = SystemProperties.class.getClassLoader().getResource("sys.properties");
                if (url != null) {
                    file = url.getFile();
                }
            }
        }
        sLogger.info((Object)("using " + file + " for sys.properties"));
    }
}

