/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import edu.mayo.bior.pipeline.Treat.format.FormatterPipeFunction;
import edu.mayo.bior.pipeline.Treat.format.HgncFormatter;
import edu.mayo.bior.pipeline.Treat.format.NcbiGeneFormatter;
import edu.mayo.bior.pipeline.Treat.format.OmimFormatter;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.bior.util.DependancyUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class TreatUtils {
    private static Logger sLogger = Logger.getLogger(TreatUtils.class);
    private BiorProperties mBiorProps = new BiorProperties();
    private List<String> mConfigColumnsToOutput = null;

    public boolean isNeedPipe(Formatter colFormatter) {
        if (colFormatter == null || this.mConfigColumnsToOutput == null) {
            return true;
        }
        for (String colFromPipe : colFormatter.getHeaders()) {
            if (!this.mConfigColumnsToOutput.contains(colFromPipe)) continue;
            return true;
        }
        if (colFormatter instanceof NcbiGeneFormatter && this.isNeedPipe(new HgncFormatter())) {
            return true;
        }
        return (colFormatter instanceof NcbiGeneFormatter || colFormatter instanceof HgncFormatter) && this.isNeedPipe(new OmimFormatter());
    }

    public String getFile(BiorProperties.Key propKey) {
        String path = this.mBiorProps.get(BiorProperties.Key.fileBase) + this.mBiorProps.get(propKey);
        return path;
    }

    public List<String> loadConfig(String configFilePath) throws IOException {
        if (configFilePath == null || configFilePath.length() == 0) {
            return null;
        }
        this.mConfigColumnsToOutput = Files.readLines((File)new File(configFilePath), (Charset)Charsets.UTF_8);
        for (int i = this.mConfigColumnsToOutput.size() - 1; i >= 0; --i) {
            if (!this.mConfigColumnsToOutput.get(i).startsWith("#") && this.mConfigColumnsToOutput.get(i).trim().length() != 0) continue;
            this.mConfigColumnsToOutput.remove(i);
        }
        return this.mConfigColumnsToOutput;
    }

    public void validateConfigFileColumns(List<String> configFileCols) {
        if (configFileCols == null) {
            return;
        }
        if (configFileCols.size() == 0) {
            String MSG = "Error: The config file does not contain any output columns.  Please add some columns to output.  Or, to add all columns, do not add the config file option.";
            throw new IllegalArgumentException("Error: The config file does not contain any output columns.  Please add some columns to output.  Or, to add all columns, do not add the config file option.");
        }
        List<String> allCols = FormatterPipeFunction.getAllPossibleColumns();
        StringBuffer errMsg = new StringBuffer();
        for (String configCol : configFileCols) {
            if (allCols.contains(configCol)) continue;
            errMsg.append("    " + configCol + "\n");
        }
        if (errMsg.length() > 0) {
            errMsg.insert(0, "Error: these columns specified in the config file are not recognized:\n");
            throw new IllegalArgumentException(errMsg.toString());
        }
    }

    public void throwErrorIfMissing(BiorProperties.Key catalogOrIndexKey, FileType catalogOrIndex) throws FileNotFoundException {
        if (this.isFileThere(catalogOrIndexKey, catalogOrIndex)) {
            return;
        }
        HashMap<BiorProperties.Key, String> map = new HashMap<BiorProperties.Key, String>();
        map.put(BiorProperties.Key.dbsnpFile, "dbSNP");
        map.put(BiorProperties.Key.dbsnpClinvarFile, "dbSNP ClinVar");
        map.put(BiorProperties.Key.cosmicFile, "COSMIC");
        map.put(BiorProperties.Key.blacklistedFile, "UCSC (blacklisted)");
        map.put(BiorProperties.Key.conservationFile, "UCSC (conservation)");
        map.put(BiorProperties.Key.enhancerFile, "UCSC (enhancer)");
        map.put(BiorProperties.Key.tfbsFile, "UCSC (tfbs)");
        map.put(BiorProperties.Key.tssFile, "UCSC (tss)");
        map.put(BiorProperties.Key.uniqueFile, "UCSC (unique)");
        map.put(BiorProperties.Key.repeatFile, "UCSC (repeat)");
        map.put(BiorProperties.Key.regulationFile, "UCSC (regulation)");
        map.put(BiorProperties.Key.mirBaseFile, "mirBase");
        map.put(BiorProperties.Key.bgiFile, "BGI");
        map.put(BiorProperties.Key.espFile, "ESP");
        map.put(BiorProperties.Key.hapMapFile, "HapMap");
        map.put(BiorProperties.Key.kGenomeFile, "1000 Genomes");
        map.put(BiorProperties.Key.genesFile, "NCBIGene");
        map.put(BiorProperties.Key.hgncFile, "HGNC");
        map.put(BiorProperties.Key.omimFile, "OMIM");
        String errorMsg = String.format("ERROR: %s catalog is required for the fields that were selected, but the %s was not found.", new Object[]{map.get((Object)catalogOrIndexKey), catalogOrIndex});
        String verifyMsg = "       Verify bior.properties file location matches an existing directory and catalog/index file (key = " + catalogOrIndexKey.toString() + ")";
        System.err.println(errorMsg);
        System.err.println(verifyMsg);
        throw new FileNotFoundException(this.getFile(BiorProperties.Key.dbsnpFile));
    }

    private boolean isFileThere(BiorProperties.Key propKey, FileType fileType) {
        String path = this.getFile(propKey);
        boolean setup = false;
        if (fileType.equals((Object)FileType.catalog)) {
            setup = DependancyUtil.isCatalogInstalled(path);
        } else if (fileType.equals((Object)FileType.index)) {
            setup = DependancyUtil.isIndexInstalled(path);
        }
        return setup;
    }

    public int getMaxAlts() {
        int maxAlts = this.mBiorProps.getAsInt(BiorProperties.Key.MaxAlts, 20);
        return maxAlts;
    }

    public int getMaxLinesInFlight() {
        int maxLines = this.mBiorProps.getAsInt(BiorProperties.Key.AnnotateMaxLinesInFlight, 10);
        sLogger.info((Object)("AnnotateMaxLinesInFlight = " + maxLines));
        if (maxLines <= 1) {
            throw new IllegalArgumentException("AnnotateMaxLinesInFlight must be 2 or greater to prevent hangs!");
        }
        if (maxLines > 50) {
            sLogger.warn((Object)"WARNING: AnnotateMaxLinesInFlight is set to > 50.  This may cause a hang state as the process buffers can overflow and cause data loss, especially in the case of a high number of fanouts!");
        }
        return maxLines;
    }

    public int getTimeout() {
        int cmdTimeoutInSeconds = this.mBiorProps.getAsInt(BiorProperties.Key.TimeoutCommand, 30);
        sLogger.info((Object)("TimeoutCommand (seconds) = " + cmdTimeoutInSeconds));
        if (cmdTimeoutInSeconds < 10 || cmdTimeoutInSeconds > 300) {
            sLogger.warn((Object)("WARNING: TimeoutCommand is set to " + cmdTimeoutInSeconds + ".  It should probably be between 10 and 300.  Too short and it may timeout for a long line and crash the program unnecessarily.  Too long and it may wait a long time for a hung command to finish."));
        }
        return cmdTimeoutInSeconds;
    }

    public static enum FileType {
        catalog,
        index;

    }
}

