/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.cli.cmd.Cmds;
import edu.mayo.bior.pipeline.Treat.AnnotateEXE;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.TreatUtils;
import edu.mayo.bior.pipeline.Treat.format.BgiFormatter;
import edu.mayo.bior.pipeline.Treat.format.CosmicFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpClinvarFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpFormatter;
import edu.mayo.bior.pipeline.Treat.format.EspFormatter;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import edu.mayo.bior.pipeline.Treat.format.FormatterPipeFunction;
import edu.mayo.bior.pipeline.Treat.format.HapmapFormatter;
import edu.mayo.bior.pipeline.Treat.format.HgncFormatter;
import edu.mayo.bior.pipeline.Treat.format.MirBaseFormatter;
import edu.mayo.bior.pipeline.Treat.format.NcbiGeneFormatter;
import edu.mayo.bior.pipeline.Treat.format.OmimFormatter;
import edu.mayo.bior.pipeline.Treat.format.SNPEffFormatter;
import edu.mayo.bior.pipeline.Treat.format.ThousandGenomesFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscBlacklistedFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscConservationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscEnhancerFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRegulationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRepeatFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTfbsFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTssFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscUniqueFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPFormatter;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.CompressPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.FieldSpecification;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TreatPipelineMultiCmd
extends Pipeline<History, History> {
    private List<String> mConfigColumnsToOutput;
    private TreatUtils mUtils;
    private static Logger sLogger = Logger.getLogger(TreatPipelineMultiCmd.class);
    private String mBiorLiteHome = "";
    private String mBiorCmdDir = "";
    private List<Metadata> mMetadataToAdd = new ArrayList<Metadata>();
    private List<String> mCatalogForColumn = new ArrayList<String>();
    private String generatedCommand = "";

    public TreatPipelineMultiCmd() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this(null);
    }

    public TreatPipelineMultiCmd(String configFilePath) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this.mUtils = new TreatUtils();
        this.mConfigColumnsToOutput = this.mUtils.loadConfig(configFilePath);
        this.mUtils.validateConfigFileColumns(this.mConfigColumnsToOutput);
        this.initPipes();
    }

    public String getGeneratedCommand() {
        return this.generatedCommand;
    }

    private void initPipes() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        ArrayList<JsonColumn> order = new ArrayList<JsonColumn>();
        ArrayList<String> pipeList = new ArrayList<String>();
        this.setBiorLiteCmdDir();
        this.addTrim(pipeList);
        this.addVcfToTjson(order, pipeList);
        this.addVep(order, pipeList);
        this.addSnpEff(order, pipeList);
        this.addSameVariant(order, pipeList, new DbsnpFormatter(), BiorProperties.Key.dbsnpFile, JsonColumn.DBSNP_ALL);
        this.addSameVariant(order, pipeList, new DbsnpClinvarFormatter(), BiorProperties.Key.dbsnpClinvarFile, JsonColumn.DBSNP_CLINVAR);
        this.addSameVariant(order, pipeList, new CosmicFormatter(), BiorProperties.Key.cosmicFile, JsonColumn.COSMIC);
        this.addOverlap(order, pipeList, new UcscBlacklistedFormatter(), BiorProperties.Key.blacklistedFile, JsonColumn.UCSC_BLACKLISTED);
        this.addOverlap(order, pipeList, new UcscConservationFormatter(), BiorProperties.Key.conservationFile, JsonColumn.UCSC_CONSERVATION);
        this.addOverlap(order, pipeList, new UcscEnhancerFormatter(), BiorProperties.Key.enhancerFile, JsonColumn.UCSC_ENHANCER);
        this.addOverlap(order, pipeList, new UcscTfbsFormatter(), BiorProperties.Key.tfbsFile, JsonColumn.UCSC_TFBS);
        this.addOverlap(order, pipeList, new UcscTssFormatter(), BiorProperties.Key.tssFile, JsonColumn.UCSC_TSS);
        this.addOverlap(order, pipeList, new UcscUniqueFormatter(), BiorProperties.Key.uniqueFile, JsonColumn.UCSC_UNIQUE);
        this.addOverlap(order, pipeList, new UcscRepeatFormatter(), BiorProperties.Key.repeatFile, JsonColumn.UCSC_REPEAT);
        this.addOverlap(order, pipeList, new UcscRegulationFormatter(), BiorProperties.Key.regulationFile, JsonColumn.UCSC_REGULATION);
        this.addOverlap(order, pipeList, new MirBaseFormatter(), BiorProperties.Key.mirBaseFile, JsonColumn.MIRBASE);
        this.addSameVariant(order, pipeList, new BgiFormatter(), BiorProperties.Key.bgiFile, JsonColumn.BGI);
        this.addSameVariant(order, pipeList, new EspFormatter(), BiorProperties.Key.espFile, JsonColumn.ESP);
        this.addSameVariant(order, pipeList, new HapmapFormatter(), BiorProperties.Key.hapMapFile, JsonColumn.HAPMAP);
        this.addSameVariant(order, pipeList, new ThousandGenomesFormatter(), BiorProperties.Key.kGenomeFile, JsonColumn.THOUSAND_GENOMES);
        this.addOverlap(order, pipeList, new NcbiGeneFormatter(), BiorProperties.Key.genesFile, JsonColumn.NCBI_GENE);
        this.addLookup(order, pipeList, new HgncFormatter(), BiorProperties.Key.hgncFile, JsonColumn.HGNC, BiorProperties.Key.hgncIndexFile, "GeneID", "Entrez_Gene_ID");
        this.addLookup(order, pipeList, new OmimFormatter(), BiorProperties.Key.omimFile, JsonColumn.OMIM, BiorProperties.Key.omimIndexFile, "mapped_OMIM_ID", "MIM_Number");
        String pipesAsStr = this.pipeAsString(pipeList);
        sLogger.info((Object)("bior_annotate pipeline long cmd: " + pipesAsStr));
        this.generatedCommand = pipesAsStr;
        if (this.generatedCommand.contains("bior_snpeff")) {
            System.err.println("SNPEFF is requested, bior is starting it up, this will take about 1 min.");
        }
        HashMap<String, String> envVars = new HashMap<String, String>();
        sLogger.info((Object)("BIOR_LITE_HOME: " + this.mBiorLiteHome));
        envVars.put("BIOR_LITE_HOME", this.mBiorLiteHome);
        FormatterPipeFunction formatterPipe = new FormatterPipeFunction(order, this.mConfigColumnsToOutput);
        this.mMetadataToAdd = formatterPipe.getMetadataForUserColumns(this.mCatalogForColumn);
        FieldSpecification fSpec = new FieldSpecification(formatterPipe.getColumnsAdded().size() + "-", FieldSpecification.FieldDirection.RIGHT_TO_LEFT);
        this.setPipes(new Pipeline(new Pipe[]{new AnnotateEXE(new String[]{"/bin/sh", "-c", pipesAsStr}, envVars, this.mUtils.getMaxLinesInFlight(), this.mUtils.getTimeout(), order.size(), this.mUtils.getMaxAlts()), new TransformFunctionPipe((PipeFunction)formatterPipe), new CompressPipe(Cmds.Names.bior_compress.toString(), fSpec, "|", "\\|", true)}).getPipes());
    }

    private void addTrim(List<String> pipeList) {
        String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_trim_spaces) + this.logFlag();
        pipeList.add(cmd);
    }

    private void addVcfToTjson(List<JsonColumn> order, List<String> pipeList) {
        order.add(JsonColumn.VARIANT);
        this.mCatalogForColumn.add(null);
        String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_vcf_to_tjson) + this.logFlag();
        pipeList.add(cmd);
    }

    private void addSameVariant(List<JsonColumn> order, List<String> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName) throws FileNotFoundException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        order.add(jsonColName);
        this.mCatalogForColumn.add(this.mUtils.getFile(catalogKey));
        String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_same_variant) + " -d " + this.mUtils.getFile(catalogKey) + " -c " + (1 - order.size()) + this.logFlag();
        pipeList.add(cmd);
    }

    private void addOverlap(List<JsonColumn> order, List<String> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName) throws FileNotFoundException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        order.add(jsonColName);
        this.mCatalogForColumn.add(this.mUtils.getFile(catalogKey));
        String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_overlap) + " -d " + this.mUtils.getFile(catalogKey) + " -c " + (1 - order.size()) + this.logFlag();
        pipeList.add(cmd);
    }

    private void addLookup(List<JsonColumn> order, List<String> pipeList, Formatter formatter, BiorProperties.Key catalogKey, JsonColumn jsonColName, BiorProperties.Key indexKey, String jsonPathToDrill, String jsonPathToLookup) throws FileNotFoundException {
        if (!this.mUtils.isNeedPipe(formatter)) {
            return;
        }
        this.mUtils.throwErrorIfMissing(catalogKey, TreatUtils.FileType.catalog);
        this.mUtils.throwErrorIfMissing(indexKey, TreatUtils.FileType.index);
        order.add(order.size() - 1, JsonColumn.IGNORE);
        this.mCatalogForColumn.add(this.mCatalogForColumn.size() - 1, null);
        String drillCmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_drill) + " -p " + jsonPathToDrill + " -k" + this.logFlag();
        pipeList.add(drillCmd);
        order.add(jsonColName);
        this.mCatalogForColumn.add(this.mUtils.getFile(catalogKey));
        String lookupCmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_lookup) + " -d " + this.mUtils.getFile(catalogKey) + " -i " + this.mUtils.getFile(indexKey) + " -p " + jsonPathToLookup + " -c -2" + this.logFlag();
        pipeList.add(lookupCmd);
    }

    private void addSnpEff(List<JsonColumn> order, List<String> pipeList) throws IOException, URISyntaxException {
        if (!this.mUtils.isNeedPipe(new SNPEffFormatter())) {
            return;
        }
        if (DependancyUtil.isSNPEffInstalled()) {
            order.add(JsonColumn.SNPEFF);
            this.mCatalogForColumn.add("/tools/snpeff");
            String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_snpeff) + this.logFlag();
            pipeList.add(cmd);
        } else {
            System.err.println("Warning: SnpEffect is listed as a required field, but is not installed.  Running without it...");
        }
    }

    private void addVep(List<JsonColumn> order, List<String> pipeList) throws IOException, URISyntaxException {
        if (!this.mUtils.isNeedPipe(new VEPFormatter())) {
            return;
        }
        if (DependancyUtil.isVEPInstalled()) {
            order.add(JsonColumn.VEP);
            this.mCatalogForColumn.add("/tools/vep");
            String cmd = this.mBiorCmdDir + (Object)((Object)Cmds.Names.bior_vep) + this.logFlag();
            pipeList.add(cmd);
        } else {
            System.err.println("Warning: VEP is listed as a required field, but is not installed.  Running without it...");
        }
    }

    private String pipeAsString(List<String> pipeCmds) {
        StringBuilder bigPipe = new StringBuilder();
        for (int i = 0; i < pipeCmds.size(); ++i) {
            bigPipe.append(pipeCmds.get(i));
            if (i >= pipeCmds.size() - 1) continue;
            bigPipe.append(" | ");
        }
        return bigPipe.toString();
    }

    private String logFlag() {
        boolean isLogOn = sLogger.isDebugEnabled() || sLogger.isInfoEnabled();
        sLogger.info((Object)("If logging is on, then set it for all bior_annotate sub-commands.  Is logging on?  " + isLogOn));
        return isLogOn ? " -l" : "";
    }

    private String setBiorLiteCmdDir() throws IOException {
        this.mBiorLiteHome = System.getenv().get("BIOR_LITE_HOME");
        if (this.mBiorLiteHome == null || this.mBiorLiteHome.trim().length() == 0) {
            File targetFolder = new File("target");
            for (File f : targetFolder.listFiles()) {
                if (!f.isDirectory() || !f.getName().startsWith("bior_pipeline")) continue;
                this.mBiorLiteHome = f.getCanonicalPath();
                break;
            }
        }
        this.mBiorCmdDir = this.mBiorLiteHome + "/bin/";
        if (!new File(this.mBiorCmdDir).exists()) {
            throw new IOException("Could not find the directory containing the BioR commands!");
        }
        return this.mBiorCmdDir;
    }

    public List<Metadata> getMetadata() {
        return this.mMetadataToAdd;
    }
}

