/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intergenic;
import ca.mcgill.mcb.pcingola.interval.Interval;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SpliceSite;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Genes
implements Iterable<Gene>,
Serializable {
    private static final long serialVersionUID = 9022385501946879197L;
    public boolean debug = false;
    Genome genome;
    HashMap<String, Gene> genesById = new HashMap();

    public Genes(Genome genome) {
        this.genome = genome;
    }

    public void add(Gene gene) {
        this.genesById.put(gene.getId(), gene);
    }

    public List<Intergenic> createIntergenic() {
        ArrayList<Intergenic> intergenics = new ArrayList<Intergenic>(this.genesById.size());
        ArrayList<Gene> genesSorted = new ArrayList<Gene>(this.genesById.size());
        genesSorted.addAll(this.genesById.values());
        Collections.sort(genesSorted);
        Interval genePrev = null;
        Chromosome chrPrev = null;
        for (Gene gene : genesSorted) {
            int end;
            int start;
            if (chrPrev != gene.getChromosome()) {
                genePrev = null;
            }
            if ((start = genePrev != null ? genePrev.getEnd() + 1 : 0) < (end = gene.getStart() - 1)) {
                String id = (genePrev != null ? ((Gene)genePrev).getGeneName() + "..." : "") + gene.getGeneName();
                Intergenic intergenic = new Intergenic(gene.getChromosome(), start, end, 1, id);
                intergenics.add(intergenic);
            }
            if (genePrev == null || gene.getEnd() > genePrev.getEnd()) {
                genePrev = gene;
            }
            chrPrev = gene.getChromosome();
        }
        return intergenics;
    }

    public List<Marker> createUpDownStream(int upDownLength) {
        ArrayList<Marker> list = new ArrayList<Marker>();
        if (upDownLength <= 0) {
            return list;
        }
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createUpDownStream(upDownLength);
                list.add(tr.getUpstream());
                list.add(tr.getDownstream());
            }
        }
        return list;
    }

    public Collection<Marker> findSpliceSites(boolean createIfMissing) {
        ArrayList<Marker> spliceSites = new ArrayList<Marker>();
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                List<SpliceSite> slist = tr.findSpliceSites(createIfMissing);
                spliceSites.addAll(slist);
            }
        }
        return spliceSites;
    }

    public Gene get(String geneId) {
        return this.genesById.get(geneId);
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genesById.values().iterator();
    }

    public int size() {
        return this.genesById.size();
    }

    public Collection<Gene> sorted() {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        genes.addAll(this.genesById.values());
        Collections.sort(genes, new IntervalComparatorByStart());
        return genes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Gene gint : this) {
            sb.append(gint + "\n");
        }
        return sb.toString();
    }

    public Collection<Gene> values() {
        return this.genesById.values();
    }
}

