/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fastq;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fastq.FastqTools;
import ca.mcgill.mcb.pcingola.fastq.FastqTrimmer;
import java.util.Collections;
import java.util.LinkedList;

public class FastqTrimmerMedian
extends FastqTrimmer {
    int runningMedianLength;

    public FastqTrimmerMedian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases);
        this.runningMedianLength = runningMedianLength;
    }

    int median(int[] qual, int i) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        int k = 0;
        int j = i - this.runningMedianLength + 1;
        while (k < this.runningMedianLength) {
            if (j >= 0 && j < qual.length) {
                list.add(qual[j]);
            }
            ++k;
            ++j;
        }
        Collections.sort(list);
        int size = list.size();
        int med = 0;
        med = list.size() % 2 == 1 ? (Integer)list.get(size / 2) : ((Integer)list.get(size / 2 - 1) + (Integer)list.get(size / 2)) / 2;
        return med;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        for (int i = 0; i < qual.length; ++i) {
            int median = this.median(qual, i);
            if (median >= this.qualityThreshold) continue;
            return i;
        }
        return qual.length;
    }
}

