/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class JSONUtil {
    public static JsonArray stringArr2JSON(String[] s) {
        JsonArray jarr = new JsonArray();
        for (int i = 0; i < s.length; ++i) {
            JsonObject obj = new JsonObject();
            obj.addProperty(String.valueOf(i), s[0]);
            jarr.add((JsonElement)obj);
        }
        return jarr;
    }

    public static JsonObject stringHash2JSON(HashMap<String, String> hm) {
        JsonObject jobj = new JsonObject();
        for (String key : hm.keySet()) {
            jobj.addProperty(key, hm.get(key));
        }
        return jobj;
    }

    public static String computeJSON(HashMap hm, boolean isTruncate) {
        JsonObject f = new JsonObject();
        ArrayList keys = new ArrayList(hm.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Object value = hm.get(key);
            if (isTruncate && value.toString().endsWith(".0") && JSONUtil.isDouble(value.toString())) {
                value = value.toString().replace(".0", "");
            }
            if (JSONUtil.isInt(value.toString())) {
                f.addProperty(key, (Number)JSONUtil.toInt(value.toString()));
                continue;
            }
            if (JSONUtil.isDouble(value.toString())) {
                f.addProperty(key, (Number)JSONUtil.toDouble(value.toString()));
                continue;
            }
            f.addProperty(key, value.toString());
        }
        return f.toString().trim();
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int toInt(String s) {
        int p = Integer.parseInt(s);
        return p;
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double toDouble(String s) {
        double p = Double.parseDouble(s);
        return p;
    }
}

