/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class HCutPipe
extends AbstractPipe<History, History> {
    private ArrayList<Integer> cols;
    private boolean muck = true;

    public HCutPipe(int[] columns) {
        this.init(columns);
        this.muck = true;
    }

    public HCutPipe(boolean muck, int[] columns) {
        this.init(columns);
        this.muck = muck;
    }

    private void init(int[] columns) {
        this.cols = new ArrayList();
        Arrays.sort(columns);
        for (int i = columns.length - 1; i >= 0; --i) {
            this.cols.add(columns[i]);
        }
    }

    public void reset() {
        this.muck = true;
        super.reset();
    }

    protected History processNextStart() throws NoSuchElementException {
        History h = (History)this.starts.next();
        List<ColumnMetaData> cmd = h.getMetaData().getColumns();
        for (int i = 0; i < this.cols.size(); ++i) {
            int cutCol = this.cols.get(i);
            if (cutCol > 0) {
                cutCol = cutCol - h.size() - 1;
            }
            if (h.size() == 1) {
                cutCol = -1;
            }
            int m = h.size() + cutCol;
            h.remove(m);
            if (!this.muck) continue;
            cmd.remove(m);
        }
        this.muck = false;
        return h;
    }
}

