/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class GatherFunctionPipe<S, E>
extends AbstractPipe<S, E> {
    private List<List> listPaths = new ArrayList<List>();
    private final PipeFunction<List<S>, E> postFilterFunction;

    public GatherFunctionPipe(PipeFunction<List<S>, E> postFilterFunction) {
        this.postFilterFunction = postFilterFunction;
    }

    @Override
    public List getCurrentPath() {
        if (this.pathEnabled) {
            return new ArrayList<List>(this.listPaths);
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    @Override
    protected E processNextStart() {
        ArrayList list = new ArrayList();
        this.listPaths = new ArrayList<List>();
        if (!this.starts.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.starts.hasNext()) {
            Object s = this.starts.next();
            list.add(s);
            if (!this.pathEnabled) continue;
            this.listPaths.add(super.getPathToHere());
        }
        if (this.pathEnabled) {
            E e = this.postFilterFunction.compute(list);
            if (e instanceof List) {
                this.addList((List)e);
            } else {
                this.addList(Arrays.asList(e));
            }
            return e;
        }
        return this.postFilterFunction.compute(list);
    }

    @Override
    public void reset() {
        this.listPaths = new ArrayList<List>();
        super.reset();
    }

    private List addList(List list) {
        for (List l : this.listPaths) {
            l.add(list);
        }
        return list;
    }
}

