/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.branch;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.AbstractMetaPipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.List;
import java.util.NoSuchElementException;

public class FairMergePipe<S>
extends AbstractMetaPipe<S, S>
implements MetaPipe {
    private final List<Pipe> pipes;
    int current = 0;
    final int total;

    public FairMergePipe(List<Pipe> pipes) {
        this.pipes = pipes;
        this.total = pipes.size();
    }

    @Override
    public S processNextStart() {
        int counter = 0;
        while (true) {
            ++counter;
            Pipe currentPipe = this.pipes.get(this.current);
            if (currentPipe.hasNext()) {
                Object s = currentPipe.next();
                this.current = (this.current + 1) % this.total;
                return (S)s;
            }
            if (counter == this.total) {
                throw new NoSuchElementException();
            }
            this.current = (this.current + 1) % this.total;
        }
    }

    @Override
    public List getCurrentPath() {
        if (this.pathEnabled) {
            int tempCurrent = this.current - 1;
            if (tempCurrent < 0) {
                tempCurrent = this.total - 1;
            }
            return this.pipes.get(tempCurrent).getCurrentPath();
        }
        throw new RuntimeException("Path calculations are not enabled");
    }

    @Override
    public List<Pipe> getPipes() {
        return this.pipes;
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, this.pipes);
    }
}

