/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.Pipeline;
import com.tinkerpop.pipes.util.iterators.SingleIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FluentUtility {
    public static List<AsPipe> getAsPipes(MetaPipe metaPipe) {
        ArrayList<AsPipe> asPipes = new ArrayList<AsPipe>();
        for (Pipe subPipe : metaPipe.getPipes()) {
            if (subPipe instanceof AsPipe) {
                asPipes.add((AsPipe)subPipe);
            }
            if (!(subPipe instanceof MetaPipe)) continue;
            asPipes.addAll(FluentUtility.getAsPipes((MetaPipe)((Object)subPipe)));
        }
        return asPipes;
    }

    public static List<Pipe> removePreviousPipes(Pipeline pipeline, int numberedStep) {
        int i;
        ArrayList<Pipe> previousPipes = new ArrayList<Pipe>();
        for (i = pipeline.size() - 1; i > pipeline.size() - 1 - numberedStep; --i) {
            previousPipes.add(0, pipeline.get(i));
        }
        for (i = 0; i < numberedStep; ++i) {
            pipeline.remove(pipeline.size() - 1);
        }
        if (pipeline.size() == 1) {
            pipeline.setStarts(pipeline.getStarts());
        }
        return previousPipes;
    }

    public static List<Pipe> removePreviousPipes(Pipeline pipeline, String namedStep) {
        Pipe pipe;
        int i;
        ArrayList<Pipe> previousPipes = new ArrayList<Pipe>();
        for (i = pipeline.size() - 1; !(i < 0 || (pipe = pipeline.get(i)) instanceof AsPipe && ((AsPipe)pipe).getName().equals(namedStep)); --i) {
            previousPipes.add(0, pipe);
        }
        for (i = 0; i < previousPipes.size(); ++i) {
            pipeline.remove(pipeline.size() - 1);
        }
        if (pipeline.size() == 1) {
            pipeline.setStarts(pipeline.getStarts());
        }
        return previousPipes;
    }

    public static Pipe getPreviousPipe(Pipeline pipeline) {
        return pipeline.get(pipeline.size() - 1);
    }

    public static List<Pipe> getPreviousPipes(Pipeline pipeline, int numberedStep) {
        ArrayList<Pipe> previousPipes = new ArrayList<Pipe>();
        int pipelineSize = pipeline.size();
        for (int i = 0; i < numberedStep; ++i) {
            previousPipes.add(pipeline.get(pipelineSize - i + 1));
        }
        return previousPipes;
    }

    public static void setStarts(Pipeline pipeline, Object starts) {
        if (starts instanceof Iterator) {
            pipeline.setStarts((Iterator)starts);
        } else if (starts instanceof Iterable) {
            pipeline.setStarts(((Iterable)starts).iterator());
        } else {
            pipeline.setStarts(new SingleIterator<Object>(starts));
        }
    }
}

