/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.SequenceUtil;

public final class QualityUtil {
    private static final double[] errorProbabilityByPhredScore = new double[101];

    public static double getErrorProbabilityFromPhredScore(int n) {
        return errorProbabilityByPhredScore[n];
    }

    public static int getPhredScoreFromErrorProbability(double d) {
        return (int)Math.round(-10.0 * Math.log10(d));
    }

    public static int getPhredScoreFromObsAndErrors(double d, double d2) {
        return QualityUtil.getPhredScoreFromErrorProbability(d2 / d);
    }

    public static double sumOfErrorProbabilities(SAMRecord sAMRecord) {
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        double d = 0.0;
        for (int i = 0; i < byArray.length; ++i) {
            if (SequenceUtil.isNoCall(byArray[i])) {
                d += 1.0;
                continue;
            }
            d += QualityUtil.getErrorProbabilityFromPhredScore(byArray2[i]);
        }
        return d;
    }

    static {
        for (int i = 0; i < errorProbabilityByPhredScore.length; ++i) {
            QualityUtil.errorProbabilityByPhredScore[i] = 1.0 / Math.pow(10.0, (double)i / 10.0);
        }
    }
}

