/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SeekableFileStream
extends SeekableStream {
    static Collection<SeekableFileStream> allInstances = Collections.synchronizedCollection(new HashSet());
    File file;
    RandomAccessFile fis;

    public SeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "r");
        allInstances.add(this);
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean eof() throws IOException {
        return this.fis.length() == this.fis.getFilePointer();
    }

    @Override
    public void seek(long l) throws IOException {
        this.fis.seek(l);
    }

    @Override
    public long position() throws IOException {
        return this.fis.getChannel().position();
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.position();
        this.fis.getChannel().position(l2 + l);
        return this.position() - l2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.fis.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            if (n3 > 0) {
                return n3;
            }
            return n4;
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.fis.read(byArray);
    }

    @Override
    public String getSource() {
        return this.file.getAbsolutePath();
    }

    @Override
    public void close() throws IOException {
        allInstances.remove(this);
        this.fis.close();
    }

    public static synchronized void closeAllInstances() {
        HashSet<SeekableFileStream> hashSet = new HashSet<SeekableFileStream>();
        hashSet.addAll(allInstances);
        for (SeekableFileStream seekableFileStream : hashSet) {
            try {
                seekableFileStream.close();
            }
            catch (IOException iOException) {}
        }
        allInstances.clear();
    }
}

