/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.digest;

import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.cram.digest.AbstractSerialDigest;
import htsjdk.samtools.cram.digest.ByteSumCombine;
import htsjdk.samtools.cram.digest.Crc32Hasher;
import htsjdk.samtools.cram.digest.IntegerSumCombine;
import htsjdk.samtools.cram.digest.MessageDigestHasher;
import htsjdk.samtools.cram.digest.SERIES;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public class ContentDigests {
    public static final EnumSet<KNOWN_DIGESTS> ALL = EnumSet.allOf(KNOWN_DIGESTS.class);
    public static final EnumSet<KNOWN_DIGESTS> CRC32 = EnumSet.of(KNOWN_DIGESTS.BD, KNOWN_DIGESTS.SD);
    private static final Log log = Log.getInstance(ContentDigests.class);
    private List<Digester> digesters = new LinkedList<Digester>();

    public static ContentDigests create(EnumSet<KNOWN_DIGESTS> enumSet) {
        LinkedList<Digester> linkedList = new LinkedList<Digester>();
        for (KNOWN_DIGESTS kNOWN_DIGESTS : enumSet) {
            linkedList.add(kNOWN_DIGESTS.createDigester());
        }
        return new ContentDigests(linkedList);
    }

    public static ContentDigests create(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        LinkedList<Digester> linkedList = new LinkedList<Digester>();
        for (SAMBinaryTagAndValue sAMBinaryTagAndValue2 = sAMBinaryTagAndValue; sAMBinaryTagAndValue2 != null; sAMBinaryTagAndValue2 = sAMBinaryTagAndValue2.getNext()) {
            String string = SAMTagUtil.getSingleton().makeStringTag(sAMBinaryTagAndValue2.tag);
            try {
                KNOWN_DIGESTS kNOWN_DIGESTS = KNOWN_DIGESTS.valueOf(string);
                linkedList.add(kNOWN_DIGESTS.createDigester());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new ContentDigests(linkedList);
    }

    private ContentDigests(List<Digester> list) {
        this.digesters = list;
    }

    void add(SAMRecord sAMRecord) {
        for (Digester digester : this.digesters) {
            digester.add(sAMRecord);
        }
    }

    public void add(CramCompressionRecord cramCompressionRecord) {
        for (Digester digester : this.digesters) {
            digester.addCramRecord(cramCompressionRecord);
        }
    }

    public void addSAMRecords(Iterable<SAMRecord> iterable) {
        for (SAMRecord sAMRecord : iterable) {
            this.add(sAMRecord);
        }
    }

    public void addCramRecords(Iterable<CramCompressionRecord> iterable) {
        for (CramCompressionRecord cramCompressionRecord : iterable) {
            this.add(cramCompressionRecord);
        }
    }

    public SAMBinaryTagAndValue getAsTags() {
        SAMBinaryTagAndValue sAMBinaryTagAndValue = null;
        for (Digester digester : this.digesters) {
            if (sAMBinaryTagAndValue == null) {
                sAMBinaryTagAndValue = digester.toTag();
                continue;
            }
            sAMBinaryTagAndValue = sAMBinaryTagAndValue.insert(digester.toTag());
        }
        return sAMBinaryTagAndValue;
    }

    public boolean test(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        for (Digester digester : this.digesters) {
            SAMBinaryTagAndValue sAMBinaryTagAndValue2 = sAMBinaryTagAndValue.find(digester.tagCode);
            if (sAMBinaryTagAndValue2 == null) continue;
            if (!(sAMBinaryTagAndValue2.value instanceof byte[])) {
                throw new RuntimeException("Expecting a byte array but got: " + sAMBinaryTagAndValue2.value.getClass().getName());
            }
            byte[] byArray = (byte[])sAMBinaryTagAndValue2.value;
            byte[] byArray2 = digester.digest.asByteArray();
            if (!Arrays.equals(byArray, byArray2)) {
                String string = ContentDigests.toHexString(byArray);
                String string2 = ContentDigests.toHexString(byArray2);
                log.error(String.format("Content hash mismatch for tag %s, actual: %s; expected: %s", digester.tagID, string2, string));
                return false;
            }
            log.debug("Content digest ok: " + digester.tagID);
        }
        return true;
    }

    private static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", 0xFF & by).toUpperCase()).append(' ');
        }
        return stringBuilder.toString();
    }

    private static String toHexString(byte[] byArray) {
        return ContentDigests.toHex(byArray).replace(" ", "");
    }

    public static enum KNOWN_DIGESTS {
        BD{

            @Override
            Digester createDigester() {
                return new Digester(new Crc32Hasher(new IntegerSumCombine()), SERIES.BASES, this.name());
            }
        }
        ,
        SD{

            @Override
            Digester createDigester() {
                return new Digester(new Crc32Hasher(new IntegerSumCombine()), SERIES.SCORES, this.name());
            }
        }
        ,
        B5{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-512"), new ByteSumCombine(), null), SERIES.BASES, this.name());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
        }
        ,
        S5{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-512"), new ByteSumCombine(), null), SERIES.SCORES, this.name());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
        }
        ,
        B1{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-1"), new ByteSumCombine(), null), SERIES.BASES, this.name());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
        }
        ,
        S1{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-1"), new ByteSumCombine(), null), SERIES.SCORES, this.name());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(noSuchAlgorithmException);
                }
            }
        };


        abstract Digester createDigester();
    }

    private static class Digester {
        final AbstractSerialDigest<?> digest;
        final SERIES series;
        final String tagID;
        final short tagCode;

        Digester(AbstractSerialDigest<?> abstractSerialDigest, SERIES sERIES, String string) {
            this.digest = abstractSerialDigest;
            this.series = sERIES;
            this.tagID = string;
            this.tagCode = SAMTagUtil.getSingleton().makeBinaryTag(string);
        }

        void add(SAMRecord sAMRecord) {
            this.digest.add(this.series.getBytes(sAMRecord));
        }

        void addCramRecord(CramCompressionRecord cramCompressionRecord) {
            this.digest.add(this.series.getBytes(cramCompressionRecord));
        }

        SAMBinaryTagAndValue toTag() {
            return new SAMBinaryTagAndValue(this.tagCode, this.digest.asByteArray());
        }
    }
}

