/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.SAMRecordQueryNameComparator;

public class SAMSortOrderChecker {
    private final SAMFileHeader.SortOrder sortOrder;
    private SAMRecord prev;
    private final SAMRecordComparator comparator;

    public SAMSortOrderChecker(SAMFileHeader.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        switch (sortOrder) {
            case coordinate: {
                this.comparator = new SAMRecordCoordinateComparator();
                break;
            }
            case queryname: {
                this.comparator = new SAMRecordQueryNameComparator();
                break;
            }
            case duplicate: {
                this.comparator = new SAMRecordDuplicateComparator();
                break;
            }
            default: {
                this.comparator = null;
            }
        }
    }

    public boolean isSorted(SAMRecord sAMRecord) {
        if (this.comparator == null) {
            return true;
        }
        boolean bl = true;
        if (this.prev != null) {
            bl = this.comparator.fileOrderCompare(this.prev, sAMRecord) <= 0;
        }
        this.prev = sAMRecord;
        return bl;
    }

    public SAMRecord getPreviousRecord() {
        return this.prev;
    }

    public String getSortKey(SAMRecord sAMRecord) {
        switch (this.sortOrder) {
            case coordinate: {
                return sAMRecord.getReferenceName() + ":" + sAMRecord.getAlignmentStart();
            }
            case queryname: {
                return sAMRecord.getReadName();
            }
        }
        return null;
    }
}

