/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.util.CoordMath;
import java.util.ArrayList;
import java.util.Arrays;

public class QueryInterval
implements Comparable<QueryInterval> {
    public final int referenceIndex;
    public final int start;
    public final int end;
    private static final QueryInterval[] EMPTY_QUERY_INTERVAL_ARRAY = new QueryInterval[0];

    public QueryInterval(int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid reference index " + n);
        }
        this.referenceIndex = n;
        this.start = n2;
        this.end = n3;
    }

    @Override
    public int compareTo(QueryInterval queryInterval) {
        int n = this.referenceIndex - queryInterval.referenceIndex;
        if (n != 0) {
            return n;
        }
        n = this.start - queryInterval.start;
        if (n != 0) {
            return n;
        }
        if (this.end == queryInterval.end) {
            return 0;
        }
        if (this.end == 0) {
            return 1;
        }
        if (queryInterval.end == 0) {
            return -1;
        }
        return this.end - queryInterval.end;
    }

    public boolean abuts(QueryInterval queryInterval) {
        return this.referenceIndex == queryInterval.referenceIndex && this.end == queryInterval.start;
    }

    public boolean overlaps(QueryInterval queryInterval) {
        if (this.referenceIndex != queryInterval.referenceIndex) {
            return false;
        }
        int n = this.end == 0 ? Integer.MAX_VALUE : this.end;
        int n2 = queryInterval.end == 0 ? Integer.MAX_VALUE : queryInterval.end;
        return CoordMath.overlaps(this.start, n, queryInterval.start, n2);
    }

    public String toString() {
        return String.format("%d:%d-%d", this.referenceIndex, this.start, this.end);
    }

    public static QueryInterval[] optimizeIntervals(QueryInterval[] queryIntervalArray) {
        if (queryIntervalArray.length == 0) {
            return EMPTY_QUERY_INTERVAL_ARRAY;
        }
        Arrays.sort(queryIntervalArray);
        ArrayList<QueryInterval> arrayList = new ArrayList<QueryInterval>();
        QueryInterval queryInterval = queryIntervalArray[0];
        for (int i = 1; i < queryIntervalArray.length; ++i) {
            QueryInterval queryInterval2 = queryIntervalArray[i];
            if (queryInterval.abuts(queryInterval2) || queryInterval.overlaps(queryInterval2)) {
                int n = queryInterval.end == 0 || queryInterval2.end == 0 ? 0 : Math.max(queryInterval.end, queryInterval2.end);
                queryInterval = new QueryInterval(queryInterval.referenceIndex, queryInterval.start, n);
                continue;
            }
            arrayList.add(queryInterval);
            queryInterval = queryInterval2;
        }
        if (queryInterval != null) {
            arrayList.add(queryInterval);
        }
        return arrayList.toArray(EMPTY_QUERY_INTERVAL_ARRAY);
    }
}

