/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Bin;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BinningIndexContent {
    private final int mReferenceSequence;
    private final BinList mBinList;
    private final LinearIndex mLinearIndex;

    public BinningIndexContent(int n, BinList binList, LinearIndex linearIndex) {
        this.mReferenceSequence = n;
        this.mBinList = binList;
        this.mLinearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public boolean containsBin(Bin bin) {
        return this.mBinList.getBin(bin.getBinNumber()) != null;
    }

    public BinList getBins() {
        return this.mBinList;
    }

    int getNumberOfNonNullBins() {
        return this.mBinList.getNumberOfNonNullBins();
    }

    public List<Chunk> getAllChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Bin bin : this.mBinList) {
            if (bin.getChunkList() == null) continue;
            arrayList.addAll(bin.getChunkList());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public LinearIndex getLinearIndex() {
        return this.mLinearIndex;
    }

    public List<Chunk> getChunksOverlapping(int n, int n2) {
        BitSet bitSet = GenomicIndexUtil.regionToBins(n, n2);
        if (bitSet == null) {
            return null;
        }
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            Bin bin = this.getBins().getBin(n3);
            if (bin != null) {
                for (Chunk chunk : bin.getChunkList()) {
                    arrayList.add(chunk.clone());
                }
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return Chunk.optimizeChunkList(arrayList, this.getLinearIndex().getMinimumOffset(n));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BinningIndexContent binningIndexContent = (BinningIndexContent)object;
        if (this.mReferenceSequence != binningIndexContent.mReferenceSequence) {
            return false;
        }
        if (!this.mBinList.equals(binningIndexContent.mBinList)) {
            return false;
        }
        return this.mLinearIndex.equals(binningIndexContent.mLinearIndex);
    }

    public int hashCode() {
        int n = this.mReferenceSequence;
        n = 31 * n + this.mBinList.hashCode();
        n = 31 * n + this.mLinearIndex.hashCode();
        return n;
    }

    public static class BinList
    implements Iterable<Bin> {
        private final Bin[] mBinArray;
        public final int numberOfNonNullBins;
        public final int maxBinNumber;

        public BinList(Bin[] binArray, int n) {
            this.mBinArray = binArray;
            this.numberOfNonNullBins = n;
            this.maxBinNumber = this.mBinArray.length - 1;
        }

        Bin getBin(int n) {
            if (n > this.maxBinNumber) {
                return null;
            }
            return this.mBinArray[n];
        }

        int getNumberOfNonNullBins() {
            return this.numberOfNonNullBins;
        }

        @Override
        public Iterator<Bin> iterator() {
            return new BinIterator();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BinList binList = (BinList)object;
            if (this.maxBinNumber != binList.maxBinNumber) {
                return false;
            }
            if (this.numberOfNonNullBins != binList.numberOfNonNullBins) {
                return false;
            }
            return Arrays.equals(this.mBinArray, binList.mBinArray);
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.mBinArray);
            n = 31 * n + this.numberOfNonNullBins;
            n = 31 * n + this.maxBinNumber;
            return n;
        }

        private class BinIterator
        implements Iterator<Bin> {
            private int nextBin = 0;

            @Override
            public boolean hasNext() {
                while (this.nextBin <= BinList.this.maxBinNumber) {
                    if (BinList.this.getBin(this.nextBin) != null) {
                        return true;
                    }
                    ++this.nextBin;
                }
                return false;
            }

            @Override
            public Bin next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("This BinIterator is currently empty");
                }
                Bin bin = BinList.this.getBin(this.nextBin);
                ++this.nextBin;
                return bin;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from a bin iterator");
            }
        }
    }
}

