/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SamReader samReader) {
        if (samReader.indexing().hasBrowseableIndex()) {
            CachingBAMFileIndex cachingBAMFileIndex = (CachingBAMFileIndex)samReader.indexing().getBrowseableIndex();
            int n = cachingBAMFileIndex.getNumberOfReferences();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                BAMIndexContent bAMIndexContent = cachingBAMFileIndex.getQueryResults(i);
                for (Chunk chunk : bAMIndexContent.getAllChunks()) {
                    SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(chunk));
                    ++n2;
                    BAMRecord bAMRecord = null;
                    try {
                        bAMRecord = (BAMRecord)sAMRecordIterator.next();
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + bAMRecord + " in chunk " + chunk + " chunkCount=" + n2, exception);
                    }
                }
                LinearIndex linearIndex = bAMIndexContent.getLinearIndex();
                for (long l : linearIndex.getIndexEntries()) {
                    try {
                        if (l == 0L) continue;
                        SAMRecordIterator sAMRecordIterator = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                        BAMRecord bAMRecord = (BAMRecord)sAMRecordIterator.next();
                        ++n3;
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + n3, exception);
                    }
                }
            }
            return n2;
        }
        return 0;
    }
}

