/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createCatalogProps;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.UNIX.CatGZPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class ColumnMetaFromVcf {
    public static void main(String[] args) {
        new ColumnMetaFromVcf().getColumnMetadata("src/test/resources/tools/vep/cancer.vcf");
    }

    public List<ColumnMetaData> getColumnMetadata(String vcfFilePath) {
        List<String> headerLines = this.getHeaderLines(vcfFilePath);
        return this.toColumnMetadata(headerLines);
    }

    private List<ColumnMetaData> toColumnMetadata(List<String> headerLines) {
        ArrayList<ColumnMetaData> colMetaList = new ArrayList<ColumnMetaData>();
        for (String line : headerLines) {
            if (!line.startsWith("##INFO")) continue;
            ColumnMetaData colMeta = new ColumnMetaData();
            colMeta.columnName = "INFO." + this.between(line, "##INFO=<ID=", ",");
            String type = this.between(line, "Type=", ",");
            if (type.equals("Integer")) {
                colMeta.type = ColumnMetaData.Type.Integer;
            } else if (type.equals("Float")) {
                colMeta.type = ColumnMetaData.Type.Float;
            } else if (type.equals("Flag")) {
                colMeta.type = ColumnMetaData.Type.Boolean;
            } else if (type.equals("Character") || type.equals("String")) {
                colMeta.type = ColumnMetaData.Type.String;
            }
            colMeta.count = this.between(line, "Number=", ",");
            colMeta.description = this.between(line, "Description=\"", "\">");
            colMetaList.add(colMeta);
        }
        return colMetaList;
    }

    private String between(String full, String pre, String post) {
        if (full == null || full.length() == 0 || post == null || post.length() == 0) {
            return "";
        }
        int start = full.indexOf(pre);
        int stop = full.indexOf(post, start + pre.length());
        if (start == -1 || stop == -1) {
            return "";
        }
        return full.substring(start + pre.length(), stop);
    }

    private List<String> getHeaderLines(String vcfFilePath) {
        boolean isGzipFile = vcfFilePath.endsWith(".gz") || vcfFilePath.endsWith(".bgz");
        Pipeline pipeline = new Pipeline(new Pipe[]{isGzipFile ? new CatGZPipe("gzip") : new CatPipe(), new HeaderOnlyPipe()});
        ArrayList<String> headerLines = new ArrayList<String>();
        pipeline.setStarts(Arrays.asList(vcfFilePath));
        while (pipeline.hasNext()) {
            headerLines.add((String)pipeline.next());
        }
        return headerLines;
    }

    private class HeaderOnlyPipe
    extends AbstractPipe<String, String> {
        private HeaderOnlyPipe() {
        }

        protected String processNextStart() throws NoSuchElementException {
            String line = (String)this.starts.next();
            if (line.startsWith("#")) {
                return line;
            }
            throw new NoSuchElementException("Done with header lines");
        }
    }
}

