/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class HapmapFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"CEU.otherallele_freq", "CHB.otherallele_freq", "JPT.otherallele_freq", "YRI.otherallele_freq"};
    private static final JsonPath PATH_CEU_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Filter[])new Filter[0]);
    private static final JsonPath PATH_CHB_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Filter[])new Filter[0]);
    private static final JsonPath PATH_JPT_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[2], (Filter[])new Filter[0]);
    private static final JsonPath PATH_YRI_MAF = JsonPath.compile((String)JSON_DRILL_PATHS[3], (Filter[])new Filter[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.HAPMAP;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("HapMap.CEU_MAF", "HapMap.YRI_MAF", "HapMap.JPT_MAF", "HapMap.CHB_MAF");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_CEU_MAF, json), FormatUtils.drill(PATH_YRI_MAF, json), FormatUtils.drill(PATH_JPT_MAF, json), FormatUtils.drill(PATH_CHB_MAF, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }
}

