/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SameVariantCommand
implements CommandPlugin {
    private static final char OPTION_COLUMN = 'c';
    private static final char OPTION_TABIX_FILE = 'd';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        try {
            int column = -1;
            if (line.hasOption('c')) {
                column = Integer.parseInt(line.getOptionValue('c'));
            }
            ArrayList<Object> tabixFiles = new ArrayList<Object>();
            if (line.hasOption('d')) {
                for (String value : line.getOptionValues('d')) {
                    tabixFiles.add(value);
                }
            }
            int historyPosition = column;
            ArrayList<SameVariantPipe> chain = new ArrayList<SameVariantPipe>();
            ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
            for (String string : tabixFiles) {
                chain.add(new SameVariantPipe(string, historyPosition));
                historyPosition = historyPosition < 0 ? --historyPosition : ++historyPosition;
                metadataList.add(new Metadata(new File(string).getCanonicalPath(), this.operation));
            }
            HistoryInPipe preLogic = new HistoryInPipe(metadataList);
            Pipeline pipeline = new Pipeline(chain);
            HistoryOutPipe postLogic = new HistoryOutPipe();
            this.mPipeline.execute(preLogic, pipeline, postLogic);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            throw e;
        }
    }
}

