/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFTPStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class SeekableStreamFactory {
    private static final ISeekableStreamFactory DEFAULT_FACTORY;
    private static ISeekableStreamFactory currentFactory;

    private SeekableStreamFactory() {
    }

    public static void setInstance(ISeekableStreamFactory iSeekableStreamFactory) {
        currentFactory = iSeekableStreamFactory;
    }

    public static ISeekableStreamFactory getInstance() {
        return currentFactory;
    }

    public static boolean isFilePath(String string) {
        return !string.startsWith("http:") && !string.startsWith("https:") && !string.startsWith("ftp:");
    }

    static {
        currentFactory = DEFAULT_FACTORY = new DefaultSeekableStreamFactory();
    }

    private static class DefaultSeekableStreamFactory
    implements ISeekableStreamFactory {
        private DefaultSeekableStreamFactory() {
        }

        @Override
        public SeekableStream getStreamFor(URL uRL) throws IOException {
            return this.getStreamFor(uRL.toExternalForm());
        }

        @Override
        public SeekableStream getStreamFor(String string) throws IOException {
            if (string.startsWith("http:") || string.startsWith("https:")) {
                URL uRL = new URL(string);
                return new SeekableHTTPStream(uRL);
            }
            if (string.startsWith("ftp:")) {
                return new SeekableFTPStream(new URL(string));
            }
            return new SeekableFileStream(new File(string));
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream seekableStream) {
            return this.getBufferedStream(seekableStream, 512000);
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream seekableStream, int n) {
            if (n == 0) {
                return seekableStream;
            }
            return new SeekableBufferedStream(seekableStream, n);
        }
    }
}

