/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.GolombRiceIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombRiceIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.GOLOMB_RICE;
    private int offset;
    private int m;

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int n, int n2) {
        GolombRiceIntegerEncoding golombRiceIntegerEncoding = new GolombRiceIntegerEncoding();
        golombRiceIntegerEncoding.offset = n;
        golombRiceIntegerEncoding.m = n2;
        return new EncodingParams(ENCODING_ID, golombRiceIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, byteBuffer);
        ITF8.writeUnsignedITF8(this.m, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.offset = ITF8.readUnsignedITF8(byteBuffer);
        this.m = ITF8.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        return new GolombRiceIntegerCodec(this.offset, this.m);
    }
}

