/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalByteCodec
extends AbstractBitCodec<Byte> {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    public ExternalByteCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public Byte read(BitInputStream bitInputStream) throws IOException {
        return (byte)this.inputStream.read();
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Byte by) throws IOException {
        this.outputStream.write(by.byteValue());
        return 8L;
    }

    @Override
    public long numberOfBits(Byte by) {
        return 8L;
    }

    @Override
    public Byte read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] byArray, int n, int n2) throws IOException {
        InputStreamUtils.readFully(this.inputStream, byArray, n, n2);
    }
}

