/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class ByteArrayStopEncoding
implements Encoding<byte[]> {
    private static final EncodingID ID = EncodingID.BYTE_ARRAY_STOP;
    private byte stopByte = 0;
    private int externalId;

    public ByteArrayStopEncoding() {
    }

    @Override
    public EncodingID id() {
        return ID;
    }

    private ByteArrayStopEncoding(byte by, int n) {
        this.stopByte = by;
        this.externalId = n;
    }

    public static EncodingParams toParam(byte by, int n) {
        ByteArrayStopEncoding byteArrayStopEncoding = new ByteArrayStopEncoding(by, n);
        return new EncodingParams(ID, byteArrayStopEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(this.stopByte);
        ITF8.writeUnsignedITF8(this.externalId, byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.stopByte = byteBuffer.get();
        this.externalId = ITF8.readUnsignedITF8(byteBuffer);
    }

    @Override
    public BitCodec<byte[]> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        InputStream inputStream = map == null ? null : map.get(this.externalId);
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = map2 == null ? null : map2.get(this.externalId);
        return new ByteArrayStopCodec(this.stopByte, inputStream, exposedByteArrayOutputStream);
    }

    public static class ByteArrayStopCodec
    extends AbstractBitCodec<byte[]> {
        private final int stop;
        private final InputStream inputStream;
        private final OutputStream outputStream;
        private final ByteArrayOutputStream readingBAOS = new ByteArrayOutputStream();
        private int b;

        public ByteArrayStopCodec(byte by, InputStream inputStream, OutputStream outputStream) {
            this.stop = 0xFF & by;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public byte[] read(BitInputStream bitInputStream) throws IOException {
            this.readingBAOS.reset();
            while ((this.b = this.inputStream.read()) != -1 && this.b != this.stop) {
                this.readingBAOS.write(this.b);
            }
            return this.readingBAOS.toByteArray();
        }

        @Override
        public byte[] read(BitInputStream bitInputStream, int n) throws IOException {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public long write(BitOutputStream bitOutputStream, byte[] byArray) throws IOException {
            this.outputStream.write(byArray);
            this.outputStream.write(this.stop);
            return byArray.length + 1;
        }

        @Override
        public long numberOfBits(byte[] byArray) {
            return byArray.length + 1;
        }
    }
}

