/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    private final int build;

    public Version(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.build = n3;
    }

    public Version(String string) {
        String[] stringArray = string.split("[\\.\\-b]");
        this.major = Integer.valueOf(stringArray[0]);
        this.minor = Integer.valueOf(stringArray[1]);
        this.build = stringArray.length > 3 ? Integer.valueOf(stringArray[3]) : 0;
    }

    public String toString() {
        if (this.build > 0) {
            return String.format("%d.%d-b%d", this.major, this.minor, this.build);
        }
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public int compareTo(Version version) {
        if (version == null) {
            return -1;
        }
        if (this.major - version.major != 0) {
            return this.major - version.major;
        }
        if (this.minor - version.minor != 0) {
            return this.minor - version.minor;
        }
        if (this.build < 1 || version.build < 1) {
            return 0;
        }
        return this.build - version.build;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor;
    }

    public boolean compatibleWith(Version version) {
        return this.compareTo(version) >= 0;
    }
}

