/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Murmur3;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;

class ConstantMemoryDownsamplingIterator
extends DownsamplingIterator {
    private final PeekableIterator<SAMRecord> underlyingIterator;
    private final int maxHashValue;
    private final Murmur3 hasher;

    ConstantMemoryDownsamplingIterator(Iterator<SAMRecord> iterator, double d, int n) {
        super(d);
        this.hasher = new Murmur3(n);
        this.underlyingIterator = new PeekableIterator<SAMRecord>(iterator);
        this.maxHashValue = Integer.MIN_VALUE + (int)Math.round(4.294967295E9 * d);
        this.advanceToNextAcceptedRead();
    }

    @Override
    public boolean hasNext() {
        return this.underlyingIterator.hasNext();
    }

    private boolean advanceToNextAcceptedRead() {
        while (this.underlyingIterator.hasNext() && this.hasher.hashUnencodedChars(this.underlyingIterator.peek().getReadName()) > this.maxHashValue) {
            this.underlyingIterator.next();
            this.recordDiscardedRecord();
        }
        return this.underlyingIterator.hasNext();
    }

    @Override
    public SAMRecord next() {
        SAMRecord sAMRecord = this.underlyingIterator.next();
        this.recordAcceptedRecord();
        this.advanceToNextAcceptedRead();
        return sAMRecord;
    }
}

