/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.EmptyRichLocation;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.ontology.ComparableTerm;

public class CompoundRichLocation
extends SimpleRichLocation
implements RichLocation {
    protected List members;
    protected int size = 0;

    public static ComparableTerm getJoinTerm() {
        return RichObjectFactory.getDefaultOntology().getOrCreateTerm("join");
    }

    public static ComparableTerm getOrderTerm() {
        return RichObjectFactory.getDefaultOntology().getOrCreateTerm("order");
    }

    public CompoundRichLocation(Collection members) {
        this(CompoundRichLocation.getJoinTerm(), members);
    }

    public CompoundRichLocation(ComparableTerm term, Collection members) {
        if (term == null) {
            throw new IllegalArgumentException("Term cannot be null");
        }
        if (members == null || members.size() < 2) {
            throw new IllegalArgumentException("Must have at least two members");
        }
        if (RichLocation.Tools.isMultiSource(members)) {
            throw new IllegalArgumentException("All members must be from the same source");
        }
        this.term = term;
        this.members = new ArrayList();
        for (Object o : members) {
            if (!(o instanceof RichLocation)) {
                o = RichLocation.Tools.enrich((Location)o);
            }
            RichLocation rl = (RichLocation)o;
            this.members.add(rl);
            this.setCrossRef(rl.getCrossRef());
            this.circularLength = rl.getCircularLength();
            this.setStrand(rl.getStrand());
            this.size += rl.getMax() - rl.getMin();
            if (this.getMinPosition() == null) {
                this.setMinPosition(rl.getMinPosition());
            } else {
                this.setMinPosition(this.posmin(this.getMinPosition(), rl.getMinPosition()));
            }
            if (this.getMaxPosition() == null) {
                this.setMaxPosition(rl.getMaxPosition());
                continue;
            }
            this.setMaxPosition(this.posmax(this.getMaxPosition(), rl.getMaxPosition()));
        }
    }

    protected CompoundRichLocation() {
    }

    public void sort() {
        Collections.sort(this.members);
    }

    public void setFeature(RichFeature feature) throws ChangeVetoException {
        super.setFeature(feature);
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            ((RichLocation)i.next()).setFeature(feature);
        }
    }

    public Annotation getAnnotation() {
        return this.getRichAnnotation();
    }

    public RichAnnotation getRichAnnotation() {
        return RichAnnotation.EMPTY_ANNOTATION;
    }

    public Set getNoteSet() {
        return RichAnnotation.EMPTY_ANNOTATION.getNoteSet();
    }

    public void setNoteSet(Set notes) throws ChangeVetoException {
        throw new ChangeVetoException("Cannot annotate compound locations.");
    }

    public void setCircularLength(int sourceSeqLength) throws ChangeVetoException {
        super.setCircularLength(sourceSeqLength);
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            ((RichLocation)i.next()).setCircularLength(sourceSeqLength);
        }
    }

    public Iterator blockIterator() {
        ArrayList sortedMembers = new ArrayList(this.members);
        Collections.sort(sortedMembers);
        return sortedMembers.iterator();
    }

    public boolean isContiguous() {
        return false;
    }

    public boolean contains(int p) {
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            if (!((RichLocation)i.next()).contains(p)) continue;
            return true;
        }
        return false;
    }

    public Location getDecorator(Class decoratorClass) {
        return null;
    }

    public Location newInstance(Location loc) {
        return loc;
    }

    public Location translate(int dist) {
        if (this.members.isEmpty()) {
            return this;
        }
        ArrayList<Location> newmembers = new ArrayList<Location>();
        for (RichLocation rl : this.members) {
            newmembers.add(rl.translate(dist));
        }
        return new CompoundRichLocation(this.getTerm(), newmembers);
    }

    public boolean contains(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return l.contains(this);
        }
        RichLocation rl = (RichLocation)l;
        if (rl instanceof CompoundRichLocation) {
            CompoundRichLocation crl = (CompoundRichLocation)rl;
            HashMap matches = new HashMap();
            Iterator<Object> i = crl.members.iterator();
            while (i.hasNext()) {
                matches.put(i.next(), Boolean.FALSE);
            }
            for (RichLocation member : this.members) {
                for (Map.Entry entry : matches.entrySet()) {
                    RichLocation match;
                    if (entry.getValue().equals(Boolean.TRUE) || !member.contains(match = (RichLocation)entry.getKey())) continue;
                    entry.setValue(Boolean.TRUE);
                }
            }
            i = matches.values().iterator();
            while (i.hasNext()) {
                if (!i.next().equals(Boolean.FALSE)) continue;
                return false;
            }
            return true;
        }
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            if (!((RichLocation)i.next()).contains(rl)) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(Location l) {
        for (RichLocation rl : this.members) {
            if (!rl.overlaps(l)) continue;
            return true;
        }
        return false;
    }

    public Location union(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return this;
        }
        ArrayList<Location> members = new ArrayList<Location>();
        members.addAll(RichLocation.Tools.flatten(this));
        members.addAll(RichLocation.Tools.flatten((RichLocation)l));
        return RichLocation.Tools.construct(RichLocation.Tools.merge(members));
    }

    public Location intersection(Location l) {
        if (!(l instanceof RichLocation)) {
            l = RichLocation.Tools.enrich(l);
        }
        if (l instanceof EmptyRichLocation) {
            return l;
        }
        if (l instanceof CompoundRichLocation) {
            Collection<Location> theirMembers = RichLocation.Tools.flatten((RichLocation)l);
            TreeSet<Location> results = new TreeSet<Location>();
            for (RichLocation richLocation : theirMembers) {
                results.add(this.intersection(richLocation));
            }
            return RichLocation.Tools.construct(RichLocation.Tools.merge(results));
        }
        TreeSet<Location> results = new TreeSet<Location>();
        for (RichLocation member : this.members) {
            results.add(member.intersection(l));
        }
        return RichLocation.Tools.construct(RichLocation.Tools.merge(results));
    }

    public void setCrossRefResolver(CrossReferenceResolver r) {
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            ((RichLocation)i.next()).setCrossRefResolver(r);
        }
    }

    public SymbolList symbols(SymbolList seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Sequence cannot be null");
        }
        ArrayList<Symbol> res = new ArrayList<Symbol>();
        for (RichLocation l : this.members) {
            res.addAll(l.symbols(seq).toList());
        }
        try {
            return new SimpleSymbolList(seq.getAlphabet(), res);
        }
        catch (IllegalSymbolException ex) {
            throw new RuntimeException("Could not build compound sequence string", ex);
        }
    }

    public void setTerm(ComparableTerm term) throws ChangeVetoException {
        if (term == null) {
            throw new ChangeVetoException("Cannot set term to null");
        }
        super.setTerm(term);
    }

    public int hashCode() {
        int code = 17;
        code = 31 * code + this.getTerm().hashCode();
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            code = 31 * i.next().hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location them = (Location)o;
        if (them.isContiguous()) {
            return false;
        }
        Iterator i1 = this.blockIterator();
        Iterator<Location> i2 = them.blockIterator();
        while (i1.hasNext() && i2.hasNext()) {
            Location l2;
            Location l1 = (Location)i1.next();
            if (l1.equals(l2 = i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int compareTo(Object o) {
        Location fo = (Location)o;
        if (this.equals(fo)) {
            return 0;
        }
        return this.getMin() - fo.getMin();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTerm());
        sb.append(":[");
        Iterator i = this.blockIterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

