/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.biorAPI.resources.Genome;
import edu.mayo.pipes.JSON.lookup.LookupPipe;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.senders.Sender;
import edu.mayo.senders.SystemOutSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class Variant2JSONPipe
extends AbstractPipe<History, History> {
    private LookupPipe rsIDLookup;
    private Genome genome;
    private String genomeBuild;
    private Sender sender;
    private int dataLineNumber = 0;
    private boolean dumpWarnings = false;
    private int warningCount = 0;
    private int identifierCol = -1;
    private int allele1Col = -1;
    private int allele2Col = -1;
    private int chromosomeCol = -1;
    private int positionCol = -1;
    private int allCol = -1;
    private int posCols = -1;
    private int headerSize = 0;
    private List<History> mResults = null;
    private boolean mInitialized = false;
    private static final JsonPath chromPath = JsonPath.compile((String)"CHROM", (Filter[])new Filter[0]);
    private static final JsonPath posPath = JsonPath.compile((String)"POS", (Filter[])new Filter[0]);
    private static final int kIdentifierCol = 0;
    private static final int kChromosomeCol = 1;
    private static final int kPositionCol = 2;
    private static final int kAllele1Col = 3;
    private static final int kAllele2Col = 4;
    private static final String kRsIDStart = "rs";
    private static final int kRsIDStartLen = "rs".length();
    private static final String kColDelimiter = "\t";
    private static final String kPlusStrand = "+";
    private static final String kDefaultGenomeBuild = "GRCh37.p13";
    private static final String kWarning = "WARNING";
    private static final int kWarningLen = "WARNING".length();
    private static final String kNoRSIDFoundWarning = "No match found for ";
    private static final String kPositionMatchFailedWarning = "The rsID found has a different position than was specified";
    private static final String kFlipAllelesWarning = "Neither of the alleles supplied matched the reference, so swapped strands";
    private static final String[] kBases = new String[]{"A", "C", "G", "T"};
    private static final boolean kReturnBlanks = false;
    protected static final boolean kRemoveBlanks = true;
    private static final String[] kColumnNames = new String[]{"ID", "CHROM", "POS", "ALLELE1", "ALLELE2"};
    private static final String kNoHeader = "Must have a header";
    private static final String kVCFEmpty = ".";

    public Variant2JSONPipe(LookupPipe rsIDLookup, Sender sender) {
        this(rsIDLookup, sender, kDefaultGenomeBuild);
    }

    public Variant2JSONPipe(LookupPipe rsIDLookup, Sender sender, String genomeBuild) {
        this.rsIDLookup = rsIDLookup;
        this.genomeBuild = !Variant2JSONPipe.isEmpty(genomeBuild) ? genomeBuild : kDefaultGenomeBuild;
        if (sender != null) {
            this.sender = sender;
            this.dumpWarnings = true;
        } else {
            this.sender = new SystemOutSender("stderr");
        }
    }

    protected History getHistory() {
        if (this.mInitialized) {
            return (History)this.starts.next();
        }
        History history = (History)this.starts.next();
        ArrayList<String> headerRows = new ArrayList<String>();
        String line = history.getMergedData(kColDelimiter);
        while (line.startsWith("#")) {
            headerRows.add(line);
            if (this.starts.hasNext()) {
                history = (History)this.starts.next();
                line = history.getMergedData(kColDelimiter);
                continue;
            }
            this.initializeMetaData(history, headerRows);
            break;
        }
        this.initializeMetaData(history, headerRows);
        this.mInitialized = true;
        return history;
    }

    private void initializeMetaData(History history, List<String> headerRows) {
        String colHeaderLine;
        HistoryMetaData hMeta = new HistoryMetaData(headerRows);
        int size = headerRows.size();
        if (size > 0 && (colHeaderLine = headerRows.get(size - 1)).startsWith("#")) {
            List columns = hMeta.getColumns();
            colHeaderLine = colHeaderLine.substring(1);
            for (String colName : colHeaderLine.split(kColDelimiter)) {
                ColumnMetaData cmd = new ColumnMetaData(colName);
                columns.add(cmd);
            }
        }
        history.setMetaData(hMeta);
    }

    protected History processNextStart() throws NoSuchElementException {
        int numCols;
        int numAdd;
        History history;
        if (this.mResults != null && !this.mResults.isEmpty()) {
            return this.mResults.remove(0);
        }
        try {
            history = (History)this.starts.next();
        }
        catch (NoSuchElementException done) {
            if (this.dumpWarnings) {
                this.sender.write("Had " + this.warningCount + " warnings");
            }
            throw done;
        }
        ++this.dataLineNumber;
        if (this.headerSize == 0) {
            this.getHeaderInformation(history);
        }
        if ((numAdd = this.headerSize - (numCols = history.size())) > 0) {
            for (int i = 0; i < numAdd; ++i) {
                history.add((Object)"");
            }
        }
        if (numCols < this.allCol) {
            String rsID;
            if (numCols > this.posCols) {
                return this.processPosition(history);
            }
            if (numCols > this.identifierCol && Variant2JSONPipe.isRsID(rsID = (String)history.get(this.identifierCol))) {
                return this.processRsID(history, false);
            }
            StringBuilder errorMesg = new StringBuilder();
            errorMesg.append("Invalid variant line at data line # ");
            errorMesg.append(this.dataLineNumber);
            errorMesg.append(".\nThe variant format requires ");
            errorMesg.append(this.allCol + 1);
            errorMesg.append(" fixed fields per data line, but found only ");
            errorMesg.append(numCols);
            errorMesg.append(" field(s).\n");
            errorMesg.append("Make sure the variant file has the necessary fields delimited by TAB characters.\n");
            errorMesg.append("Invalid variant line content: \"");
            errorMesg.append(history.getMergedData(kColDelimiter));
            errorMesg.append("\"");
            this.reportError(errorMesg.toString());
        }
        return this.processPosition(history);
    }

    private void getHeaderInformation(History history) {
        HistoryMetaData metaData = history.getMetaData();
        if (metaData == null) {
            this.reportError(kNoHeader);
        }
        List columns = metaData.getColumns();
        this.headerSize = columns.size() - 1;
        for (int i = 0; i < this.headerSize; ++i) {
            ColumnMetaData theColumn = (ColumnMetaData)columns.get(i);
            String name = theColumn.columnName.toUpperCase();
            if (name.equals(kColumnNames[1])) {
                this.chromosomeCol = i;
                this.allCol = Math.max(this.allCol, this.chromosomeCol);
                continue;
            }
            if (name.equals(kColumnNames[2])) {
                this.positionCol = i;
                this.posCols = Math.max(this.posCols, this.positionCol);
                this.allCol = Math.max(this.allCol, this.posCols);
                continue;
            }
            if (name.equals(kColumnNames[0])) {
                this.identifierCol = i;
                this.posCols = Math.max(this.posCols, this.identifierCol);
                this.allCol = Math.max(this.allCol, this.posCols);
                continue;
            }
            if (name.equals(kColumnNames[3])) {
                this.allele1Col = i;
                this.allCol = Math.max(this.allCol, this.allele1Col);
                continue;
            }
            if (!name.equals(kColumnNames[4])) continue;
            this.allele2Col = i;
            this.allCol = Math.max(this.allCol, this.allele2Col);
        }
    }

    private static final boolean isRsID(String testStr) {
        if (Variant2JSONPipe.isEmpty(testStr)) {
            return false;
        }
        if (!testStr.startsWith(kRsIDStart)) {
            return false;
        }
        try {
            Long.parseLong(testStr.substring(kRsIDStartLen));
            return true;
        }
        catch (NumberFormatException oops) {
            return false;
        }
    }

    private History processRsID(History history, boolean removeBlanks) {
        this.mResults = this.rsIDLookup.processHistory(history, this.identifierCol);
        History result = this.mResults.remove(0);
        boolean wasBlank = Variant2JSONPipe.removeBlank(result);
        if (wasBlank) {
            if (removeBlanks) {
                return null;
            }
            String rsID = (String)history.get(this.identifierCol);
            if (Variant2JSONPipe.isRsID(rsID)) {
                result.add((Object)this.addWarning(null, kNoRSIDFoundWarning + rsID));
            } else {
                result.add((Object)"{}");
            }
        }
        return result;
    }

    private History processPosition(History history) {
        History result;
        if (Variant2JSONPipe.isRsID((String)history.get(this.identifierCol)) && (result = this.processRsID(history, true)) != null) {
            return this.validateResult(result);
        }
        this.mResults = this.getPossibleHistories(history);
        return this.mResults.remove(0);
    }

    private History validateResult(History result) {
        int last = result.size() - 1;
        String json = (String)result.get(last);
        String chromosome = this.parseChromosome((String)chromPath.read(json));
        String position = (String)posPath.read(json);
        String chrom = this.getFromColumn(result, this.chromosomeCol);
        String pos = this.getFromColumn(result, this.positionCol);
        if (!Variant2JSONPipe.isVCFEmpty(chrom) && !chrom.equalsIgnoreCase(chromosome) || !Variant2JSONPipe.isVCFEmpty(pos) && !pos.equals(position)) {
            result.set(last, (Object)this.addWarning(json, kPositionMatchFailedWarning));
        }
        return result;
    }

    private String getFromColumn(History result, int col) {
        if (col < 0) {
            return "";
        }
        return (String)result.get(col);
    }

    private String parseChromosome(String chromosome) {
        block9: {
            if (Variant2JSONPipe.isVCFEmpty(chromosome)) {
                return chromosome;
            }
            try {
                int chrom = Integer.parseInt(chromosome);
                switch (chrom) {
                    case 23: {
                        return "X";
                    }
                    case 24: {
                        return "Y";
                    }
                    case 25: {
                        return "XY";
                    }
                    case 26: {
                        return "M";
                    }
                }
            }
            catch (NumberFormatException oops) {
                if (!chromosome.equalsIgnoreCase("MT")) break block9;
                return "M";
            }
        }
        return chromosome;
    }

    private List<History> getPossibleHistories(History history) {
        ArrayList<History> results = new ArrayList<History>();
        String chrom = this.getFromColumn(history, this.chromosomeCol);
        String pos = this.getFromColumn(history, this.positionCol);
        String allele1 = this.getFromColumn(history, this.allele1Col);
        String allele2 = this.getFromColumn(history, this.allele2Col);
        try {
            if (this.genome == null) {
                this.genome = new Genome();
            }
            String ref = this.genome.getReferenceSequence(this.genomeBuild, chrom, pos, pos, kPlusStrand);
            int curBP = Integer.parseInt(pos);
            if (!allele1.isEmpty() || !allele2.isEmpty()) {
                this.addWithAlleles(results, history, chrom, ref, allele1, allele2, curBP);
            } else {
                for (String alt : kBases) {
                    if (alt.equals(ref)) continue;
                    results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, alt, curBP, curBP)));
                }
            }
        }
        catch (NumberFormatException oops) {
            StringBuilder errorMesg = new StringBuilder();
            errorMesg.append("Invalid variant line at data line # ");
            errorMesg.append(this.dataLineNumber);
            errorMesg.append(".\nThe variant format requires an integer for position, but got '");
            errorMesg.append(pos);
            errorMesg.append("'.\n");
            errorMesg.append("Make sure the variant file has the necessary fields delimited by TAB characters.\n");
            errorMesg.append("Invalid variant line content: \"");
            errorMesg.append(history.getMergedData(kColDelimiter));
            errorMesg.append("\"");
            this.reportError(errorMesg.toString());
        }
        catch (IOException oops) {
            oops.printStackTrace();
            this.reportError("Could not open Genome Catalog");
        }
        return results;
    }

    private void addWithAlleles(List<History> results, History history, String chrom, String ref, String allele1, String allele2, int curBP) {
        String allele;
        if (ref.equalsIgnoreCase(allele1)) {
            allele = allele2;
        } else if (ref.equalsIgnoreCase(allele2)) {
            allele = allele1;
        } else {
            String invert1 = Variant2JSONPipe.invert(allele1);
            if (invert1.equals(allele2)) {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele1, curBP, curBP)));
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele2, curBP, curBP)));
            } else if (allele1.equals(allele2) || allele2.isEmpty()) {
                results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele1, curBP, curBP)));
            } else {
                this.addWithAlleles(results, history, chrom, ref, invert1, Variant2JSONPipe.invert(allele2), curBP);
                History result = results.get(results.size() - 1);
                int last = result.size() - 1;
                String json = (String)result.get(last);
                result.set(last, (Object)this.addWarning(json, kFlipAllelesWarning));
            }
            return;
        }
        if (!allele.isEmpty()) {
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, allele, curBP, curBP)));
        } else {
            results.add(Variant2JSONPipe.copyAppend(history, Variant2JSONPipe.makeGoldenJSON(chrom, ref, ref, curBP, curBP)));
        }
    }

    private static final String invert(String allele) {
        if (allele.equals("A")) {
            return "T";
        }
        if (allele.equals("T")) {
            return "A";
        }
        if (allele.equals("C")) {
            return "G";
        }
        return "C";
    }

    private static final String makeGoldenJSON(String chrom, String ref, String alt, int start, int end) {
        StringBuilder result = new StringBuilder(30);
        result.append('{');
        Variant2JSONPipe.addJSONString(result, "_landmark", chrom, false, false);
        Variant2JSONPipe.addJSONString(result, "_refAllele", ref, true, false);
        Variant2JSONPipe.addJSONString(result, "_altAlleles", alt, true, true);
        Variant2JSONPipe.addJSONInteger(result, "_minBP", start, true);
        Variant2JSONPipe.addJSONInteger(result, "_maxBP", end, true);
        result.append('}');
        return result.toString();
    }

    private String addWarning(String json, String error) throws InvalidPipeInputException {
        ++this.warningCount;
        if (Variant2JSONPipe.isJSONEmpty(json)) {
            StringBuilder result = new StringBuilder(error.length() + kWarningLen + 6);
            result.append("{\"");
            result.append(kWarning);
            result.append("\":\"");
            result.append(error);
            result.append("\"}");
            return result.toString();
        }
        JsonParser parser = new JsonParser();
        JsonElement root = parser.parse(json);
        root.getAsJsonObject().addProperty(kWarning, error);
        return root.toString();
    }

    private void reportError(String error) throws InvalidPipeInputException {
        this.sender.write(error);
        throw new InvalidPipeInputException(error, (Pipe)this);
    }

    private static final void addJSONString(StringBuilder result, String key, String value, boolean havePrevious, boolean multi) {
        if (havePrevious) {
            result.append(',');
        }
        result.append('\"');
        result.append(key);
        result.append("\":");
        if (multi) {
            result.append('[');
        }
        result.append('\"');
        result.append(value);
        result.append('\"');
        if (multi) {
            result.append(']');
        }
    }

    private static final void addJSONInteger(StringBuilder result, String key, int value, boolean havePrevious) {
        if (havePrevious) {
            result.append(',');
        }
        result.append('\"');
        result.append(key);
        result.append("\":");
        result.append(value);
    }

    private static final boolean removeBlank(History history) {
        int size = history.size() - 1;
        String last = (String)history.get(size);
        if ("{}".equals(last)) {
            history.remove(size);
            return true;
        }
        return false;
    }

    private static final History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add((Object)result);
        return clone;
    }

    private static final boolean isEmpty(String testStr) {
        return testStr == null || testStr.isEmpty();
    }

    private static final boolean isVCFEmpty(String testStr) {
        return testStr == null || testStr.isEmpty() || testStr.equals(kVCFEmpty);
    }

    private static final boolean isJSONEmpty(String testStr) {
        if (testStr == null) {
            return true;
        }
        return testStr.indexOf(58) < 0;
    }
}

