/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class VCFGeneratorPipe
extends AbstractPipe<History, History> {
    public final String DEFAULT_DESCRIPTION = "BioR property file missing description";
    public final String DEFAULT_TYPE = "String";
    public final String DEFAULT_NUMBER = ".";
    private static final Logger sLogger = Logger.getLogger(VCFGeneratorPipe.class);
    Map<Integer, String> biorindexes = new LinkedHashMap<Integer, String>();
    boolean modifyMetadata = false;
    AddMetadataLines amdl = new AddMetadataLines();
    public final String delimForLists = "|";
    private Gson gson = new Gson();
    private HashMap<String, LinkedHashMap<String, String>> headerLinesForHeaderKeys = null;

    protected History processNextStart() throws NoSuchElementException {
        History history = (History)this.starts.next();
        if (!this.modifyMetadata) {
            history = this.changeHeader(history);
            this.modifyMetadata = true;
        }
        history = this.modifyhistory(history, this.biorindexes);
        history = this.removeAnnotationColumns(history, this.biorindexes);
        return history;
    }

    public History changeHeader(History history) {
        int totalcolumns = history.getMetaData().getColumns().size();
        List<String> biorcolumnsFromMetadata = this.getBIORColumnsFromMetadata(history.getMetaData().getOriginalHeader());
        List<String> colsFromHeader = this.getBIORColumnsFromHeader(history.getMetaData().getColumns(), biorcolumnsFromMetadata);
        if (totalcolumns > 7 && ((ColumnMetaData)history.getMetaData().getColumns().get(7)).getColumnName().equalsIgnoreCase("INFO")) {
            this.biorindexes = this.getBiorColumnsIndexes(history, biorcolumnsFromMetadata);
        }
        if (this.headerLinesForHeaderKeys == null) {
            this.populateHeaderLinesForHeaderKeys(history);
        }
        if (biorcolumnsFromMetadata != null) {
            if (biorcolumnsFromMetadata.containsAll(colsFromHeader) && biorcolumnsFromMetadata.size() == colsFromHeader.size()) {
                HistoryMetaData hmd = this.removeColumnHeader(history.getMetaData(), this.biorindexes);
                history.getMetaData().setOriginalHeader(this.addColumnheaders(hmd.getOriginalHeader(), null, null));
            } else if (biorcolumnsFromMetadata.containsAll(colsFromHeader) && biorcolumnsFromMetadata.size() > colsFromHeader.size()) {
                List<String> biorcolumn = biorcolumnsFromMetadata;
                biorcolumn.removeAll(colsFromHeader);
                HistoryMetaData hmd = this.removeColumnHeader(history.getMetaData(), this.biorindexes);
                history.getMetaData().setOriginalHeader(this.addColumnheaders(hmd.getOriginalHeader(), null, biorcolumn));
            } else if (colsFromHeader.containsAll(biorcolumnsFromMetadata) && colsFromHeader.size() > biorcolumnsFromMetadata.size()) {
                List<String> addDefaultColumn = colsFromHeader;
                addDefaultColumn.removeAll(biorcolumnsFromMetadata);
                history.getMetaData().setOriginalHeader(this.addColumnheaders(this.removeColumnHeader(history.getMetaData(), this.biorindexes).getOriginalHeader(), addDefaultColumn, null));
            } else if (!colsFromHeader.containsAll(biorcolumnsFromMetadata) || !biorcolumnsFromMetadata.containsAll(colsFromHeader)) {
                List<String> biorcolumn = biorcolumnsFromMetadata;
                biorcolumn.removeAll(colsFromHeader);
                List<String> addDefaultColumn = colsFromHeader;
                addDefaultColumn.removeAll(biorcolumnsFromMetadata);
                history.getMetaData().setOriginalHeader(this.addColumnheaders(this.removeColumnHeader(history.getMetaData(), this.biorindexes).getOriginalHeader(), addDefaultColumn, biorcolumn));
            }
        } else {
            history.getMetaData().setOriginalHeader(this.addColumnheaders(this.removeColumnHeader(history.getMetaData(), this.biorindexes).getOriginalHeader(), colsFromHeader, null));
        }
        return history;
    }

    public Map<Integer, String> getBiorColumnsIndexes(History history, List<String> biorcolumn) {
        int totalcolumn = history.getMetaData().getColumns().size();
        List columns = history.getMetaData().getColumns();
        List originalheader = history.getMetaData().getOriginalHeader();
        LinkedHashMap<Integer, String> biorindex = new LinkedHashMap<Integer, String>();
        int indexsize = originalheader.size();
        String columnheader = (String)originalheader.get(indexsize - 1);
        if (columnheader.startsWith("#CHROM")) {
            for (int i = 0; i < columns.size(); ++i) {
                String colname = ((ColumnMetaData)columns.get(i)).getColumnName();
                if (colname.contains("bior") || colname.contains("BIOR")) {
                    biorindex.put(i, colname);
                    continue;
                }
                if (!biorcolumn.contains(colname)) continue;
                biorindex.put(i, colname);
            }
        }
        return biorindex;
    }

    public List<String> addColumnheaders(List<String> colmeta, List<String> retain, List<String> remove) {
        ArrayList<String> infoMeta = new ArrayList<String>();
        ArrayList<String> biorList = new ArrayList<String>();
        for (String info : colmeta) {
            String newInfoRow;
            if (info.startsWith("##BIOR=<ID")) {
                biorList.add(info);
            }
            if (!(info.startsWith("##BIOR=<ID") && info.contains("bior_drill") || info.startsWith("##BIOR=<ID") && info.contains("bior_annotate")) && (!info.startsWith("##BIOR=<ID") || !info.contains("bior_compress"))) continue;
            LinkedHashMap attr = this.amdl.parseHeaderLine(info);
            if (remove == null) {
                newInfoRow = this.buildInfoFromBioRAttr(attr);
                infoMeta.add(newInfoRow);
                continue;
            }
            if (remove.contains(attr.get("ID"))) continue;
            newInfoRow = this.buildInfoFromBioRAttr(attr);
            infoMeta.add(newInfoRow);
        }
        if (retain != null && !retain.isEmpty()) {
            for (String key : retain) {
                String newInfoRow = this.buildDefaultINFO(key);
                infoMeta.add(newInfoRow);
            }
        }
        int index = this.lastInfoLineNumber(colmeta);
        colmeta.addAll(index, infoMeta);
        colmeta.removeAll(biorList);
        return colmeta;
    }

    public String buildDefaultINFO(String id) {
        return this.buildINFO(id, ".", "String", "BioR property file missing description");
    }

    public String buildINFOFromBioR(String biorLine) {
        LinkedHashMap attr = this.amdl.parseHeaderLine(biorLine);
        return this.buildInfoFromBioRAttr(attr);
    }

    public String buildInfoFromBioRAttr(LinkedHashMap<String, String> attr) {
        String datatype;
        String fielddesc = attr.get(AddMetadataLines.BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString());
        if (fielddesc == null || fielddesc.length() < 1) {
            fielddesc = attr.get(AddMetadataLines.BiorMetaControlledVocabulary.DESCRIPTION.toString());
            if (fielddesc == null || fielddesc.length() < 1) {
                attr.put(AddMetadataLines.BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), "BioR property file missing description");
            } else {
                attr.put(AddMetadataLines.BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), fielddesc);
            }
        }
        if ((datatype = attr.get(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString())) == null || datatype.length() < 1) {
            attr.put(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString(), "String");
        } else if (datatype.equalsIgnoreCase(ColumnMetaData.Type.Boolean.toString())) {
            attr.put(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString(), "Flag");
        }
        String number = attr.get(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString());
        if (number == null || number.length() < 1) {
            attr.put(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString(), ".");
        }
        return this.buildINFO(attr.get("ID"), attr.get(AddMetadataLines.BiorMetaControlledVocabulary.NUMBER.toString()), attr.get(AddMetadataLines.BiorMetaControlledVocabulary.DATATYPE.toString()), attr.get(AddMetadataLines.BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString()));
    }

    public String buildINFO(String id, String number, String type, String description) {
        if (description == null) {
            description = "BioR property file missing description";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("##INFO=<ID=");
        sb.append(id);
        sb.append(",Number=");
        sb.append(number);
        sb.append(",Type=");
        sb.append(type);
        sb.append(",Description=\"");
        if (description.length() > 1) {
            sb.append(description);
        } else {
            sb.append("BioR property file missing description");
        }
        sb.append("\">");
        return sb.toString();
    }

    public HistoryMetaData removeColumnHeader(HistoryMetaData metaData, Map<Integer, String> biorindexes2) {
        List columns = metaData.getColumns();
        ArrayList<Integer> indexes = new ArrayList<Integer>(biorindexes2.keySet());
        Collections.sort(indexes);
        Collections.reverse(indexes);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            ColumnMetaData cmd = (ColumnMetaData)columns.get(j);
            columns.remove(cmd);
        }
        return metaData;
    }

    public History removeAnnotationColumns(History h, Map<Integer, String> biorindexes) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(biorindexes.keySet());
        Collections.sort(indexes);
        Collections.reverse(indexes);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            h.remove(j);
        }
        return h;
    }

    public List<String> getBIORColumnsFromMetadata(List<String> metadata) {
        ArrayList<String> columns = new ArrayList<String>();
        for (String c : metadata) {
            if (!c.startsWith("##BIOR=<ID")) continue;
            String[] ast = c.split("<")[1].replace(">", "").split(",")[0].split("=");
            columns.add(ast[1].replace("\"", ""));
        }
        return columns;
    }

    public List<String> getBIORColumnsFromHeader(List<ColumnMetaData> header, List<String> biorcolumn) {
        ArrayList<String> columns = new ArrayList<String>();
        int indexsize = header.size();
        if (header.get(0).getColumnName().startsWith("CHROM")) {
            for (ColumnMetaData cmd : header) {
                String colname = cmd.getColumnName();
                if (colname.contains("bior") || colname.contains("BIOR")) {
                    columns.add(colname);
                    continue;
                }
                if (!biorcolumn.contains(colname)) continue;
                columns.add(colname);
            }
        }
        return columns;
    }

    public String infoDataPair(String key, String value) {
        String newval = value;
        LinkedHashMap<String, String> attrs = this.headerLinesForHeaderKeys.get(key);
        if (newval.startsWith("[") && newval.endsWith("]") && newval.length() > 1) {
            newval = this.handleJsonArray(newval);
        } else if (attrs != null) {
            String delim = attrs.get(AddMetadataLines.BiorMetaControlledVocabulary.DELIMITER.toString());
            if (delim.equalsIgnoreCase("|")) {
                delim = "\\|";
            }
            newval = newval.replaceAll(delim, ",");
        } else if (newval.contains(",")) {
            newval = newval.replaceAll(",", "|");
        }
        if (newval.contains(" ")) {
            newval = newval.replaceAll(" ", "_");
        }
        if (newval.contains("=")) {
            newval = newval.replaceAll("=", ":");
        }
        if (value.contains(";")) {
            newval = newval.replaceAll(";", "|");
        }
        StringBuilder sb = new StringBuilder();
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            sb.append(";");
            sb.append(key);
        } else {
            sb.append(";");
            sb.append(key);
            sb.append("=");
            sb.append(newval);
        }
        return sb.toString();
    }

    public String handleJsonArray(String jarr) {
        StringBuilder sb = new StringBuilder();
        JsonElement jelement = new JsonParser().parse("{ \"arr\" : " + jarr + "}");
        JsonObject jobject = jelement.getAsJsonObject();
        JsonArray jarray = jobject.getAsJsonArray("arr");
        for (int i = 0; i < jarray.size(); ++i) {
            JsonElement e = jarray.get(i);
            if (jarr.contains("\"")) {
                sb.append(e.toString().replaceAll("\"", ""));
                if (i >= jarray.size() - 1) continue;
                sb.append(",");
                continue;
            }
            Double d = e.getAsDouble();
            String dstring = d.toString();
            if (dstring.endsWith(".0")) {
                sb.append(dstring.substring(0, dstring.length() - 2));
            } else {
                sb.append(dstring);
            }
            if (i >= jarray.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void populateHeaderLinesForHeaderKeys(History history) {
        AddMetadataLines amdl = new AddMetadataLines();
        this.headerLinesForHeaderKeys = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        List header = history.getMetaData().getOriginalHeader();
        for (String line : header) {
            String delim;
            if (!line.contains(delim = AddMetadataLines.BiorMetaControlledVocabulary.DELIMITER.toString())) continue;
            LinkedHashMap kv = amdl.parseHeaderLine(line);
            this.headerLinesForHeaderKeys.put((String)kv.get(AddMetadataLines.BiorMetaControlledVocabulary.ID.toString()), kv);
        }
    }

    private History modifyhistory(History history, Map<Integer, String> biorindexes2) {
        Set<Integer> indexes = biorindexes2.keySet();
        for (int value : indexes) {
            String val = null;
            if (value >= history.size() || (val = (String)history.get(value)) == null || val.isEmpty() || val.contentEquals(".") || val.startsWith("{")) continue;
            String newValue = ((String)history.get(7)).concat(this.infoDataPair(biorindexes2.get(value), val));
            if (newValue.startsWith(".;")) {
                history.set(7, (Object)newValue.replaceFirst(".;", ""));
                continue;
            }
            history.set(7, (Object)newValue);
        }
        return history;
    }

    public int lastInfoLineNumber(List<String> originalHeader) {
        int last = 0;
        int count = 0;
        for (String headerLine : originalHeader) {
            if (headerLine.startsWith("##INFO")) {
                last = count;
            }
            ++count;
        }
        if (last == 0) {
            return originalHeader.size() - 1;
        }
        return last + 1;
    }
}

